/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.util.Set;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomesCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public HomesCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            if (!player.hasPermission("SimpleTeleport.homes.other")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-player-not-found"));
                return true;
            }
            Set<String> homes = this.plugin.getDataManager().getHomeNames(target.getUniqueId());
            if (homes.isEmpty()) {
                String msg = this.plugin.getConfigManager().getMessage("home-list-other-empty", "{player}", target.getName());
                player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
                return true;
            }
            String header = this.plugin.getConfigManager().getMessage("home-list-other-header", "{player}", target.getName());
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + header);
            for (String name : homes) {
                Location loc = this.plugin.getDataManager().getHome(target.getUniqueId(), name);
                String coords = loc == null ? "No data" : String.format("World: %s\nX: %.2f\nY: %.2f\nZ: %.2f\nYaw: %.1f\nPitch: %.1f", loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()));
                TextComponent comp = new TextComponent(this.plugin.getConfigManager().getMessage("prefix") + "\u00a7e- \u00a76" + name);
                comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(coords).create()));
                comp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/home other " + target.getName() + " " + name));
                player.spigot().sendMessage((BaseComponent)comp);
            }
            return true;
        }
        Set<String> homes = this.plugin.getDataManager().getHomeNames(player.getUniqueId());
        if (homes.isEmpty()) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-list-empty"));
            return true;
        }
        player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-list-header"));
        for (String name : homes) {
            Location loc = this.plugin.getDataManager().getHome(player.getUniqueId(), name);
            String coords = loc == null ? "No data" : String.format("World: %s\nX: %.2f\nY: %.2f\nZ: %.2f\nYaw: %.1f\nPitch: %.1f", loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()));
            TextComponent comp = new TextComponent(this.plugin.getConfigManager().getMessage("prefix") + "\u00a7e- \u00a76" + name);
            comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(coords).create()));
            comp.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/home " + name));
            player.spigot().sendMessage((BaseComponent)comp);
        }
        return true;
    }
}

