/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class HomeOtherCommand
implements CommandExecutor,
TabCompleter {
    private final SimpleTeleport plugin;

    public HomeOtherCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.home.others")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        if (args.length != 2) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-homeother"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-player-not-found"));
            return true;
        }
        String homeName = args[1].toLowerCase();
        Location home = this.plugin.getDataManager().getHome(target.getUniqueId(), homeName);
        if (home == null) {
            String msg = this.plugin.getConfigManager().getMessage("home-name-not-set", "{name}", homeName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
            return true;
        }
        this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
        player.teleport(home);
        String msg = this.plugin.getConfigManager().getMessage("home-other-teleport-success", "{player}", target.getName()).replace("{name}", homeName);
        player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        Player target;
        if (args.length == 1) {
            ArrayList<String> names = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                names.add(p.getName());
            }
            return names;
        }
        if (args.length == 2 && (target = Bukkit.getPlayer((String)args[0])) != null) {
            return new ArrayList<String>(this.plugin.getDataManager().getHomeNames(target.getUniqueId()));
        }
        return Collections.emptyList();
    }
}

