/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor,
TabCompleter {
    private final SimpleTeleport plugin;

    public HomeCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.home")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("other")) {
            if (!player.hasPermission("SimpleTeleport.home.other")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-no-permission-others"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-player-not-found"));
                return true;
            }
            String homeName = args[2].toLowerCase();
            Location home = this.plugin.getDataManager().getHome(target.getUniqueId(), homeName);
            if (home == null) {
                String msg = this.plugin.getConfigManager().getMessage("home-name-not-set", "{name}", homeName);
                player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
                return true;
            }
            this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
            player.teleport(home);
            String msg = this.plugin.getConfigManager().getMessage("home-other-teleport-success", "{player}", target.getName()).replace("{name}", homeName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
            return true;
        }
        if (args.length == 1) {
            String homeName = args[0].toLowerCase();
            Location home = this.plugin.getDataManager().getHome(player.getUniqueId(), homeName);
            if (home == null) {
                String msg = this.plugin.getConfigManager().getMessage("home-name-not-set", "{name}", homeName);
                player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
                return true;
            }
            this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
            player.teleport(home);
            String msg = this.plugin.getConfigManager().getMessage("home-teleport-success", "{name}", homeName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + msg);
            return true;
        }
        if (args.length == 0) {
            Location home = this.plugin.getDataManager().getHome(player.getUniqueId(), "default");
            if (home == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-not-set"));
                return true;
            }
            this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
            player.teleport(home);
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-teleport"));
            return true;
        }
        player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-home"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            return new ArrayList<String>(this.plugin.getDataManager().getHomeNames(player.getUniqueId()));
        }
        return Collections.emptyList();
    }
}

