/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.managers;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataManager {
    private final SimpleTeleport plugin;
    private File homesFile;
    private File warpsFile;
    private File spawnFile;
    private FileConfiguration homesConfig;
    private FileConfiguration warpsConfig;
    private FileConfiguration spawnConfig;
    private final Map<UUID, Location> lastLocations = new HashMap<UUID, Location>();

    public DataManager(SimpleTeleport plugin) {
        this.plugin = plugin;
        this.setupFiles();
        this.loadData();
    }

    private void setupFiles() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.homesFile = new File(this.plugin.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create homes.yml: " + e.getMessage());
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
        this.warpsFile = new File(this.plugin.getDataFolder(), "warps.yml");
        if (!this.warpsFile.exists()) {
            try {
                this.warpsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create warps.yml: " + e.getMessage());
            }
        }
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
        this.spawnFile = new File(this.plugin.getDataFolder(), "spawn.yml");
        if (!this.spawnFile.exists()) {
            try {
                this.spawnFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create spawn.yml: " + e.getMessage());
            }
        }
        this.spawnConfig = YamlConfiguration.loadConfiguration((File)this.spawnFile);
    }

    private void loadData() {
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
        this.warpsConfig = YamlConfiguration.loadConfiguration((File)this.warpsFile);
        this.spawnConfig = YamlConfiguration.loadConfiguration((File)this.spawnFile);
    }

    public void setHome(UUID playerUUID, Location location) {
        String path = playerUUID.toString();
        this.homesConfig.set(path + ".world", (Object)location.getWorld().getName());
        this.homesConfig.set(path + ".x", (Object)location.getX());
        this.homesConfig.set(path + ".y", (Object)location.getY());
        this.homesConfig.set(path + ".z", (Object)location.getZ());
        this.homesConfig.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.homesConfig.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveHomes();
    }

    public Location getHome(UUID playerUUID) {
        String path = playerUUID.toString();
        if (!this.homesConfig.contains(path)) {
            return null;
        }
        String worldName = this.homesConfig.getString(path + ".world");
        if (worldName == null || Bukkit.getWorld((String)worldName) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)worldName), this.homesConfig.getDouble(path + ".x"), this.homesConfig.getDouble(path + ".y"), this.homesConfig.getDouble(path + ".z"), (float)this.homesConfig.getDouble(path + ".yaw"), (float)this.homesConfig.getDouble(path + ".pitch"));
    }

    public boolean hasHome(UUID playerUUID) {
        return this.homesConfig.contains(playerUUID.toString());
    }

    public void deleteHome(UUID playerUUID) {
        String path = playerUUID.toString();
        this.homesConfig.set(path, null);
        this.saveHomes();
    }

    public void setWarp(String name, Location location) {
        String path = name.toLowerCase();
        this.warpsConfig.set(path + ".world", (Object)location.getWorld().getName());
        this.warpsConfig.set(path + ".x", (Object)location.getX());
        this.warpsConfig.set(path + ".y", (Object)location.getY());
        this.warpsConfig.set(path + ".z", (Object)location.getZ());
        this.warpsConfig.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.warpsConfig.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveWarps();
    }

    public Location getWarp(String name) {
        String path = name.toLowerCase();
        if (!this.warpsConfig.contains(path)) {
            return null;
        }
        String worldName = this.warpsConfig.getString(path + ".world");
        if (worldName == null || Bukkit.getWorld((String)worldName) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)worldName), this.warpsConfig.getDouble(path + ".x"), this.warpsConfig.getDouble(path + ".y"), this.warpsConfig.getDouble(path + ".z"), (float)this.warpsConfig.getDouble(path + ".yaw"), (float)this.warpsConfig.getDouble(path + ".pitch"));
    }

    public boolean warpExists(String name) {
        return this.warpsConfig.contains(name.toLowerCase());
    }

    public Set<String> getWarpNames() {
        return this.warpsConfig.getKeys(false);
    }

    public void deleteWarp(String name) {
        String path = name.toLowerCase();
        this.warpsConfig.set(path, null);
        this.saveWarps();
    }

    public void setSpawn(Location location) {
        this.spawnConfig.set("spawn.world", (Object)location.getWorld().getName());
        this.spawnConfig.set("spawn.x", (Object)location.getX());
        this.spawnConfig.set("spawn.y", (Object)location.getY());
        this.spawnConfig.set("spawn.z", (Object)location.getZ());
        this.spawnConfig.set("spawn.yaw", (Object)Float.valueOf(location.getYaw()));
        this.spawnConfig.set("spawn.pitch", (Object)Float.valueOf(location.getPitch()));
        this.saveSpawn();
    }

    public Location getSpawn() {
        if (!this.spawnConfig.contains("spawn")) {
            return null;
        }
        String worldName = this.spawnConfig.getString("spawn.world");
        if (worldName == null || Bukkit.getWorld((String)worldName) == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)worldName), this.spawnConfig.getDouble("spawn.x"), this.spawnConfig.getDouble("spawn.y"), this.spawnConfig.getDouble("spawn.z"), (float)this.spawnConfig.getDouble("spawn.yaw"), (float)this.spawnConfig.getDouble("spawn.pitch"));
    }

    public boolean hasSpawn() {
        return this.spawnConfig.contains("spawn");
    }

    public void setLastLocation(UUID playerUUID, Location location) {
        this.lastLocations.put(playerUUID, location);
    }

    public Location getLastLocation(UUID playerUUID) {
        return this.lastLocations.get(playerUUID);
    }

    public boolean hasLastLocation(UUID playerUUID) {
        return this.lastLocations.containsKey(playerUUID);
    }

    private void saveHomes() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save homes.yml: " + e.getMessage());
        }
    }

    private void saveWarps() {
        try {
            this.warpsConfig.save(this.warpsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save warps.yml: " + e.getMessage());
        }
    }

    private void saveSpawn() {
        try {
            this.spawnConfig.save(this.spawnFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save spawn.yml: " + e.getMessage());
        }
    }

    public void saveAllData() {
        this.saveHomes();
        this.saveWarps();
        this.saveSpawn();
    }
}

