/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpsCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public WarpsCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.warps")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        Set<String> warpNames = this.plugin.getDataManager().getWarpNames();
        if (warpNames.isEmpty()) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("warp-list-empty"));
            return true;
        }
        player.sendMessage(this.plugin.getConfigManager().getMessage("warp-list-header"));
        for (String warpName : warpNames) {
            String message = this.plugin.getConfigManager().getMessage("warp-list-item", "{warp}", warpName);
            player.sendMessage(message);
        }
        return true;
    }
}

