/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public WarpCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.warp")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-warp"));
            return true;
        }
        String warpName = args[0];
        Location warp = this.plugin.getDataManager().getWarp(warpName);
        if (warp == null) {
            String message = this.plugin.getConfigManager().getMessage("warp-not-found", "{warp}", warpName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
            return true;
        }
        this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
        player.teleport(warp);
        String message = this.plugin.getConfigManager().getMessage("warp-teleport", "{warp}", warpName);
        player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
        return true;
    }
}

