/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetWarpCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public SetWarpCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.setwarp")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-setwarp"));
            return true;
        }
        String warpName = args[0];
        if (this.plugin.getDataManager().warpExists(warpName)) {
            String message = this.plugin.getConfigManager().getMessage("warp-already-exists", "{warp}", warpName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
            return true;
        }
        Location location = player.getLocation();
        this.plugin.getDataManager().setWarp(warpName, location);
        String message = this.plugin.getConfigManager().getMessage("warp-set", "{warp}", warpName);
        player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
        return true;
    }
}

