/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public HomeCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("SimpleTeleport.home")) {
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
            return true;
        }
        if (args.length == 1) {
            if (!player.hasPermission("SimpleTeleport.home.others")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-no-permission-others"));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-player-not-found"));
                return true;
            }
            Location home = this.plugin.getDataManager().getHome(target.getUniqueId());
            if (home == null) {
                String message = this.plugin.getConfigManager().getMessage("home-other-not-set", "{player}", target.getName());
                player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
                return true;
            }
            this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
            player.teleport(home);
            String message = this.plugin.getConfigManager().getMessage("home-other-teleport", "{player}", target.getName());
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
            return true;
        }
        if (args.length == 0) {
            Location home = this.plugin.getDataManager().getHome(player.getUniqueId());
            if (home == null) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-not-set"));
                return true;
            }
            this.plugin.getDataManager().setLastLocation(player.getUniqueId(), player.getLocation());
            player.teleport(home);
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-teleport"));
            return true;
        }
        player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-home"));
        return true;
    }
}

