/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport.commands;

import de.simolzimol.simpleteleport.SimpleTeleport;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DelHomeCommand
implements CommandExecutor {
    private final SimpleTeleport plugin;

    public DelHomeCommand(SimpleTeleport plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            if (!player.hasPermission("SimpleTeleport.delhome.others")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
                return true;
            }
            String targetName = args[0];
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
            if (target == null || !target.hasPlayedBefore()) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-player-not-found"));
                return true;
            }
            UUID targetUUID = target.getUniqueId();
            if (!this.plugin.getDataManager().hasHome(targetUUID)) {
                String message = this.plugin.getConfigManager().getMessage("home-other-not-set", "{player}", targetName);
                player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
                return true;
            }
            this.plugin.getDataManager().deleteHome(targetUUID);
            String message = this.plugin.getConfigManager().getMessage("home-deleted-other", "{player}", targetName);
            player.sendMessage(this.plugin.getConfigManager().getMessage("prefix") + message);
            return true;
        }
        if (args.length == 0) {
            if (!player.hasPermission("SimpleTeleport.delhome")) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("no-permission"));
                return true;
            }
            if (!this.plugin.getDataManager().hasHome(player.getUniqueId())) {
                player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-not-set"));
                return true;
            }
            this.plugin.getDataManager().deleteHome(player.getUniqueId());
            player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("home-deleted"));
            return true;
        }
        player.sendMessage(this.plugin.getConfigManager().getMessageWithPrefix("usage-delhome"));
        return true;
    }
}

