/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpleteleport;

import de.simolzimol.simpleteleport.commands.BackCommand;
import de.simolzimol.simpleteleport.commands.DelHomeCommand;
import de.simolzimol.simpleteleport.commands.DelWarpCommand;
import de.simolzimol.simpleteleport.commands.HomeCommand;
import de.simolzimol.simpleteleport.commands.SetHomeCommand;
import de.simolzimol.simpleteleport.commands.SetWarpCommand;
import de.simolzimol.simpleteleport.commands.SpawnCommand;
import de.simolzimol.simpleteleport.commands.WarpCommand;
import de.simolzimol.simpleteleport.commands.WarpsCommand;
import de.simolzimol.simpleteleport.listeners.PlayerListener;
import de.simolzimol.simpleteleport.managers.ConfigManager;
import de.simolzimol.simpleteleport.managers.DataManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleTeleport
extends JavaPlugin {
    private static SimpleTeleport instance;
    private ConfigManager configManager;
    private DataManager dataManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.dataManager = new DataManager(this);
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getLogger().info("SimpleTeleport v" + this.getDescription().getVersion() + " wurde aktiviert!");
        this.getLogger().info("Plugin von simolzimol");
    }

    public void onDisable() {
        if (this.dataManager != null) {
            this.dataManager.saveAllData();
        }
        this.getLogger().info("SimpleTeleport wurde deaktiviert!");
    }

    private void registerCommands() {
        this.getCommand("sethome").setExecutor((CommandExecutor)new SetHomeCommand(this));
        this.getCommand("home").setExecutor((CommandExecutor)new HomeCommand(this));
        this.getCommand("warp").setExecutor((CommandExecutor)new WarpCommand(this));
        this.getCommand("setwarp").setExecutor((CommandExecutor)new SetWarpCommand(this));
        this.getCommand("warps").setExecutor((CommandExecutor)new WarpsCommand(this));
        this.getCommand("delwarp").setExecutor((CommandExecutor)new DelWarpCommand(this));
        this.getCommand("delhome").setExecutor((CommandExecutor)new DelHomeCommand(this));
        this.getCommand("spawn").setExecutor((CommandExecutor)new SpawnCommand(this));
        this.getCommand("back").setExecutor((CommandExecutor)new BackCommand(this));
    }

    public static SimpleTeleport getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }
}

