/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpletpa;

import de.simolzimol.simpletpa.ConfigManager;
import de.simolzimol.simpletpa.SimpleTPA;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPACommand
implements CommandExecutor,
Listener {
    private final SimpleTPA plugin;
    private final ConfigManager configManager;
    private final Map<UUID, UUID> pendingRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, Boolean> requestTypes = new HashMap<UUID, Boolean>();
    private final Map<UUID, BukkitRunnable> requestTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Set<UUID> tpaDisabled = new HashSet<UUID>();
    private final Map<UUID, BukkitRunnable> teleportTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, Location> teleportLocations = new HashMap<UUID, Location>();

    public TPACommand(SimpleTPA plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("tpareload")) {
            return this.handleReload(sender);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.configManager.getPrefix() + this.configManager.getMessage("only_players"));
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "tpa": {
                return this.handleTPA(player, args, false);
            }
            case "tpahere": {
                return this.handleTPA(player, args, true);
            }
            case "tpaccept": {
                return this.handleTPAccept(player);
            }
            case "tpdeny": {
                return this.handleTPDeny(player);
            }
            case "tpacancel": {
                return this.handleTPCancel(player);
            }
            case "tpatoggle": {
                return this.handleTPAToggle(player);
            }
        }
        return false;
    }

    private boolean handleTPA(final Player sender, String[] args, boolean isTpaHere) {
        if (!sender.hasPermission("SimpleTPA.tpa")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", sender.getName()));
            return true;
        }
        if (this.cooldowns.containsKey(sender.getUniqueId())) {
            long timeLeft = (this.cooldowns.get(sender.getUniqueId()) - System.currentTimeMillis()) / 1000L;
            if (timeLeft > 0L) {
                sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("cooldown_active"), "time", String.valueOf(timeLeft)));
                return true;
            }
            this.cooldowns.remove(sender.getUniqueId());
        }
        if (args.length != 1) {
            String usageKey = isTpaHere ? "tpahere_usage" : "tpa_usage";
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage(usageKey), "player", sender.getName()));
            return true;
        }
        final Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("player_not_found"), "player", args[0]));
            return true;
        }
        if (target.equals((Object)sender)) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("cannot_request_self"), "player", sender.getName()));
            return true;
        }
        if (this.tpaDisabled.contains(target.getUniqueId())) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("tpatoggle_target_disabled"), "player", target.getName()));
            return true;
        }
        if (this.pendingRequests.containsKey(target.getUniqueId())) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("player_has_pending"), "player", target.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(sender.getUniqueId())) {
            this.requestTasks.get(sender.getUniqueId()).cancel();
            this.requestTasks.remove(sender.getUniqueId());
        }
        this.pendingRequests.put(target.getUniqueId(), sender.getUniqueId());
        this.requestTypes.put(target.getUniqueId(), isTpaHere);
        this.cooldowns.put(sender.getUniqueId(), System.currentTimeMillis() + (long)this.configManager.getCooldown() * 1000L);
        String sentKey = isTpaHere ? "tpahere_request_sent" : "request_sent";
        String receivedKey = isTpaHere ? "tpahere_request_received" : "request_received";
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage(sentKey), "player", target.getName()));
        String receivedMsg = this.configManager.getMessage(receivedKey).replace("{sender}", sender.getName());
        target.sendMessage(this.configManager.getPrefix() + receivedMsg);
        if (this.configManager.isTeleportSoundEnabled()) {
            this.playSound(target, this.configManager.getRequestSound());
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(sender.getName() + " sent a " + (isTpaHere ? "TPAHere" : "TPA") + " request to " + target.getName());
        }
        BukkitRunnable timeoutTask = new BukkitRunnable(this){
            final /* synthetic */ TPACommand this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.pendingRequests.containsKey(target.getUniqueId()) && ((UUID)this.this$0.pendingRequests.get(target.getUniqueId())).equals(sender.getUniqueId())) {
                    this.this$0.pendingRequests.remove(target.getUniqueId());
                    this.this$0.requestTypes.remove(target.getUniqueId());
                    this.this$0.requestTasks.remove(sender.getUniqueId());
                    if (sender.isOnline()) {
                        sender.sendMessage(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("request_expired"), "player", target.getName()));
                    }
                    if (target.isOnline()) {
                        target.sendMessage(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("request_expired_receiver"), "sender", sender.getName()));
                    }
                }
            }
        };
        timeoutTask.runTaskLater((Plugin)this.plugin, (long)this.configManager.getRequestTimeout() * 20L);
        this.requestTasks.put(sender.getUniqueId(), timeoutTask);
        return true;
    }

    private boolean handleTPAccept(Player receiver) {
        int delay;
        Player destination;
        if (!receiver.hasPermission("SimpleTPA.tpa")) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", receiver.getName()));
            return true;
        }
        if (!this.pendingRequests.containsKey(receiver.getUniqueId())) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_pending_request"), "player", receiver.getName()));
            return true;
        }
        UUID senderUUID = this.pendingRequests.get(receiver.getUniqueId());
        boolean isTpaHere = this.requestTypes.getOrDefault(receiver.getUniqueId(), false);
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (sender == null || !sender.isOnline()) {
            this.pendingRequests.remove(receiver.getUniqueId());
            this.requestTypes.remove(receiver.getUniqueId());
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("sender_offline"), "player", receiver.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(senderUUID)) {
            this.requestTasks.get(senderUUID).cancel();
            this.requestTasks.remove(senderUUID);
        }
        this.pendingRequests.remove(receiver.getUniqueId());
        this.requestTypes.remove(receiver.getUniqueId());
        Player teleporter = isTpaHere ? receiver : sender;
        Player player = destination = isTpaHere ? sender : receiver;
        if (this.configManager.isTeleportSoundEnabled()) {
            this.playSound(receiver, this.configManager.getAcceptSound());
            this.playSound(sender, this.configManager.getAcceptSound());
        }
        if ((delay = this.configManager.getTeleportDelay()) > 0) {
            this.startTeleportDelay(teleporter, destination, isTpaHere);
        } else {
            this.performTeleport(teleporter, destination, isTpaHere);
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(receiver.getName() + " accepted " + (isTpaHere ? "TPAHere" : "TPA") + " request from " + sender.getName());
        }
        return true;
    }

    private void startTeleportDelay(final Player teleporter, final Player destination, final boolean isTpaHere) {
        this.teleportLocations.put(teleporter.getUniqueId(), teleporter.getLocation().clone());
        final int delay = this.configManager.getTeleportDelay();
        BukkitRunnable teleportTask = new BukkitRunnable(this){
            int countdown;
            final /* synthetic */ TPACommand this$0;
            {
                this.this$0 = this$0;
                this.countdown = delay;
            }

            public void run() {
                if (!teleporter.isOnline() || !destination.isOnline()) {
                    this.cancel();
                    this.this$0.teleportTasks.remove(teleporter.getUniqueId());
                    this.this$0.teleportLocations.remove(teleporter.getUniqueId());
                    return;
                }
                if (this.countdown > 0) {
                    try {
                        teleporter.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("teleport_warmup"), "time", String.valueOf(this.countdown))));
                    }
                    catch (Exception e) {
                        teleporter.sendMessage(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("teleport_warmup"), "time", String.valueOf(this.countdown)));
                    }
                    --this.countdown;
                } else {
                    this.this$0.performTeleport(teleporter, destination, isTpaHere);
                    this.this$0.teleportTasks.remove(teleporter.getUniqueId());
                    this.this$0.teleportLocations.remove(teleporter.getUniqueId());
                    this.cancel();
                }
            }
        };
        this.teleportTasks.put(teleporter.getUniqueId(), teleportTask);
        teleportTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void performTeleport(Player teleporter, Player destination, boolean isTpaHere) {
        teleporter.teleport(destination.getLocation());
        String successKey = isTpaHere ? "tpahere_success" : "teleport_success";
        String acceptedKey = isTpaHere ? "tpahere_accepted" : "request_accepted";
        teleporter.sendMessage(this.configManager.formatMessage(this.configManager.getMessage(successKey), "player", destination.getName()));
        destination.sendMessage(this.configManager.formatMessage(this.configManager.getMessage(acceptedKey), "sender", teleporter.getName()));
        if (this.configManager.isTeleportSoundEnabled()) {
            try {
                teleporter.playSound(teleporter.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cancelTeleport(Player player, String reason) {
        if (this.teleportTasks.containsKey(player.getUniqueId())) {
            this.teleportTasks.get(player.getUniqueId()).cancel();
            this.teleportTasks.remove(player.getUniqueId());
            this.teleportLocations.remove(player.getUniqueId());
            player.sendMessage(this.configManager.getPrefix() + this.configManager.getMessage(reason));
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.configManager.shouldCancelOnMove()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.teleportLocations.containsKey(player.getUniqueId())) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to != null && (from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ())) {
            this.cancelTeleport(player, "teleport_cancelled_move");
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!this.configManager.shouldCancelOnDamage()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (this.teleportLocations.containsKey(player.getUniqueId())) {
            this.cancelTeleport(player, "teleport_cancelled_damage");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.teleportTasks.containsKey(uuid)) {
            this.teleportTasks.get(uuid).cancel();
            this.teleportTasks.remove(uuid);
        }
        this.teleportLocations.remove(uuid);
        this.cooldowns.remove(uuid);
    }

    private boolean handleTPDeny(Player receiver) {
        if (!receiver.hasPermission("SimpleTPA.tpa")) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", receiver.getName()));
            return true;
        }
        if (!this.pendingRequests.containsKey(receiver.getUniqueId())) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_pending_request"), "player", receiver.getName()));
            return true;
        }
        UUID senderUUID = this.pendingRequests.get(receiver.getUniqueId());
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (this.requestTasks.containsKey(senderUUID)) {
            this.requestTasks.get(senderUUID).cancel();
            this.requestTasks.remove(senderUUID);
        }
        this.pendingRequests.remove(receiver.getUniqueId());
        this.requestTypes.remove(receiver.getUniqueId());
        if (this.configManager.isTeleportSoundEnabled()) {
            this.playSound(receiver, this.configManager.getDenySound());
            if (sender != null && sender.isOnline()) {
                this.playSound(sender, this.configManager.getDenySound());
            }
        }
        receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_denied_receiver"), "sender", sender != null ? sender.getName() : "Unknown"));
        if (sender != null && sender.isOnline()) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_denied"), "player", receiver.getName()));
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(receiver.getName() + " denied TPA request from " + (sender != null ? sender.getName() : "Unknown"));
        }
        return true;
    }

    private boolean handleTPCancel(Player sender) {
        if (!sender.hasPermission("SimpleTPA.tpa")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", sender.getName()));
            return true;
        }
        UUID receiverUUID = null;
        for (Map.Entry<UUID, UUID> entry : this.pendingRequests.entrySet()) {
            if (!entry.getValue().equals(sender.getUniqueId())) continue;
            receiverUUID = entry.getKey();
            break;
        }
        if (receiverUUID == null) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_outgoing_request"), "player", sender.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(sender.getUniqueId())) {
            this.requestTasks.get(sender.getUniqueId()).cancel();
            this.requestTasks.remove(sender.getUniqueId());
        }
        this.pendingRequests.remove(receiverUUID);
        this.requestTypes.remove(receiverUUID);
        Player receiver = Bukkit.getPlayer((UUID)receiverUUID);
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_cancelled"), "player", sender.getName()));
        if (receiver != null && receiver.isOnline()) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_cancelled_receiver"), "sender", sender.getName()));
        }
        return true;
    }

    private boolean handleTPAToggle(Player player) {
        if (!player.hasPermission("SimpleTPA.tpa")) {
            player.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", player.getName()));
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (this.tpaDisabled.contains(uuid)) {
            this.tpaDisabled.remove(uuid);
            player.sendMessage(this.configManager.getPrefix() + this.configManager.getMessage("tpatoggle_enabled"));
        } else {
            this.tpaDisabled.add(uuid);
            player.sendMessage(this.configManager.getPrefix() + this.configManager.getMessage("tpatoggle_disabled"));
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(player.getName() + " toggled TPA requests: " + (this.tpaDisabled.contains(uuid) ? "disabled" : "enabled"));
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("SimpleTPA.reload")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission_reload"), "player", sender instanceof Player ? sender.getName() : "Console"));
            return true;
        }
        this.configManager.reloadConfiguration();
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("config_reloaded"), "player", sender instanceof Player ? sender.getName() : "Console"));
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info("Configuration reloaded by " + (sender instanceof Player ? sender.getName() : "Console"));
        }
        return true;
    }

    private void playSound(Player player, String soundName) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clearAllRequests() {
        for (BukkitRunnable task : this.requestTasks.values()) {
            task.cancel();
        }
        this.requestTasks.clear();
        this.pendingRequests.clear();
        this.requestTypes.clear();
        for (BukkitRunnable task : this.teleportTasks.values()) {
            task.cancel();
        }
        this.teleportTasks.clear();
        this.teleportLocations.clear();
    }
}

