/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpletpa;

import de.simolzimol.simpletpa.SimpleTPA;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SimpleTPA plugin;
    private FileConfiguration config;

    public ConfigManager(SimpleTPA plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfiguration() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getMessage(String path) {
        String message = this.config.getString("messages." + path, "");
        return this.translateColorCodes(message);
    }

    public String getPrefix() {
        if (this.config.getBoolean("settings.use_prefix", true)) {
            return this.translateColorCodes(this.config.getString("settings.prefix", "&8[&bSimpleTPA&8] "));
        }
        return "";
    }

    public int getRequestTimeout() {
        return this.config.getInt("settings.request_timeout", 60);
    }

    public boolean shouldLogCommands() {
        return this.config.getBoolean("settings.log_commands", true);
    }

    public boolean isTeleportSoundEnabled() {
        return this.config.getBoolean("settings.teleport_sound_enabled", true);
    }

    public int getTeleportDelay() {
        return this.config.getInt("settings.teleport_delay", 3);
    }

    public int getCooldown() {
        return this.config.getInt("settings.cooldown", 30);
    }

    public boolean shouldCancelOnMove() {
        return this.config.getBoolean("settings.cancel_on_move", true);
    }

    public boolean shouldCancelOnDamage() {
        return this.config.getBoolean("settings.cancel_on_damage", true);
    }

    public String getRequestSound() {
        return this.config.getString("settings.sounds.request_received", "ENTITY_EXPERIENCE_ORB_PICKUP");
    }

    public String getAcceptSound() {
        return this.config.getString("settings.sounds.request_accepted", "ENTITY_ENDERMAN_TELEPORT");
    }

    public String getDenySound() {
        return this.config.getString("settings.sounds.request_denied", "ENTITY_VILLAGER_NO");
    }

    public String formatMessage(String message, String placeholder, String value) {
        return this.getPrefix() + message.replace("{" + placeholder + "}", value);
    }

    public String translateColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

