/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpletpa;

import de.simolzimol.simpletpa.ConfigManager;
import de.simolzimol.simpletpa.SimpleTPA;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TPACommand
implements CommandExecutor {
    private final SimpleTPA plugin;
    private final ConfigManager configManager;
    private final Map<UUID, UUID> pendingRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, BukkitRunnable> requestTasks = new HashMap<UUID, BukkitRunnable>();

    public TPACommand(SimpleTPA plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("tpareload")) {
            return this.handleReload(sender);
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.configManager.getPrefix() + this.configManager.getMessage("only_players"));
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase()) {
            case "tpa": {
                return this.handleTPA(player, args);
            }
            case "tpaccept": {
                return this.handleTPAccept(player);
            }
            case "tpdeny": {
                return this.handleTPDeny(player);
            }
            case "tpacancel": {
                return this.handleTPCancel(player);
            }
        }
        return false;
    }

    private boolean handleTPA(final Player sender, String[] args) {
        if (!sender.hasPermission("SimpleTPA.tpa")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", sender.getName()));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("tpa_usage"), "player", sender.getName()));
            return true;
        }
        final Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("player_not_found"), "player", args[0]));
            return true;
        }
        if (target.equals((Object)sender)) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("cannot_request_self"), "player", sender.getName()));
            return true;
        }
        if (this.pendingRequests.containsKey(target.getUniqueId())) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("player_has_pending"), "player", target.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(sender.getUniqueId())) {
            this.requestTasks.get(sender.getUniqueId()).cancel();
            this.requestTasks.remove(sender.getUniqueId());
        }
        this.pendingRequests.put(target.getUniqueId(), sender.getUniqueId());
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_sent"), "player", target.getName()));
        String receivedMsg = this.configManager.getMessage("request_received").replace("{sender}", sender.getName());
        target.sendMessage(this.configManager.getPrefix() + receivedMsg);
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(sender.getName() + " sent a TPA request to " + target.getName());
        }
        BukkitRunnable timeoutTask = new BukkitRunnable(this){
            final /* synthetic */ TPACommand this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.this$0.pendingRequests.containsKey(target.getUniqueId()) && ((UUID)this.this$0.pendingRequests.get(target.getUniqueId())).equals(sender.getUniqueId())) {
                    this.this$0.pendingRequests.remove(target.getUniqueId());
                    this.this$0.requestTasks.remove(sender.getUniqueId());
                    if (sender.isOnline()) {
                        sender.sendMessage(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("request_expired"), "player", target.getName()));
                    }
                    if (target.isOnline()) {
                        target.sendMessage(this.this$0.configManager.formatMessage(this.this$0.configManager.getMessage("request_expired_receiver"), "sender", sender.getName()));
                    }
                }
            }
        };
        timeoutTask.runTaskLater((Plugin)this.plugin, (long)this.configManager.getRequestTimeout() * 20L);
        this.requestTasks.put(sender.getUniqueId(), timeoutTask);
        return true;
    }

    private boolean handleTPAccept(Player receiver) {
        if (!receiver.hasPermission("SimpleTPA.tpa")) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", receiver.getName()));
            return true;
        }
        if (!this.pendingRequests.containsKey(receiver.getUniqueId())) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_pending_request"), "player", receiver.getName()));
            return true;
        }
        UUID senderUUID = this.pendingRequests.get(receiver.getUniqueId());
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (sender == null || !sender.isOnline()) {
            this.pendingRequests.remove(receiver.getUniqueId());
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("sender_offline"), "player", receiver.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(senderUUID)) {
            this.requestTasks.get(senderUUID).cancel();
            this.requestTasks.remove(senderUUID);
        }
        this.pendingRequests.remove(receiver.getUniqueId());
        sender.teleport(receiver.getLocation());
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("teleport_success"), "player", receiver.getName()));
        receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_accepted"), "sender", sender.getName()));
        if (this.configManager.isTeleportSoundEnabled()) {
            try {
                sender.playSound(sender.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(receiver.getName() + " accepted TPA request from " + sender.getName());
        }
        return true;
    }

    private boolean handleTPDeny(Player receiver) {
        if (!receiver.hasPermission("SimpleTPA.tpa")) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", receiver.getName()));
            return true;
        }
        if (!this.pendingRequests.containsKey(receiver.getUniqueId())) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_pending_request"), "player", receiver.getName()));
            return true;
        }
        UUID senderUUID = this.pendingRequests.get(receiver.getUniqueId());
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (this.requestTasks.containsKey(senderUUID)) {
            this.requestTasks.get(senderUUID).cancel();
            this.requestTasks.remove(senderUUID);
        }
        this.pendingRequests.remove(receiver.getUniqueId());
        receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_denied_receiver"), "sender", sender != null ? sender.getName() : "Unknown"));
        if (sender != null && sender.isOnline()) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_denied"), "player", receiver.getName()));
        }
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info(receiver.getName() + " denied TPA request from " + (sender != null ? sender.getName() : "Unknown"));
        }
        return true;
    }

    private boolean handleTPCancel(Player sender) {
        if (!sender.hasPermission("SimpleTPA.tpa")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission"), "player", sender.getName()));
            return true;
        }
        UUID receiverUUID = null;
        for (Map.Entry<UUID, UUID> entry : this.pendingRequests.entrySet()) {
            if (!entry.getValue().equals(sender.getUniqueId())) continue;
            receiverUUID = entry.getKey();
            break;
        }
        if (receiverUUID == null) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_outgoing_request"), "player", sender.getName()));
            return true;
        }
        if (this.requestTasks.containsKey(sender.getUniqueId())) {
            this.requestTasks.get(sender.getUniqueId()).cancel();
            this.requestTasks.remove(sender.getUniqueId());
        }
        this.pendingRequests.remove(receiverUUID);
        Player receiver = Bukkit.getPlayer((UUID)receiverUUID);
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_cancelled"), "player", sender.getName()));
        if (receiver != null && receiver.isOnline()) {
            receiver.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("request_cancelled_receiver"), "sender", sender.getName()));
        }
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("SimpleTPA.reload")) {
            sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("no_permission_reload"), "player", sender instanceof Player ? sender.getName() : "Console"));
            return true;
        }
        this.configManager.reloadConfiguration();
        sender.sendMessage(this.configManager.formatMessage(this.configManager.getMessage("config_reloaded"), "player", sender instanceof Player ? sender.getName() : "Console"));
        if (this.configManager.shouldLogCommands()) {
            this.plugin.getLogger().info("Configuration reloaded by " + (sender instanceof Player ? sender.getName() : "Console"));
        }
        return true;
    }

    public void clearAllRequests() {
        for (BukkitRunnable task : this.requestTasks.values()) {
            task.cancel();
        }
        this.requestTasks.clear();
        this.pendingRequests.clear();
    }
}

