/*
 * Decompiled with CFR 0.152.
 */
package de.simolzimol.simpletpa;

import de.simolzimol.simpletpa.SimpleTPA;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final SimpleTPA plugin;
    private FileConfiguration config;

    public ConfigManager(SimpleTPA plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfiguration() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getMessage(String path) {
        String message = this.config.getString("messages." + path, "");
        return this.translateColorCodes(message);
    }

    public String getPrefix() {
        if (this.config.getBoolean("settings.use_prefix", true)) {
            return this.translateColorCodes(this.config.getString("settings.prefix", "&8[&bSimpleTPA&8] "));
        }
        return "";
    }

    public int getRequestTimeout() {
        return this.config.getInt("settings.request_timeout", 60);
    }

    public boolean shouldLogCommands() {
        return this.config.getBoolean("settings.log_commands", true);
    }

    public boolean isTeleportSoundEnabled() {
        return this.config.getBoolean("settings.teleport_sound_enabled", true);
    }

    public String formatMessage(String message, String placeholder, String value) {
        return this.getPrefix() + message.replace("{" + placeholder + "}", value);
    }

    public String translateColorCodes(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

