/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.utils;

import de.simon.speedy.itemeditor.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack item;
    private final ItemMeta meta;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(material);
        this.meta = this.item.getItemMeta();
    }

    public ItemBuilder(ItemStack item) {
        this.item = item;
        this.meta = item.getItemMeta();
    }

    public ItemBuilder setName(String name) {
        if (this.meta != null) {
            this.meta.setDisplayName(ColorUtils.translateColorCodes(name));
        }
        return this;
    }

    public ItemBuilder setLore(String ... lore) {
        if (this.meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(ColorUtils.translateColorCodes(line));
            }
            this.meta.setLore(coloredLore);
        }
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        if (this.meta != null) {
            ArrayList<String> coloredLore = new ArrayList<String>();
            for (String line : lore) {
                coloredLore.add(ColorUtils.translateColorCodes(line));
            }
            this.meta.setLore(coloredLore);
        }
        return this;
    }

    public ItemBuilder addLoreLine(String line) {
        if (this.meta != null) {
            List<String> lore = this.meta.hasLore() ? this.meta.getLore() : new ArrayList();
            lore.add(ColorUtils.translateColorCodes(line));
            this.meta.setLore(lore);
        }
        return this;
    }

    public ItemBuilder addItemFlag(ItemFlag ... flags) {
        if (this.meta != null) {
            this.meta.addItemFlags(flags);
        }
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        if (this.meta != null) {
            this.meta.setUnbreakable(unbreakable);
        }
        return this;
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

