/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.listeners;

import de.simon.speedy.itemeditor.ItemEditor;
import de.simon.speedy.itemeditor.guis.ActionsMenu;
import de.simon.speedy.itemeditor.guis.EnchantmentMenu;
import de.simon.speedy.itemeditor.guis.LoreMenu;
import de.simon.speedy.itemeditor.guis.MainMenu;
import de.simon.speedy.itemeditor.guis.RenameMenu;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryListener
implements Listener {
    private final ItemEditor plugin;
    private final Map<Player, Enchantment> selectedEnchantment = new HashMap<Player, Enchantment>();
    private final Map<Player, String> selectedEnchantmentName = new HashMap<Player, String>();

    public InventoryListener(ItemEditor plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.contains("\u00a7")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (title.equals("\u00a76\u00a7lItem Editor")) {
            this.handleMainMenu(player, clicked);
        } else if (title.startsWith("\u00a7b\u00a7lEdit Lore")) {
            this.handleLoreMenu(player, clicked, title);
        } else if (title.equals("\u00a7d\u00a7lEnchantments")) {
            this.handleEnchantmentMenu(player, clicked);
        } else if (title.startsWith("\u00a7d\u00a7lEnchantments")) {
            this.handleEnchantmentMenu(player, clicked, title);
        } else if (title.contains("\u00a77Level")) {
            this.handleEnchantmentLevelMenu(player, clicked);
        } else if (title.equals("\u00a7c\u00a7lItem Actions")) {
            this.handleActionsMenu(player, clicked);
        }
    }

    private void handleMainMenu(Player player, ItemStack clicked) {
        Material type = clicked.getType();
        if (type == Material.NAME_TAG) {
            RenameMenu.openRenameMenu(player);
        } else if (type == Material.WRITABLE_BOOK) {
            LoreMenu.openLoreMenu(player);
        } else if (type == Material.ENCHANTED_BOOK) {
            EnchantmentMenu.openEnchantmentMenu(player);
        } else if (type == Material.COMMAND_BLOCK) {
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.BARRIER) {
            player.closeInventory();
        }
    }

    private void handleLoreMenu(Player player, ItemStack clicked, String title) {
        if (clicked.getType() == Material.ARROW) {
            MainMenu.openMainMenu(player);
            return;
        }
        if (clicked.getType() == Material.SPECTRAL_ARROW) {
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String name = meta.getDisplayName();
            if (name.contains("Next")) {
                LoreMenu.openLoreMenu(player, 2);
            } else if (name.contains("Previous")) {
                LoreMenu.openLoreMenu(player, 1);
            }
            return;
        }
        if (clicked.getType() == Material.PAPER) {
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String name = meta.getDisplayName();
            player.closeInventory();
            for (int i = 1; i <= 10; ++i) {
                if (!name.contains("Line " + i)) continue;
                player.sendMessage("\u00a77\u00a7m----------------------------------");
                player.sendMessage("\u00a7b\u00a7lLore Line " + i);
                player.sendMessage("");
                player.sendMessage("\u00a77Please enter lore line " + i + " in chat.");
                player.sendMessage("\u00a77Use \u00a7e&\u00a77 for color codes and");
                player.sendMessage("\u00a77Use \u00a7e&#RRGGBB\u00a77 for hex colors!");
                player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
                player.sendMessage("\u00a77\u00a7m----------------------------------");
                ItemEditor.ChatMode mode = ItemEditor.ChatMode.valueOf("LORE_LINE_" + i);
                this.plugin.getAwaitingInput().put(player.getUniqueId(), mode);
                break;
            }
        }
    }

    private void handleEnchantmentMenu(Player player, ItemStack clicked, String title) {
        if (clicked.getType() == Material.SPECTRAL_ARROW) {
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String name = meta.getDisplayName();
            if (name.contains("Next")) {
                if (title.contains("Page 1")) {
                    EnchantmentMenu.openEnchantmentMenu(player, 2);
                } else if (title.contains("Page 2")) {
                    EnchantmentMenu.openEnchantmentMenu(player, 3);
                }
            } else if (name.contains("Previous")) {
                if (title.contains("Page 2")) {
                    EnchantmentMenu.openEnchantmentMenu(player, 1);
                } else if (title.contains("Page 3")) {
                    EnchantmentMenu.openEnchantmentMenu(player, 2);
                }
            }
            return;
        }
        this.handleEnchantmentMenu(player, clicked);
    }

    private void handleEnchantmentMenu(Player player, ItemStack clicked) {
        if (clicked.getType() == Material.ARROW) {
            MainMenu.openMainMenu(player);
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        String enchantName = meta.getDisplayName().substring(2);
        Enchantment enchant = this.getEnchantmentByName(enchantName);
        if (enchant != null) {
            this.selectedEnchantment.put(player, enchant);
            this.selectedEnchantmentName.put(player, enchantName);
            EnchantmentMenu.openLevelMenu(player, enchant, enchantName);
        }
    }

    private void handleEnchantmentLevelMenu(Player player, ItemStack clicked) {
        if (clicked.getType() == Material.ARROW) {
            this.selectedEnchantment.remove(player);
            this.selectedEnchantmentName.remove(player);
            EnchantmentMenu.openEnchantmentMenu(player);
            return;
        }
        if (clicked.getType() == Material.NETHER_STAR) {
            Enchantment enchant = this.selectedEnchantment.get(player);
            String enchantName = this.selectedEnchantmentName.get(player);
            if (enchant == null) {
                return;
            }
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a7d\u00a7lCustom Enchantment Level");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter the level for \u00a7e" + enchantName + "\u00a77:");
            player.sendMessage("\u00a77You can use any level (even beyond max)!");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ENCHANT_CUSTOM_LEVEL);
            return;
        }
        if (clicked.getType() == Material.EXPERIENCE_BOTTLE) {
            ItemMeta itemMeta;
            Enchantment enchant = this.selectedEnchantment.get(player);
            if (enchant == null) {
                return;
            }
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null) {
                return;
            }
            String levelStr = meta.getDisplayName().replace("\u00a7eLevel ", "");
            int level = Integer.parseInt(levelStr);
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item != null && item.getType() != Material.AIR && (itemMeta = item.getItemMeta()) != null) {
                itemMeta.addEnchant(enchant, level, true);
                item.setItemMeta(itemMeta);
                player.sendMessage("\u00a7aEnchantment added successfully!");
            }
            this.selectedEnchantment.remove(player);
            this.selectedEnchantmentName.remove(player);
            MainMenu.openMainMenu(player);
        }
    }

    private Enchantment getEnchantmentByName(String name) {
        HashMap<String, Enchantment> enchantMap = new HashMap<String, Enchantment>();
        enchantMap.put("Protection", Enchantment.PROTECTION_ENVIRONMENTAL);
        enchantMap.put("Sharpness", Enchantment.DAMAGE_ALL);
        enchantMap.put("Efficiency", Enchantment.DIG_SPEED);
        enchantMap.put("Unbreaking", Enchantment.DURABILITY);
        enchantMap.put("Mending", Enchantment.MENDING);
        enchantMap.put("Fortune", Enchantment.LOOT_BONUS_BLOCKS);
        enchantMap.put("Silk Touch", Enchantment.SILK_TOUCH);
        enchantMap.put("Fire Protection", Enchantment.PROTECTION_FIRE);
        enchantMap.put("Blast Protection", Enchantment.PROTECTION_EXPLOSIONS);
        enchantMap.put("Projectile Protection", Enchantment.PROTECTION_PROJECTILE);
        enchantMap.put("Thorns", Enchantment.THORNS);
        enchantMap.put("Aqua Affinity", Enchantment.WATER_WORKER);
        enchantMap.put("Respiration", Enchantment.OXYGEN);
        enchantMap.put("Depth Strider", Enchantment.DEPTH_STRIDER);
        enchantMap.put("Smite", Enchantment.DAMAGE_UNDEAD);
        enchantMap.put("Bane of Arthropods", Enchantment.DAMAGE_ARTHROPODS);
        enchantMap.put("Knockback", Enchantment.KNOCKBACK);
        enchantMap.put("Fire Aspect", Enchantment.FIRE_ASPECT);
        enchantMap.put("Looting", Enchantment.LOOT_BONUS_MOBS);
        enchantMap.put("Sweeping Edge", Enchantment.SWEEPING_EDGE);
        enchantMap.put("Power", Enchantment.ARROW_DAMAGE);
        enchantMap.put("Punch", Enchantment.ARROW_KNOCKBACK);
        enchantMap.put("Flame", Enchantment.ARROW_FIRE);
        enchantMap.put("Infinity", Enchantment.ARROW_INFINITE);
        enchantMap.put("Piercing", Enchantment.PIERCING);
        enchantMap.put("Quick Charge", Enchantment.QUICK_CHARGE);
        enchantMap.put("Multishot", Enchantment.MULTISHOT);
        enchantMap.put("Luck of the Sea", Enchantment.LUCK);
        enchantMap.put("Lure", Enchantment.LURE);
        enchantMap.put("Loyalty", Enchantment.LOYALTY);
        enchantMap.put("Impaling", Enchantment.IMPALING);
        enchantMap.put("Riptide", Enchantment.RIPTIDE);
        enchantMap.put("Channeling", Enchantment.CHANNELING);
        enchantMap.put("Frost Walker", Enchantment.FROST_WALKER);
        enchantMap.put("Soul Speed", Enchantment.SOUL_SPEED);
        enchantMap.put("Swift Sneak", Enchantment.SWIFT_SNEAK);
        enchantMap.put("Curse of Vanishing", Enchantment.VANISHING_CURSE);
        enchantMap.put("Curse of Binding", Enchantment.BINDING_CURSE);
        return (Enchantment)enchantMap.get(name);
    }

    public Enchantment getSelectedEnchantment(Player player) {
        return this.selectedEnchantment.get(player);
    }

    public void clearPlayerEnchantment(Player player) {
        this.selectedEnchantment.remove(player);
        this.selectedEnchantmentName.remove(player);
    }

    private void handleActionsMenu(Player player, ItemStack clicked) {
        if (clicked.getType() == Material.ARROW) {
            MainMenu.openMainMenu(player);
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            player.sendMessage("\u00a7cYou must hold an item in your hand!");
            player.closeInventory();
            return;
        }
        Material type = clicked.getType();
        if (type == Material.APPLE) {
            this.toggleConsumable(player, item);
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.COMMAND_BLOCK) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a76\u00a7lLeft Click Command Action");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter the command to execute on LEFT click:");
            player.sendMessage("\u00a77Use \u00a7e%player%\u00a77 for player name");
            player.sendMessage("\u00a77Use \u00a7e%target%\u00a77 for targeted player");
            player.sendMessage("\u00a77Example: \u00a7egive %player% diamond 1");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_LEFTCLICK_COMMAND);
        } else if (type == Material.REPEATING_COMMAND_BLOCK) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a76\u00a7lRight Click Command Action");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter the command to execute on RIGHT click:");
            player.sendMessage("\u00a77Use \u00a7e%player%\u00a77 for player name");
            player.sendMessage("\u00a77Use \u00a7e%target%\u00a77 for targeted player");
            player.sendMessage("\u00a77Example: \u00a7egive %target% diamond 1");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_RIGHTCLICK_COMMAND);
        } else if (type == Material.GOLDEN_APPLE) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a7a\u00a7lLeft Click Heal (Self)");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter the heal amount (hearts):");
            player.sendMessage("\u00a77This will heal YOURSELF on LEFT click");
            player.sendMessage("\u00a77Example: \u00a7e5\u00a77 = 5 hearts (10 HP)");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_LEFTCLICK_HEAL);
        } else if (type == Material.ENCHANTED_GOLDEN_APPLE) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a7a\u00a7lRight Click Heal (Target)");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter the heal amount (hearts):");
            player.sendMessage("\u00a77This will heal the TARGETED player on RIGHT click");
            player.sendMessage("\u00a77Example: \u00a7e5\u00a77 = 5 hearts (10 HP)");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_RIGHTCLICK_HEAL);
        } else if (type == Material.BARRIER) {
            this.toggleNoPlace(player, item);
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.CRAFTING_TABLE) {
            this.toggleNoCraft(player, item);
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.WRITABLE_BOOK) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a7e\u00a7lCustom Action Message");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter a custom message to show on action use:");
            player.sendMessage("\u00a77Use color codes with \u00a7e&\u00a77 (e.g. \u00a7e&a&lSuccess!\u00a77)");
            player.sendMessage("\u00a77Type \u00a7enone\u00a77, \u00a7edisable\u00a77 or \u00a7eoff\u00a77 to disable messages");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_CUSTOM_MESSAGE);
        } else if (type == Material.PAPER) {
            player.closeInventory();
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            player.sendMessage("\u00a7c\u00a7lCustom No PvP Message");
            player.sendMessage("");
            player.sendMessage("\u00a77Enter a custom message to show when No PvP blocks an action:");
            player.sendMessage("\u00a77Use color codes with \u00a7e&\u00a77 (e.g. \u00a7e&cNo PvP!\u00a77)");
            player.sendMessage("\u00a77Type \u00a7enone\u00a77, \u00a7edisable\u00a77 or \u00a7eoff\u00a77 to disable messages");
            player.sendMessage("\u00a77Type \u00a7ccancel\u00a77 to cancel.");
            player.sendMessage("\u00a77\u00a7m----------------------------------");
            this.plugin.getAwaitingInput().put(player.getUniqueId(), ItemEditor.ChatMode.ACTION_NOPVP_MESSAGE);
        } else if (type == Material.IRON_SWORD) {
            this.toggleNoPvP(player, item);
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.DIAMOND_SWORD) {
            this.cycleHitActionMode(player, item);
            ActionsMenu.openActionsMenu(player);
        } else if (type == Material.GRAY_STAINED_GLASS_PANE || type == Material.RED_STAINED_GLASS_PANE || type == Material.CYAN_STAINED_GLASS_PANE || type == Material.PURPLE_STAINED_GLASS_PANE) {
            return;
        }
    }

    private void toggleConsumable(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            NamespacedKey key;
            PersistentDataContainer pdc;
            boolean current = (Boolean)(pdc = meta.getPersistentDataContainer()).getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_consumable"), PersistentDataType.BOOLEAN, (Object)false);
            pdc.set(key, PersistentDataType.BOOLEAN, (Object)(!current ? 1 : 0));
            item.setItemMeta(meta);
            if (!current) {
                player.sendMessage("\u00a7aItem is now consumable!");
            } else {
                player.sendMessage("\u00a7cItem is no longer consumable!");
            }
        }
        player.getInventory().setItemInMainHand(item);
    }

    private void toggleNoPlace(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            NamespacedKey key;
            PersistentDataContainer pdc;
            boolean current = (Boolean)(pdc = meta.getPersistentDataContainer()).getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_noplace"), PersistentDataType.BOOLEAN, (Object)false);
            pdc.set(key, PersistentDataType.BOOLEAN, (Object)(!current ? 1 : 0));
            item.setItemMeta(meta);
            if (!current) {
                player.sendMessage("\u00a7cItem can no longer be placed!");
            } else {
                player.sendMessage("\u00a7aItem can now be placed!");
            }
        }
        player.getInventory().setItemInMainHand(item);
    }

    private void toggleNoCraft(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            NamespacedKey key;
            PersistentDataContainer pdc;
            boolean current = (Boolean)(pdc = meta.getPersistentDataContainer()).getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_nocraft"), PersistentDataType.BOOLEAN, (Object)false);
            pdc.set(key, PersistentDataType.BOOLEAN, (Object)(!current ? 1 : 0));
            item.setItemMeta(meta);
            if (!current) {
                player.sendMessage("\u00a7aCrafting with this item is now blocked!");
            } else {
                player.sendMessage("\u00a7cCrafting with this item is now allowed!");
            }
        }
        player.getInventory().setItemInMainHand(item);
    }

    private void toggleNoPvP(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            NamespacedKey key;
            PersistentDataContainer pdc;
            boolean current = (Boolean)(pdc = meta.getPersistentDataContainer()).getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_nopvp"), PersistentDataType.BOOLEAN, (Object)false);
            pdc.set(key, PersistentDataType.BOOLEAN, (Object)(!current ? 1 : 0));
            item.setItemMeta(meta);
            if (!current) {
                player.sendMessage("\u00a7aPvP with this item is now blocked!");
            } else {
                player.sendMessage("\u00a7cPvP with this item is now allowed!");
            }
        }
        player.getInventory().setItemInMainHand(item);
    }

    private void cycleHitActionMode(Player player, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "action_hit_mode");
            int current = (Integer)pdc.getOrDefault(key, PersistentDataType.INTEGER, (Object)2);
            int next = (current + 1) % 3;
            pdc.set(key, PersistentDataType.INTEGER, (Object)next);
            item.setItemMeta(meta);
            String modeMsg = next == 0 ? "\u00a7bMode: Only on Hit (entity)" : (next == 1 ? "\u00a7bMode: Only on Left Click (air/block)" : "\u00a7bMode: Both (hit & left click)");
            player.sendMessage("\u00a7aHit Action Mode changed! " + modeMsg);
        }
        player.getInventory().setItemInMainHand(item);
    }
}

