/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor;

import de.simon.speedy.itemeditor.commands.ItemCommand;
import de.simon.speedy.itemeditor.listeners.ActionListener;
import de.simon.speedy.itemeditor.listeners.ChatListener;
import de.simon.speedy.itemeditor.listeners.InventoryListener;
import de.simon.speedy.itemeditor.listeners.ItemRestrictionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemEditor
extends JavaPlugin {
    private static ItemEditor instance;
    private Map<UUID, ChatMode> awaitingInput;
    private InventoryListener inventoryListener;

    public void onEnable() {
        instance = this;
        this.awaitingInput = new HashMap<UUID, ChatMode>();
        this.saveDefaultConfig();
        this.getCommand("item").setExecutor((CommandExecutor)new ItemCommand(this));
        this.inventoryListener = new InventoryListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.inventoryListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ActionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ItemRestrictionListener(this), (Plugin)this);
        this.getLogger().info("ItemEditor has been enabled!");
    }

    public void onDisable() {
        this.awaitingInput.clear();
        this.getLogger().info("ItemEditor has been disabled!");
    }

    public static ItemEditor getInstance() {
        return instance;
    }

    public Map<UUID, ChatMode> getAwaitingInput() {
        return this.awaitingInput;
    }

    public InventoryListener getInventoryListener() {
        return this.inventoryListener;
    }

    public static enum ChatMode {
        RENAME,
        LORE_LINE_1,
        LORE_LINE_2,
        LORE_LINE_3,
        LORE_LINE_4,
        LORE_LINE_5,
        LORE_LINE_6,
        LORE_LINE_7,
        LORE_LINE_8,
        LORE_LINE_9,
        LORE_LINE_10,
        ENCHANT_CUSTOM_LEVEL,
        ACTION_LEFTCLICK_COMMAND,
        ACTION_RIGHTCLICK_COMMAND,
        ACTION_LEFTCLICK_HEAL,
        ACTION_RIGHTCLICK_HEAL,
        ACTION_CUSTOM_MESSAGE,
        ACTION_NOPVP_MESSAGE;

    }
}

