/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");

    public static String translateColorCodes(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = HEX_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hexColor)).toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public static String stripColorCodes(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("&#[A-Fa-f0-9]{6}", "");
        text = text.replaceAll("&[0-9A-Fa-fK-Ok-oRr]", "");
        return text;
    }
}

