/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.listeners;

import de.simon.speedy.itemeditor.ItemEditor;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ItemRestrictionListener
implements Listener {
    private final ItemEditor plugin;

    public ItemRestrictionListener(ItemEditor plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        NamespacedKey key;
        ItemStack item = event.getItemInHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (((Boolean)pdc.getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_noplace"), PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("\u00a7cYou cannot place this item!");
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "action_nocraft");
        for (ItemStack item : event.getInventory().getMatrix()) {
            ItemMeta meta;
            PersistentDataContainer pdc;
            if (item == null || !item.hasItemMeta() || !((Boolean)(pdc = (meta = item.getItemMeta()).getPersistentDataContainer()).getOrDefault(key, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) continue;
            event.setCancelled(true);
            player.sendMessage("\u00a7cYou cannot craft with this item!");
            return;
        }
    }

    @EventHandler
    public void onPlayerHitPlayer(EntityDamageByEntityEvent event) {
        NamespacedKey key;
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player attacker = (Player)event.getDamager();
        ItemStack item = attacker.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (((Boolean)pdc.getOrDefault(key = new NamespacedKey((Plugin)this.plugin, "action_nopvp"), PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            event.setCancelled(true);
            attacker.sendMessage("\u00a7cYou cannot use this item for PvP!");
        }
    }
}

