/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.listeners;

import de.simon.speedy.itemeditor.ItemEditor;
import de.simon.speedy.itemeditor.guis.ActionsMenu;
import de.simon.speedy.itemeditor.guis.MainMenu;
import de.simon.speedy.itemeditor.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChatListener
implements Listener {
    private final ItemEditor plugin;

    public ChatListener(ItemEditor plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getAwaitingInput().containsKey(player.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
        ItemEditor.ChatMode mode = this.plugin.getAwaitingInput().get(player.getUniqueId());
        String message = event.getMessage().trim();
        if (ColorUtils.stripColorCodes(message).equalsIgnoreCase("cancel")) {
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
            player.sendMessage("\u00a7cCancelled!");
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> MainMenu.openMainMenu(player));
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
            player.sendMessage("\u00a7cYou must hold an item in your hand!");
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            switch (mode) {
                case RENAME: {
                    meta.setDisplayName(ColorUtils.translateColorCodes(message));
                    item.setItemMeta(meta);
                    player.sendMessage("\u00a7aItem renamed successfully!");
                    break;
                }
                case LORE_LINE_1: 
                case LORE_LINE_2: 
                case LORE_LINE_3: 
                case LORE_LINE_4: 
                case LORE_LINE_5: 
                case LORE_LINE_6: 
                case LORE_LINE_7: 
                case LORE_LINE_8: 
                case LORE_LINE_9: 
                case LORE_LINE_10: {
                    List lore;
                    int lineNumber = Integer.parseInt(mode.name().replace("LORE_LINE_", ""));
                    List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                    while (lore.size() < lineNumber - 1) {
                        lore.add("");
                    }
                    if (lore.size() < lineNumber) {
                        lore.add(ColorUtils.translateColorCodes(message));
                    } else {
                        lore.set(lineNumber - 1, ColorUtils.translateColorCodes(message));
                    }
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                    player.sendMessage("\u00a7aLore line " + lineNumber + " added successfully!");
                    break;
                }
                case ENCHANT_CUSTOM_LEVEL: {
                    this.handleCustomEnchantmentLevel(player, item, message);
                    break;
                }
                case ACTION_LEFTCLICK_COMMAND: {
                    this.handleActionCommand(player, item, message, "action_leftclick_command");
                    break;
                }
                case ACTION_RIGHTCLICK_COMMAND: {
                    this.handleActionCommand(player, item, message, "action_rightclick_command");
                    break;
                }
                case ACTION_LEFTCLICK_HEAL: {
                    this.handleActionHeal(player, item, message, "action_leftclick_heal");
                    break;
                }
                case ACTION_RIGHTCLICK_HEAL: {
                    this.handleActionHeal(player, item, message, "action_rightclick_heal");
                    break;
                }
                case ACTION_CUSTOM_MESSAGE: {
                    this.handleCustomMessage(player, item, message);
                }
            }
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
            MainMenu.openMainMenu(player);
        });
    }

    private void handleCustomEnchantmentLevel(Player player, ItemStack item, String message) {
        try {
            String cleanMessage = message.replaceAll("[\u00a7&][0-9a-fk-or]", "").trim();
            int level = Integer.parseInt(cleanMessage);
            if (level <= 0) {
                player.sendMessage("\u00a7cLevel must be greater than 0!");
                this.plugin.getAwaitingInput().remove(player.getUniqueId());
                return;
            }
            if (level > 255) {
                player.sendMessage("\u00a7cLevel cannot exceed 255!");
                this.plugin.getAwaitingInput().remove(player.getUniqueId());
                return;
            }
            Enchantment enchant = this.getSelectedEnchantment(player);
            if (enchant == null) {
                player.sendMessage("\u00a7cNo enchantment selected!");
                this.plugin.getAwaitingInput().remove(player.getUniqueId());
                return;
            }
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.addEnchant(enchant, level, true);
                item.setItemMeta(meta);
                player.getInventory().setItemInMainHand(item);
                player.sendMessage("\u00a7aEnchantment added with level " + level + "!");
            }
            this.clearSelectedEnchantment(player);
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cInvalid number! Please enter a valid level.");
            player.sendMessage("\u00a77Input received: \u00a7e" + message);
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
        }
    }

    private Enchantment getSelectedEnchantment(Player player) {
        return this.plugin.getInventoryListener().getSelectedEnchantment(player);
    }

    private void clearSelectedEnchantment(Player player) {
        this.plugin.getInventoryListener().clearPlayerEnchantment(player);
    }

    private void handleActionCommand(Player player, ItemStack item, String message, String keyName) {
        String cleanMessage = message.replaceAll("[\u00a7&][0-9a-fk-or]", "").trim();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, keyName);
            pdc.set(key, PersistentDataType.STRING, (Object)cleanMessage);
            item.setItemMeta(meta);
        }
        player.getInventory().setItemInMainHand(item);
        player.sendMessage("\u00a7aCommand action set!");
        player.sendMessage("\u00a77Command: \u00a7e" + cleanMessage);
        this.plugin.getAwaitingInput().remove(player.getUniqueId());
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ActionsMenu.openActionsMenu(player));
    }

    private void handleActionHeal(Player player, ItemStack item, String message, String keyName) {
        try {
            String cleanMessage = message.replaceAll("[\u00a7&][0-9a-fk-or]", "").trim();
            double healAmount = Double.parseDouble(cleanMessage);
            if (healAmount <= 0.0) {
                player.sendMessage("\u00a7cHeal amount must be greater than 0!");
                this.plugin.getAwaitingInput().remove(player.getUniqueId());
                return;
            }
            if (healAmount > 20.0) {
                player.sendMessage("\u00a7cHeal amount cannot exceed 20 hearts!");
                this.plugin.getAwaitingInput().remove(player.getUniqueId());
                return;
            }
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                PersistentDataContainer pdc = meta.getPersistentDataContainer();
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, keyName);
                pdc.set(key, PersistentDataType.DOUBLE, (Object)healAmount);
                item.setItemMeta(meta);
            }
            player.getInventory().setItemInMainHand(item);
            player.sendMessage("\u00a7aHealing action set!");
            player.sendMessage("\u00a77Heals: \u00a7c+" + healAmount + "\u2764");
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ActionsMenu.openActionsMenu(player));
        }
        catch (NumberFormatException e) {
            player.sendMessage("\u00a7cInvalid number! Please enter a valid heal amount.");
            this.plugin.getAwaitingInput().remove(player.getUniqueId());
        }
    }

    private void handleCustomMessage(Player player, ItemStack item, String message) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "action_custom_message");
            String translatedMessage = ColorUtils.translateColorCodes(message);
            if (translatedMessage.equalsIgnoreCase("none") || translatedMessage.equalsIgnoreCase("disable") || translatedMessage.equalsIgnoreCase("off")) {
                pdc.set(key, PersistentDataType.STRING, (Object)"NONE");
                player.sendMessage("\u00a7cAction messages disabled!");
            } else {
                pdc.set(key, PersistentDataType.STRING, (Object)translatedMessage);
                player.sendMessage("\u00a7aCustom action message set!");
                player.sendMessage("\u00a77Message: " + translatedMessage);
            }
            item.setItemMeta(meta);
        }
        player.getInventory().setItemInMainHand(item);
        this.plugin.getAwaitingInput().remove(player.getUniqueId());
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ActionsMenu.openActionsMenu(player));
    }
}

