/*
 * Decompiled with CFR 0.152.
 */
package de.simon.speedy.itemeditor.listeners;

import de.simon.speedy.itemeditor.ItemEditor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class ActionListener
implements Listener {
    private final ItemEditor plugin;

    public ActionListener(ItemEditor plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean isRightClick;
        Action action = event.getAction();
        boolean isLeftClick = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK;
        boolean bl = isRightClick = action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK;
        if (!isLeftClick && !isRightClick) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        boolean hasAction = false;
        String prefix = this.getConfigMessage("prefix");
        Player target = this.getTargetPlayer(player);
        NamespacedKey customMessageKey = new NamespacedKey((Plugin)this.plugin, "action_custom_message");
        String customMessage = null;
        if (pdc.has(customMessageKey, PersistentDataType.STRING)) {
            customMessage = (String)pdc.get(customMessageKey, PersistentDataType.STRING);
        }
        if (isLeftClick) {
            NamespacedKey leftHealKey;
            boolean pvpEnabled = this.plugin.getConfig().getBoolean("settings.pvp-enabled", true);
            NamespacedKey leftCommandKey = new NamespacedKey((Plugin)this.plugin, "action_leftclick_command");
            if (pdc.has(leftCommandKey, PersistentDataType.STRING)) {
                if (target == null) {
                    return;
                }
                if (!pvpEnabled && target != null) {
                    player.sendMessage(prefix + "&cPvP actions are disabled!");
                    return;
                }
                String command = (String)pdc.get(leftCommandKey, PersistentDataType.STRING);
                this.executeCommand(player, target, command, prefix, customMessage);
                hasAction = true;
            }
            if (pdc.has(leftHealKey = new NamespacedKey((Plugin)this.plugin, "action_leftclick_heal"), PersistentDataType.DOUBLE)) {
                double healAmount = (Double)pdc.get(leftHealKey, PersistentDataType.DOUBLE);
                this.healPlayer(player, player, healAmount, prefix, customMessage);
                hasAction = true;
            }
        }
        if (isRightClick) {
            NamespacedKey rightHealKey;
            NamespacedKey rightCommandKey = new NamespacedKey((Plugin)this.plugin, "action_rightclick_command");
            if (pdc.has(rightCommandKey, PersistentDataType.STRING)) {
                String command = (String)pdc.get(rightCommandKey, PersistentDataType.STRING);
                this.executeCommand(player, target, command, prefix, customMessage);
                hasAction = true;
            }
            if (pdc.has(rightHealKey = new NamespacedKey((Plugin)this.plugin, "action_rightclick_heal"), PersistentDataType.DOUBLE)) {
                double healAmount = (Double)pdc.get(rightHealKey, PersistentDataType.DOUBLE);
                if (target != null) {
                    this.healPlayer(player, target, healAmount, prefix, customMessage);
                    hasAction = true;
                } else {
                    return;
                }
            }
        }
        NamespacedKey consumableKey = new NamespacedKey((Plugin)this.plugin, "action_consumable");
        if (hasAction && ((Boolean)pdc.getOrDefault(consumableKey, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItemInMainHand(item);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        NamespacedKey hitEnabledKey;
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (!((Boolean)pdc.getOrDefault(hitEnabledKey = new NamespacedKey((Plugin)this.plugin, "action_hit_enabled"), PersistentDataType.BOOLEAN, (Object)true)).booleanValue()) {
            return;
        }
        NamespacedKey noPvpKey = new NamespacedKey((Plugin)this.plugin, "action_nopvp");
        if (((Boolean)pdc.getOrDefault(noPvpKey, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            return;
        }
        boolean hasAction = false;
        String prefix = this.getConfigMessage("prefix");
        Player target = event.getEntity() instanceof Player ? (Player)event.getEntity() : null;
        NamespacedKey customMessageKey = new NamespacedKey((Plugin)this.plugin, "action_custom_message");
        String customMessage = null;
        if (pdc.has(customMessageKey, PersistentDataType.STRING)) {
            customMessage = (String)pdc.get(customMessageKey, PersistentDataType.STRING);
        }
        boolean pvpEnabled = this.plugin.getConfig().getBoolean("settings.pvp-enabled", true);
        NamespacedKey leftCommandKey = new NamespacedKey((Plugin)this.plugin, "action_leftclick_command");
        if (pdc.has(leftCommandKey, PersistentDataType.STRING)) {
            if (target == null) {
                return;
            }
            if (!pvpEnabled && target != null) {
                player.sendMessage(prefix + "&cPvP actions are disabled!");
                event.setCancelled(true);
                return;
            }
            String command = (String)pdc.get(leftCommandKey, PersistentDataType.STRING);
            this.executeCommand(player, target, command, prefix, customMessage);
            hasAction = true;
        }
        NamespacedKey consumableKey = new NamespacedKey((Plugin)this.plugin, "action_consumable");
        if (hasAction && ((Boolean)pdc.getOrDefault(consumableKey, PersistentDataType.BOOLEAN, (Object)false)).booleanValue()) {
            item.setAmount(item.getAmount() - 1);
            player.getInventory().setItemInMainHand(item);
        }
    }

    private Player getTargetPlayer(Player player) {
        double distance = this.plugin.getConfig().getDouble("settings.target-distance", 10.0);
        RayTraceResult result = player.getWorld().rayTraceEntities(player.getEyeLocation(), player.getEyeLocation().getDirection(), distance, entity -> entity instanceof Player && !entity.equals((Object)player));
        if (result != null && result.getHitEntity() instanceof Player) {
            return (Player)result.getHitEntity();
        }
        return null;
    }

    private void executeCommand(Player executor, Player target, String command, String prefix, String customMessage) {
        try {
            String finalCommand = command.replace("%player%", executor.getName()).replace("%target%", target != null ? target.getName() : executor.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
            if (customMessage != null && !customMessage.equals("NONE")) {
                executor.sendMessage(customMessage);
            } else if (customMessage == null || !customMessage.equals("NONE")) {
                executor.sendMessage(prefix + this.getConfigMessage("action-executed"));
            }
        }
        catch (Exception e) {
            executor.sendMessage(prefix + this.getConfigMessage("command-failed"));
            this.plugin.getLogger().warning("Failed to execute command: " + command);
            this.plugin.getLogger().warning("Error: " + e.getMessage());
        }
    }

    private void healPlayer(Player healer, Player target, double healAmount, String prefix, String customMessage) {
        double newHealth = Math.min(target.getHealth() + healAmount, 20.0);
        target.setHealth(newHealth);
        if (customMessage != null && !customMessage.equals("NONE")) {
            healer.sendMessage(customMessage);
            if (!healer.equals((Object)target)) {
                target.sendMessage(customMessage);
            }
        } else if (customMessage == null || !customMessage.equals("NONE")) {
            if (healer.equals((Object)target)) {
                healer.sendMessage(prefix + this.getConfigMessage("healed-self").replace("{amount}", String.valueOf(healAmount)));
            } else {
                healer.sendMessage(prefix + this.getConfigMessage("healed-target").replace("{target}", target.getName()).replace("{amount}", String.valueOf(healAmount)));
                target.sendMessage(prefix + this.getConfigMessage("received-heal").replace("{healer}", healer.getName()).replace("{amount}", String.valueOf(healAmount)));
            }
        }
    }

    private String getConfigMessage(String path) {
        String message = this.plugin.getConfig().getString("messages." + path, path);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

