/*
 * Decompiled with CFR 0.152.
 */
package de.fly.plugin;

import de.fly.plugin.ConfigManager;
import de.fly.plugin.FlyPlugin;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlyCommand
implements CommandExecutor {
    private final FlyPlugin plugin;
    private final ConfigManager config;

    public FlyCommand(FlyPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (this.config.shouldLogCommands()) {
            this.plugin.getLogger().info(String.valueOf(sender.getName()) + " executed /fly " + String.join((CharSequence)" ", args));
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.config.getMessage("player_only_command", new String[0]));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("fly.fly")) {
                player.sendMessage(this.config.getMessage("no_permission_self", new String[0]));
                if (this.config.shouldLogPermissionDenied()) {
                    this.plugin.getLogger().warning(String.valueOf(player.getName()) + " tried to use /fly without permission");
                }
                return true;
            }
            this.toggleFlightSelf(player);
            return true;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("speed")) {
            int speed;
            Player player;
            block21: {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(this.config.getMessage("player_only_command", new String[0]));
                    return true;
                }
                player = (Player)sender;
                if (!player.hasPermission("fly.speed")) {
                    player.sendMessage(this.config.getMessage("no_permission_speed", new String[0]));
                    return true;
                }
                try {
                    speed = Integer.parseInt(args[1]);
                    if (speed >= 1 && speed <= 10) break block21;
                    player.sendMessage(this.config.getMessage("invalid_speed", new String[0]));
                    return true;
                }
                catch (NumberFormatException e) {
                    player.sendMessage(this.config.getMessage("invalid_speed", new String[0]));
                    return true;
                }
            }
            this.setFlightSpeed(player, speed);
            player.sendMessage(this.config.getMessage("speed_changed_self", "speed", String.valueOf(speed)));
            return true;
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("speed")) {
            int speed;
            Player target;
            block22: {
                if (!sender.hasPermission("other.fly") || !sender.hasPermission("fly.speed")) {
                    sender.sendMessage(this.config.getMessage("no_permission_other", new String[0]));
                    return true;
                }
                String targetName = args[0];
                target = Bukkit.getPlayer((String)targetName);
                if (target == null) {
                    sender.sendMessage(this.config.getMessage("player_not_found", "player", targetName));
                    return true;
                }
                try {
                    speed = Integer.parseInt(args[2]);
                    if (speed >= 1 && speed <= 10) break block22;
                    sender.sendMessage(this.config.getMessage("invalid_speed", new String[0]));
                    return true;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.config.getMessage("invalid_speed", new String[0]));
                    return true;
                }
            }
            this.setFlightSpeed(target, speed);
            target.sendMessage(this.config.getMessage("speed_changed_other_target", "speed", String.valueOf(speed), "sender", sender.getName()));
            sender.sendMessage(this.config.getMessage("speed_changed_other_sender", "player", target.getName(), "speed", String.valueOf(speed)));
            return true;
        }
        if (args.length == 1) {
            if (!sender.hasPermission("other.fly")) {
                sender.sendMessage(this.config.getMessage("no_permission_other", new String[0]));
                if (this.config.shouldLogPermissionDenied()) {
                    this.plugin.getLogger().warning(String.valueOf(sender.getName()) + " tried to use /fly on others without permission");
                }
                return true;
            }
            String targetName = args[0];
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                sender.sendMessage(this.config.getMessage("player_not_found", "player", targetName));
                return true;
            }
            this.toggleFlightForOther(sender, target);
            return true;
        }
        sender.sendMessage(this.config.getMessage("usage_fly", new String[0]));
        return true;
    }

    private void toggleFlightSelf(Player player) {
        if (player.getAllowFlight()) {
            player.setAllowFlight(false);
            player.setFlying(false);
            player.sendMessage(this.config.getMessage("fly_disabled_self", new String[0]));
        } else {
            player.setAllowFlight(true);
            player.sendMessage(this.config.getMessage("fly_enabled_self", new String[0]));
        }
    }

    private void toggleFlightForOther(CommandSender sender, Player target) {
        if (target.getAllowFlight()) {
            target.setAllowFlight(false);
            target.setFlying(false);
            target.sendMessage(this.config.getMessage("fly_disabled_other_target", "sender", sender.getName()));
            sender.sendMessage(this.config.getMessage("fly_disabled_other_sender", "player", target.getName()));
        } else {
            target.setAllowFlight(true);
            target.sendMessage(this.config.getMessage("fly_enabled_other_target", "sender", sender.getName()));
            sender.sendMessage(this.config.getMessage("fly_enabled_other_sender", "player", target.getName()));
        }
    }

    private void setFlightSpeed(Player player, int speed) {
        float flightSpeed = (float)speed / 10.0f;
        player.setFlySpeed(flightSpeed);
    }
}

