/*
 * Decompiled with CFR 0.152.
 */
package de.fly.plugin;

import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public String getPrefix() {
        if (this.config.getBoolean("settings.use_prefix", true)) {
            return this.colorize(this.config.getString("settings.prefix", "&8[&6FlyPlugin&8] "));
        }
        return "";
    }

    public String getMessage(String key, String ... placeholders) {
        String message = this.config.getString("messages." + key, "&cMessage not found: " + key);
        message = String.valueOf(this.getPrefix()) + message;
        message = this.colorize(message);
        if (placeholders.length >= 2) {
            int i = 0;
            while (i < placeholders.length) {
                String placeholder = placeholders[i];
                String value = placeholders[i + 1];
                message = message.replace("{" + placeholder + "}", value);
                i += 2;
            }
        }
        return message;
    }

    public String getMessageRaw(String key, String ... placeholders) {
        String message = this.config.getString("messages." + key, "&cMessage not found: " + key);
        message = this.colorize(message);
        if (placeholders.length >= 2) {
            int i = 0;
            while (i < placeholders.length) {
                String placeholder = placeholders[i];
                String value = placeholders[i + 1];
                message = message.replace("{" + placeholder + "}", value);
                i += 2;
            }
        }
        return message;
    }

    public boolean shouldLogCommands() {
        return this.config.getBoolean("settings.log_commands", true);
    }

    public boolean shouldLogPermissionDenied() {
        return this.config.getBoolean("settings.log_permission_denied", false);
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

