/*
 * Decompiled with CFR 0.152.
 */
package eu.simolzimol.bossbarannouncement.models;

public class Announcement {
    private final String message;
    private final TimeUnit timeUnit;
    private final int duration;
    private final long startTime;
    private final long endTime;

    public Announcement(String message, TimeUnit timeUnit, int duration) {
        this.message = message;
        this.timeUnit = timeUnit;
        this.duration = duration;
        this.startTime = System.currentTimeMillis();
        this.endTime = timeUnit == TimeUnit.INFINITE ? -1L : this.startTime + timeUnit.toMilliseconds(duration);
    }

    public Announcement(String message, TimeUnit timeUnit, int duration, long startTime, long endTime) {
        this.message = message;
        this.timeUnit = timeUnit;
        this.duration = duration;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String getMessage() {
        return this.message;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isExpired() {
        if (this.timeUnit == TimeUnit.INFINITE) {
            return false;
        }
        return System.currentTimeMillis() >= this.endTime;
    }

    public double getProgress() {
        if (this.timeUnit == TimeUnit.INFINITE) {
            return 1.0;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.endTime) {
            return 0.0;
        }
        long totalDuration = this.endTime - this.startTime;
        long remainingTime = this.endTime - currentTime;
        return (double)remainingTime / (double)totalDuration;
    }

    public String getRemainingTimeFormatted() {
        if (this.timeUnit == TimeUnit.INFINITE) {
            return "\u221e";
        }
        long remaining = this.endTime - System.currentTimeMillis();
        if (remaining <= 0L) {
            return "0s";
        }
        long seconds = remaining / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + "d " + hours % 24L + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes % 60L + "m";
        }
        if (minutes > 0L) {
            return minutes + "m " + seconds % 60L + "s";
        }
        return seconds + "s";
    }

    public static enum TimeUnit {
        MINUTES(60000L),
        HOURS(3600000L),
        DAYS(86400000L),
        INFINITE(0L);

        private final long milliseconds;

        private TimeUnit(long milliseconds) {
            this.milliseconds = milliseconds;
        }

        public long toMilliseconds(int amount) {
            if (this == INFINITE) {
                return 0L;
            }
            return this.milliseconds * (long)amount;
        }

        public static TimeUnit fromString(String str) {
            switch (str.toLowerCase()) {
                case "minutes": 
                case "minute": 
                case "min": 
                case "m": {
                    return MINUTES;
                }
                case "hours": 
                case "hour": 
                case "h": {
                    return HOURS;
                }
                case "days": 
                case "day": 
                case "d": {
                    return DAYS;
                }
                case "infinite": 
                case "inf": 
                case "forever": 
                case "permanent": {
                    return INFINITE;
                }
            }
            return null;
        }
    }
}

