/*
 * Decompiled with CFR 0.152.
 */
package eu.simolzimol.bossbarannouncement.managers;

import eu.simolzimol.bossbarannouncement.BossBarAnnouncement;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private final BossBarAnnouncement plugin;
    private FileConfiguration messages;
    private File messagesFile;

    public MessageManager(BossBarAnnouncement plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        InputStream defaultStream = this.plugin.getResource("messages.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.messages.setDefaults((Configuration)defaultConfig);
        }
    }

    public void reload() {
        this.loadMessages();
    }

    public String getMessage(String key) {
        String message = this.messages.getString(key);
        if (message == null) {
            return String.valueOf(ChatColor.RED) + "Message not found: " + key;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public void save() {
        try {
            this.messages.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save messages.yml: " + e.getMessage());
        }
    }
}

