/*
 * Decompiled with CFR 0.152.
 */
package eu.simolzimol.bossbarannouncement.managers;

import eu.simolzimol.bossbarannouncement.BossBarAnnouncement;
import eu.simolzimol.bossbarannouncement.models.Announcement;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BossBarController
implements Listener {
    private final BossBarAnnouncement plugin;
    private BossBar bossBar;
    private BukkitTask updateTask;
    private Announcement currentAnnouncement;

    public BossBarController(BossBarAnnouncement plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void startAnnouncement(Announcement announcement) {
        this.stopAnnouncement();
        this.currentAnnouncement = announcement;
        this.bossBar = Bukkit.createBossBar((String)announcement.getMessage(), (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        double initialProgress = announcement.getProgress();
        this.bossBar.setProgress(Math.max(0.01, Math.min(1.0, initialProgress)));
        this.bossBar.setVisible(true);
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("bossbar.see")) continue;
            this.bossBar.addPlayer(player);
        }
        this.updateTask = new BukkitRunnable(){

            public void run() {
                if (BossBarController.this.currentAnnouncement == null || BossBarController.this.bossBar == null) {
                    this.cancel();
                    return;
                }
                if (BossBarController.this.currentAnnouncement.isExpired()) {
                    Bukkit.getScheduler().runTask((Plugin)BossBarController.this.plugin, () -> {
                        BossBarController.this.stopAnnouncement();
                        BossBarController.this.plugin.getAnnouncementManager().removeAnnouncement();
                    });
                    this.cancel();
                    return;
                }
                double progress = BossBarController.this.currentAnnouncement.getProgress();
                progress = Math.max(0.01, Math.min(1.0, progress));
                BossBarController.this.bossBar.setProgress(progress);
                if (progress > 0.66) {
                    BossBarController.this.bossBar.setColor(BarColor.GREEN);
                } else if (progress > 0.33) {
                    BossBarController.this.bossBar.setColor(BarColor.YELLOW);
                } else {
                    BossBarController.this.bossBar.setColor(BarColor.RED);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void stopAnnouncement() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        if (this.bossBar != null) {
            this.bossBar.removeAll();
            this.bossBar = null;
        }
        this.currentAnnouncement = null;
    }

    public void shutdown() {
        this.stopAnnouncement();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.bossBar != null && player.hasPermission("bossbar.see")) {
            this.bossBar.addPlayer(player);
        }
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }
}

