/*
 * Decompiled with CFR 0.152.
 */
package eu.simolzimol.bossbarannouncement.managers;

import eu.simolzimol.bossbarannouncement.BossBarAnnouncement;
import eu.simolzimol.bossbarannouncement.models.Announcement;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.YamlConfiguration;

public class AnnouncementManager {
    private final BossBarAnnouncement plugin;
    private final File announcementFile;
    private Announcement currentAnnouncement;

    public AnnouncementManager(BossBarAnnouncement plugin) {
        this.plugin = plugin;
        this.announcementFile = new File(plugin.getDataFolder(), "announcement.yml");
    }

    public void createAnnouncement(String message, Announcement.TimeUnit timeUnit, int duration) {
        if (this.currentAnnouncement != null) {
            this.removeAnnouncement();
        }
        this.currentAnnouncement = new Announcement(message, timeUnit, duration);
        this.saveAnnouncement();
        this.plugin.getBossBarController().startAnnouncement(this.currentAnnouncement);
    }

    public void removeAnnouncement() {
        if (this.currentAnnouncement != null) {
            this.plugin.getBossBarController().stopAnnouncement();
            this.currentAnnouncement = null;
            if (this.announcementFile.exists()) {
                this.announcementFile.delete();
            }
        }
    }

    public Announcement getCurrentAnnouncement() {
        return this.currentAnnouncement;
    }

    public boolean hasActiveAnnouncement() {
        return this.currentAnnouncement != null && !this.currentAnnouncement.isExpired();
    }

    public void loadAnnouncement() {
        if (!this.announcementFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.announcementFile);
        String message = config.getString("message");
        String timeUnitStr = config.getString("timeUnit");
        int duration = config.getInt("duration");
        long startTime = config.getLong("startTime");
        long endTime = config.getLong("endTime");
        if (message == null || timeUnitStr == null) {
            return;
        }
        Announcement.TimeUnit timeUnit = Announcement.TimeUnit.fromString(timeUnitStr);
        if (timeUnit == null) {
            return;
        }
        this.currentAnnouncement = new Announcement(message, timeUnit, duration, startTime, endTime);
        if (this.currentAnnouncement.isExpired()) {
            this.removeAnnouncement();
            return;
        }
        this.plugin.getBossBarController().startAnnouncement(this.currentAnnouncement);
    }

    private void saveAnnouncement() {
        if (this.currentAnnouncement == null) {
            return;
        }
        YamlConfiguration config = new YamlConfiguration();
        config.set("message", (Object)this.currentAnnouncement.getMessage());
        config.set("timeUnit", (Object)this.currentAnnouncement.getTimeUnit().name());
        config.set("duration", (Object)this.currentAnnouncement.getDuration());
        config.set("startTime", (Object)this.currentAnnouncement.getStartTime());
        config.set("endTime", (Object)this.currentAnnouncement.getEndTime());
        try {
            config.save(this.announcementFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save announcement: " + e.getMessage());
        }
    }
}

