/*
 * Decompiled with CFR 0.152.
 */
package eu.simolzimol.bossbarannouncement.commands;

import eu.simolzimol.bossbarannouncement.BossBarAnnouncement;
import eu.simolzimol.bossbarannouncement.managers.MessageManager;
import eu.simolzimol.bossbarannouncement.models.Announcement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class AnnouncementCommand
implements CommandExecutor,
TabCompleter {
    private final BossBarAnnouncement plugin;
    private final MessageManager msg;

    public AnnouncementCommand(BossBarAnnouncement plugin) {
        this.plugin = plugin;
        this.msg = plugin.getMessageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!sender.hasPermission("bossbar.admin")) {
            sender.sendMessage(this.msg.getMessage("no-permission"));
            return true;
        }
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "create": {
                return this.handleCreate(sender, args);
            }
            case "remove": 
            case "delete": 
            case "stop": {
                return this.handleRemove(sender);
            }
            case "info": 
            case "status": {
                return this.handleInfo(sender);
            }
            case "reload": {
                return this.handleReload(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleCreate(CommandSender sender, String[] args) {
        int duration;
        if (args.length < 4) {
            sender.sendMessage(this.msg.getMessage("create-usage"));
            return true;
        }
        String timeUnitStr = args[1];
        Announcement.TimeUnit timeUnit = Announcement.TimeUnit.fromString(timeUnitStr);
        if (timeUnit == null) {
            sender.sendMessage(this.msg.getMessage("invalid-timeunit"));
            return true;
        }
        try {
            duration = Integer.parseInt(args[2]);
            if (duration < 0) {
                sender.sendMessage(this.msg.getMessage("invalid-duration"));
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.msg.getMessage("invalid-duration"));
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 3; i < args.length; ++i) {
            if (i > 3) {
                messageBuilder.append(" ");
            }
            messageBuilder.append(args[i]);
        }
        String message = messageBuilder.toString().replace("&", "\u00a7");
        this.plugin.getAnnouncementManager().createAnnouncement(message, timeUnit, duration);
        sender.sendMessage(this.msg.getMessage("announcement-created").replace("{message}", message).replace("{duration}", duration + " " + timeUnit.name().toLowerCase()));
        return true;
    }

    private boolean handleRemove(CommandSender sender) {
        if (!this.plugin.getAnnouncementManager().hasActiveAnnouncement()) {
            sender.sendMessage(this.msg.getMessage("no-active-announcement"));
            return true;
        }
        this.plugin.getAnnouncementManager().removeAnnouncement();
        sender.sendMessage(this.msg.getMessage("announcement-removed"));
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        if (!this.plugin.getAnnouncementManager().hasActiveAnnouncement()) {
            sender.sendMessage(this.msg.getMessage("no-active-announcement"));
            return true;
        }
        Announcement announcement = this.plugin.getAnnouncementManager().getCurrentAnnouncement();
        sender.sendMessage(this.msg.getMessage("announcement-info").replace("{message}", announcement.getMessage()).replace("{timeunit}", announcement.getTimeUnit().name()).replace("{duration}", String.valueOf(announcement.getDuration())).replace("{remaining}", announcement.getRemainingTimeFormatted()));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        this.plugin.reloadConfig();
        this.plugin.getMessageManager().reload();
        sender.sendMessage(this.msg.getMessage("config-reloaded"));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.msg.getMessage("help-header"));
        sender.sendMessage(this.msg.getMessage("help-create"));
        sender.sendMessage(this.msg.getMessage("help-remove"));
        sender.sendMessage(this.msg.getMessage("help-info"));
        sender.sendMessage(this.msg.getMessage("help-reload"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("bossbar.admin")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            return Arrays.asList("create", "remove", "info", "reload", "help");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("create")) {
            return Arrays.asList("minutes", "hours", "days", "infinite");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("create")) {
            String timeUnit = args[1].toLowerCase();
            if (timeUnit.equals("infinite")) {
                return Arrays.asList("0");
            }
            return Arrays.asList("1", "5", "10", "30", "60");
        }
        return new ArrayList<String>();
    }
}

