/*
 * Decompiled with CFR 0.152.
 */
package com.example.SimpleGroupsAndClaims;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.Vector;

public class SimpleGroupsAndClaims
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private static final Set<ChatColor> ALLOWED_COLORS = Collections.unmodifiableSet(new HashSet<ChatColor>(Arrays.asList(ChatColor.BLACK, ChatColor.DARK_BLUE, ChatColor.DARK_GREEN, ChatColor.DARK_AQUA, ChatColor.DARK_RED, ChatColor.DARK_PURPLE, ChatColor.GOLD, ChatColor.GRAY, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.GREEN, ChatColor.AQUA, ChatColor.RED, ChatColor.LIGHT_PURPLE, ChatColor.YELLOW, ChatColor.WHITE)));
    private static final String ALLOWED_COLORS_STRING = ALLOWED_COLORS.stream().map(Enum::name).collect(Collectors.joining(", "));
    private Map<String, Group> groups = new HashMap<String, Group>();
    private Map<UUID, Group> playerGroups = new HashMap<UUID, Group>();
    private Map<UUID, String> pendingInvites = new HashMap<UUID, String>();
    private Map<String, Set<String>> pendingAllianceRequests = new HashMap<String, Set<String>>();
    private Map<Chunk, Group> claimedChunks = new HashMap<Chunk, Group>();
    private Map<UUID, Boolean> mapToggled = new HashMap<UUID, Boolean>();
    private Map<UUID, Float> lastYaw = new HashMap<UUID, Float>();
    private Map<UUID, String> lastZone = new HashMap<UUID, String>();
    private Map<UUID, Long> pvpTimers = new HashMap<UUID, Long>();
    private Map<UUID, BossBar> pvpBossBars = new HashMap<UUID, BossBar>();
    private Map<UUID, UUID> lastDamager = new HashMap<UUID, UUID>();
    private Map<UUID, BukkitRunnable> pvpTimerTasks = new HashMap<UUID, BukkitRunnable>();
    private Set<Chunk> spawnSafeZones = new HashSet<Chunk>();
    private Set<Chunk> neutralZones = new HashSet<Chunk>();
    private File groupsFile;
    private FileConfiguration groupsConfig;
    private FileConfiguration config;
    private int startingClaims;
    private int claimGrowthPerWeek;
    private long pvpTimerDuration;
    private int minGroupNameLength;
    private int maxGroupNameLength;
    private List<String> groupNameBlacklist;
    private long inactivityDays;
    private int maxLocksPerChunk;
    private final int MAP_SIZE = 9;
    private final int MAP_RADIUS = 4;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("g").setExecutor((CommandExecutor)this);
        this.getCommand("g").setTabCompleter((TabCompleter)this);
        this.loadConfig();
        this.loadGroups();
        for (Group group : this.groups.values()) {
            for (Chunk chunk : group.getClaims()) {
                this.claimedChunks.put(chunk, group);
            }
        }
        new BukkitRunnable(){

            public void run() {
                SimpleGroupsAndClaims.this.checkInactivity();
            }
        }.runTaskTimer((Plugin)this, 0L, 1728000L);
    }

    public void onDisable() {
        for (BossBar bar : this.pvpBossBars.values()) {
            bar.removeAll();
        }
        this.pvpBossBars.clear();
        for (BukkitRunnable task : this.pvpTimerTasks.values()) {
            task.cancel();
        }
        this.pvpTimerTasks.clear();
        this.saveGroups();
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.startingClaims = this.config.getInt("group.starting-claims", 10);
        this.claimGrowthPerWeek = this.config.getInt("group.claim-growth-per-week", 2);
        this.pvpTimerDuration = this.config.getLong("pvp.timer-duration-seconds", 15L) * 1000L;
        this.minGroupNameLength = this.config.getInt("group.name.min-length", 3);
        this.maxGroupNameLength = this.config.getInt("group.name.max-length", 20);
        this.groupNameBlacklist = this.config.getStringList("group.name.blacklist");
        this.inactivityDays = this.config.getLong("group.inactivity-days", 30L);
        this.maxLocksPerChunk = this.config.getInt("group.max-locks-per-chunk", 25);
        if (this.startingClaims < 0) {
            this.startingClaims = 0;
        }
        if (this.claimGrowthPerWeek < 0) {
            this.claimGrowthPerWeek = 0;
        }
        if (this.pvpTimerDuration < 0L) {
            this.pvpTimerDuration = 0L;
        }
        if (this.minGroupNameLength < 1) {
            this.minGroupNameLength = 1;
        }
        if (this.maxGroupNameLength < this.minGroupNameLength) {
            this.maxGroupNameLength = this.minGroupNameLength;
        }
        if (this.inactivityDays < 0L) {
            this.inactivityDays = 0L;
        }
        if (this.maxLocksPerChunk < 0) {
            this.maxLocksPerChunk = 0;
        }
    }

    private boolean isBlockSupportingDoor(Block block) {
        Block above = block.getRelative(BlockFace.UP);
        return Tag.DOORS.isTagged((Keyed)above.getType());
    }

    private boolean isSameLock(Lock lock1, Lock lock2) {
        if (lock1 == lock2) {
            return true;
        }
        if (lock1 == null || lock2 == null) {
            return false;
        }
        return lock1.owner.equals(lock2.owner) && lock1.role == lock2.role && lock1.allowed.equals(lock2.allowed);
    }

    private void loadGroups() {
        ConfigurationSection neutralZonesSection;
        ConfigurationSection safeZonesSection;
        ConfigurationSection alliancesSection;
        ConfigurationSection section;
        this.groupsFile = new File(this.getDataFolder(), "groups.yml");
        if (!this.groupsFile.exists()) {
            try {
                this.groupsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create groups.yml: " + e.getMessage());
            }
        }
        this.groupsConfig = YamlConfiguration.loadConfiguration((File)this.groupsFile);
        for (Object groupName : this.groupsConfig.getKeys(false)) {
            Object uuidStr2;
            if (((String)groupName).equals("pending_invites") || ((String)groupName).equals("pending_alliance_requests") || ((String)groupName).equals("spawn_safe_zones") || ((String)groupName).equals("neutral_zones")) continue;
            section = this.groupsConfig.getConfigurationSection((String)groupName);
            UUID leader = UUID.fromString(section.getString("leader"));
            ArrayList<UUID> members = new ArrayList<UUID>();
            for (Object uuidStr2 : section.getStringList("members")) {
                members.add(UUID.fromString((String)uuidStr2));
            }
            ArrayList<UUID> moderators = new ArrayList<UUID>();
            uuidStr2 = section.getStringList("moderators").iterator();
            while (uuidStr2.hasNext()) {
                String uuidStr3 = (String)uuidStr2.next();
                moderators.add(UUID.fromString(uuidStr3));
            }
            HashSet<Chunk> claims = new HashSet<Chunk>();
            for (String claimStr : section.getStringList("claims")) {
                String[] parts = claimStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                claims.add(world.getChunkAt(x, z));
            }
            long creationTime = section.getLong("creationTime", System.currentTimeMillis());
            HashMap<UUID, Long> lastActive = new HashMap<UUID, Long>();
            ConfigurationSection activeSection = section.getConfigurationSection("last-active");
            if (activeSection != null) {
                for (String uuidStr4 : activeSection.getKeys(false)) {
                    lastActive.put(UUID.fromString(uuidStr4), activeSection.getLong(uuidStr4));
                }
            }
            ChatColor groupColor = ChatColor.WHITE;
            String colorName = section.getString("color");
            if (colorName != null) {
                try {
                    groupColor = ChatColor.valueOf((String)colorName);
                }
                catch (IllegalArgumentException ignored) {
                    this.getLogger().warning("Invalid color for group " + (String)groupName + ": " + colorName);
                }
            }
            Group group = new Group((String)groupName, leader, members, moderators, claims, creationTime, lastActive, groupColor);
            List lockStrings = section.getStringList("locks");
            for (String lockStr : lockStrings) {
                UUID worldUUID;
                World world;
                String[] parts = lockStr.split(":");
                if (parts.length < 6 || (world = Bukkit.getWorld((UUID)(worldUUID = UUID.fromString(parts[0])))) == null) continue;
                int x = Integer.parseInt(parts[1]);
                int y = Integer.parseInt(parts[2]);
                int z = Integer.parseInt(parts[3]);
                Location loc = new Location(world, (double)x, (double)y, (double)z);
                UUID owner = UUID.fromString(parts[4]);
                Role role = Role.valueOf(parts[5]);
                Lock lock = new Lock(owner, role);
                for (int i = 6; i < parts.length; ++i) {
                    lock.allowed.add(UUID.fromString(parts[i]));
                }
                group.getLocks().put(loc, lock);
            }
            this.groups.put((String)groupName, group);
            for (UUID member : members) {
                this.playerGroups.put(member, group);
            }
            for (UUID moderator : moderators) {
                this.playerGroups.put(moderator, group);
            }
            this.playerGroups.put(leader, group);
        }
        for (Object groupName : this.groupsConfig.getKeys(false)) {
            if (((String)groupName).equals("pending_invites") || ((String)groupName).equals("pending_alliance_requests") || ((String)groupName).equals("spawn_safe_zones") || ((String)groupName).equals("neutral_zones")) continue;
            section = this.groupsConfig.getConfigurationSection((String)groupName);
            List allyNames = section.getStringList("allies");
            Group group = this.groups.get(groupName);
            Set<Group> allies = allyNames.stream().map(this.groups::get).filter(Objects::nonNull).collect(Collectors.toSet());
            group.setAllies(allies);
        }
        ConfigurationSection invitesSection = this.groupsConfig.getConfigurationSection("pending_invites");
        if (invitesSection != null) {
            for (Object key : invitesSection.getKeys(false)) {
                UUID playerUUID = UUID.fromString((String)key);
                String groupName = invitesSection.getString((String)key);
                if (!this.groups.containsKey(groupName)) continue;
                this.pendingInvites.put(playerUUID, groupName);
            }
        }
        if ((alliancesSection = this.groupsConfig.getConfigurationSection("pending_alliance_requests")) != null) {
            for (Object targetGroupName : alliancesSection.getKeys(false)) {
                if (!this.groups.containsKey(targetGroupName)) continue;
                List requesters = alliancesSection.getStringList((String)targetGroupName);
                Set validRequesters = requesters.stream().filter(this.groups::containsKey).collect(Collectors.toSet());
                if (validRequesters.isEmpty()) continue;
                this.pendingAllianceRequests.put((String)targetGroupName, validRequesters);
            }
        }
        if ((safeZonesSection = this.groupsConfig.getConfigurationSection("spawn_safe_zones")) != null) {
            for (String zoneStr : safeZonesSection.getStringList("chunks")) {
                String[] parts = zoneStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                this.spawnSafeZones.add(world.getChunkAt(x, z));
            }
        }
        if ((neutralZonesSection = this.groupsConfig.getConfigurationSection("neutral_zones")) != null) {
            for (String zoneStr : neutralZonesSection.getStringList("chunks")) {
                String[] parts = zoneStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                this.neutralZones.add(world.getChunkAt(x, z));
            }
        }
        for (Group group : this.groups.values()) {
            HashMap<Lock, Lock> lockMap = new HashMap<Lock, Lock>();
            HashMap<Location, Lock> newLocks = new HashMap<Location, Lock>();
            for (Map.Entry<Location, Lock> entry : group.getLocks().entrySet()) {
                Location loc = entry.getKey();
                Lock lock = entry.getValue();
                boolean found = false;
                for (Map.Entry existing : lockMap.entrySet()) {
                    if (!this.isSameLock((Lock)existing.getKey(), lock)) continue;
                    newLocks.put(loc, (Lock)existing.getValue());
                    found = true;
                    break;
                }
                if (found) continue;
                lockMap.put(lock, lock);
                newLocks.put(loc, lock);
            }
            group.getLocks().clear();
            group.getLocks().putAll(newLocks);
        }
    }

    private void saveGroups() {
        for (Group group : this.groups.values()) {
            Object moderator2;
            ConfigurationSection configurationSection = this.groupsConfig.createSection(group.getName());
            configurationSection.set("leader", (Object)group.getLeader().toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UUID uUID : group.getMembers()) {
                arrayList.add(uUID.toString());
            }
            configurationSection.set("members", arrayList);
            ArrayList moderators = new ArrayList();
            for (Object moderator2 : group.getModerators()) {
                moderators.add(((UUID)moderator2).toString());
            }
            configurationSection.set("moderators", (Object)moderators);
            ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
            moderator2 = group.getClaims().iterator();
            while (moderator2.hasNext()) {
                Chunk chunk = (Chunk)moderator2.next();
                arrayList2.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
            }
            configurationSection.set("claims", arrayList2);
            configurationSection.set("creationTime", (Object)group.getCreationTime());
            ConfigurationSection activeSection = configurationSection.createSection("last-active");
            for (Map.Entry<UUID, Long> entry : group.getLastActive().entrySet()) {
                activeSection.set(entry.getKey().toString(), (Object)entry.getValue());
            }
            List list = group.getAllies().stream().map(Group::getName).collect(Collectors.toList());
            configurationSection.set("allies", list);
            configurationSection.set("color", (Object)group.getGroupColor().name());
            ArrayList<String> lockStrings = new ArrayList<String>();
            for (Map.Entry<Location, Lock> entry : group.getLocks().entrySet()) {
                Location loc = entry.getKey();
                Lock lock = entry.getValue();
                StringBuilder sb = new StringBuilder();
                sb.append(loc.getWorld().getUID().toString()).append(":").append(loc.getBlockX()).append(":").append(loc.getBlockY()).append(":").append(loc.getBlockZ()).append(":").append(lock.owner.toString()).append(":").append(lock.role.name());
                for (UUID allowed : lock.allowed) {
                    sb.append(":").append(allowed.toString());
                }
                lockStrings.add(sb.toString());
            }
            configurationSection.set("locks", lockStrings);
        }
        ConfigurationSection invitesSection = this.groupsConfig.createSection("pending_invites");
        for (Map.Entry<UUID, String> entry : this.pendingInvites.entrySet()) {
            invitesSection.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        ConfigurationSection configurationSection = this.groupsConfig.createSection("pending_alliance_requests");
        for (Map.Entry<String, Set<String>> entry : this.pendingAllianceRequests.entrySet()) {
            configurationSection.set(entry.getKey(), new ArrayList(entry.getValue()));
        }
        ConfigurationSection configurationSection2 = this.groupsConfig.createSection("spawn_safe_zones");
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (Chunk chunk : this.spawnSafeZones) {
            arrayList.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
        }
        configurationSection2.set("chunks", arrayList);
        ConfigurationSection neutralZonesSection = this.groupsConfig.createSection("neutral_zones");
        ArrayList<CallSite> arrayList3 = new ArrayList<CallSite>();
        for (Chunk chunk : this.neutralZones) {
            arrayList3.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
        }
        neutralZonesSection.set("chunks", arrayList3);
        try {
            this.groupsConfig.save(this.groupsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save groups.yml: " + e.getMessage());
        }
    }

    private boolean isValidGroupName(String name, Player player) {
        if (name.length() < this.minGroupNameLength) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name must be at least " + this.minGroupNameLength + " characters long.");
            return false;
        }
        if (name.length() > this.maxGroupNameLength) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name cannot exceed " + this.maxGroupNameLength + " characters.");
            return false;
        }
        if (this.groupNameBlacklist.stream().anyMatch(name::equalsIgnoreCase)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name is not allowed.");
            return false;
        }
        return true;
    }

    private void checkInactivity() {
        long currentTime = System.currentTimeMillis();
        long inactivityMillis = this.inactivityDays * 24L * 60L * 60L * 1000L;
        ArrayList<String> groupsToDelete = new ArrayList<String>();
        for (Group group : this.groups.values()) {
            ArrayList<UUID> membersToKick = new ArrayList<UUID>();
            for (UUID uUID : group.getMembers()) {
                Long lastActive = group.getLastActive().get(uUID);
                if (lastActive != null && currentTime - lastActive <= inactivityMillis) continue;
                membersToKick.add(uUID);
            }
            ArrayList<UUID> moderatorsToKick = new ArrayList<UUID>();
            for (UUID moderator : group.getModerators()) {
                Long lastActive = group.getLastActive().get(moderator);
                if (lastActive != null && currentTime - lastActive <= inactivityMillis) continue;
                moderatorsToKick.add(moderator);
            }
            Long l = group.getLastActive().get(group.getLeader());
            boolean leaderInactive = l == null || currentTime - l > inactivityMillis;
            for (UUID uUID : membersToKick) {
                group.getMembers().remove(uUID);
                this.playerGroups.remove(uUID);
                this.removePlayerFromLocks(group, uUID);
                for (Group ally : group.getAllies()) {
                    this.removePlayerFromLocks(ally, uUID);
                }
                Player memberPlayer = Bukkit.getPlayer((UUID)uUID);
                if (memberPlayer != null) {
                    memberPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You have been kicked from " + group.getName() + " due to inactivity.");
                }
                this.getLogger().info("Kicked member " + String.valueOf(uUID) + " from " + group.getName() + " due to inactivity.");
            }
            for (UUID uUID : moderatorsToKick) {
                group.getModerators().remove(uUID);
                this.playerGroups.put(uUID, group);
                group.getMembers().add(uUID);
                this.removePlayerFromLocks(group, uUID);
                for (Group ally : group.getAllies()) {
                    this.removePlayerFromLocks(ally, uUID);
                }
                Player modPlayer = Bukkit.getPlayer((UUID)uUID);
                if (modPlayer != null) {
                    modPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You have been demoted from moderator in " + group.getName() + " due to inactivity.");
                }
                this.getLogger().info("Demoted moderator " + String.valueOf(uUID) + " from " + group.getName() + " due to inactivity.");
            }
            if (!leaderInactive || !group.getMembers().isEmpty() || !group.getModerators().isEmpty()) continue;
            groupsToDelete.add(group.getName());
            for (Chunk chunk : group.getClaims()) {
                this.claimedChunks.remove(chunk);
                this.updateScoreboardsForChunk(chunk);
            }
            for (Group group2 : new HashSet<Group>(group.getAllies())) {
                group2.getAllies().remove(group);
                this.removeAllyMembersFromLocks(group2, group);
            }
            this.pendingInvites.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(group.getName()));
            this.pendingAllianceRequests.remove(group.getName());
            this.pendingAllianceRequests.values().forEach(set -> set.remove(group.getName()));
            this.playerGroups.remove(group.getLeader());
            this.groupsConfig.set(group.getName(), null);
            this.getLogger().info("Deleted group " + group.getName() + " due to inactivity of all members, moderators, and leader.");
        }
        for (String groupName : groupsToDelete) {
            this.groups.remove(groupName);
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Group " + groupName + " has been deleted due to inactivity."));
        }
        this.saveGroups();
    }

    private void removePlayerFromLocks(Group group, UUID playerUUID) {
        for (Lock lock : group.getLocks().values()) {
            lock.allowed.remove(playerUUID);
        }
    }

    private void removeAllyMembersFromLocks(Group owningGroup, Group unalliedGroup) {
        HashSet<UUID> unalliedUUIDs = new HashSet<UUID>();
        unalliedUUIDs.add(unalliedGroup.getLeader());
        unalliedUUIDs.addAll(unalliedGroup.getMembers());
        unalliedUUIDs.addAll(unalliedGroup.getModerators());
        for (Lock lock : owningGroup.getLocks().values()) {
            lock.allowed.removeAll(unalliedUUIDs);
        }
        for (UUID uuid : unalliedUUIDs) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Your access to locks in " + owningGroup.getName() + "'s claims has been revoked due to the alliance ending.");
        }
    }

    private void updatePlayerLocks(Group group, UUID playerUUID, Role newRole) {
        for (Lock lock : group.getLocks().values()) {
            if (!lock.owner.equals(playerUUID)) continue;
            lock.role = newRole;
        }
        this.saveGroups();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        String sub = args[0].toLowerCase();
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        switch (sub) {
            case "create": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g create <name>");
                    return true;
                }
                String name = args[1];
                if (this.groups.containsKey(name)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group already exists.");
                    return true;
                }
                if (playerGroup != null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a group.");
                    return true;
                }
                if (!this.isValidGroupName(name, player)) {
                    return true;
                }
                Group newGroup = new Group(name, player.getUniqueId(), new ArrayList<UUID>(), new ArrayList<UUID>(), new HashSet<Chunk>(), System.currentTimeMillis(), new HashMap<UUID, Long>(), ChatColor.WHITE);
                newGroup.getLastActive().put(player.getUniqueId(), System.currentTimeMillis());
                this.groups.put(name, newGroup);
                this.playerGroups.put(player.getUniqueId(), newGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group " + name + " created.");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has created the group: " + name));
                this.saveGroups();
                break;
            }
            case "rename": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g rename <newname>");
                    return true;
                }
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Only the leader can rename the group.");
                    return true;
                }
                String newName = args[1];
                if (this.groups.containsKey(newName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "A group with that name already exists.");
                    return true;
                }
                if (!this.isValidGroupName(newName, player)) {
                    return true;
                }
                String oldName = playerGroup.getName();
                this.groups.remove(oldName);
                playerGroup.setName(newName);
                this.groups.put(newName, playerGroup);
                this.pendingInvites.replaceAll((uuid, groupName) -> groupName.equals(oldName) ? newName : groupName);
                this.pendingAllianceRequests.replaceAll((target, requesters) -> {
                    HashSet<String> updated = new HashSet<String>((Collection<String>)requesters);
                    if (updated.contains(oldName)) {
                        updated.remove(oldName);
                        updated.add(newName);
                    }
                    return updated;
                });
                Set<String> pendingForGroup = this.pendingAllianceRequests.remove(oldName);
                if (pendingForGroup != null) {
                    this.pendingAllianceRequests.put(newName, pendingForGroup);
                }
                for (Group ally : playerGroup.getAllies()) {
                    ally.getAllies().remove(playerGroup);
                    ally.getAllies().add(playerGroup);
                }
                this.groupsConfig.set(oldName, null);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group renamed to " + newName + ".");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has renamed their group from " + oldName + " to " + newName));
                this.saveGroups();
                break;
            }
            case "invite": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g invite <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to invite.");
                    return true;
                }
                Player target2 = Bukkit.getPlayer((String)args[1]);
                if (target2 == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (this.playerGroups.containsKey(target2.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is already in a group.");
                    return true;
                }
                this.pendingInvites.put(target2.getUniqueId(), playerGroup.getName());
                target2.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been invited to " + playerGroup.getName() + ". Use /g accept " + playerGroup.getName());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Invited " + target2.getName());
                this.saveGroups();
                break;
            }
            case "uninvite": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g uninvite <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to uninvite.");
                    return true;
                }
                Player uninviteTarget = Bukkit.getPlayer((String)args[1]);
                if (uninviteTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                String pendingGroup = this.pendingInvites.get(uninviteTarget.getUniqueId());
                if (pendingGroup == null || !pendingGroup.equals(playerGroup.getName())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending invite for that player.");
                    return true;
                }
                this.pendingInvites.remove(uninviteTarget.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Revoked invite for " + uninviteTarget.getName() + ".");
                uninviteTarget.sendMessage(String.valueOf(ChatColor.RED) + "Your invite to " + playerGroup.getName() + " has been revoked.");
                this.saveGroups();
                break;
            }
            case "accept": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g accept <group>");
                    return true;
                }
                String inviteGroup = args[1];
                if (!this.pendingInvites.getOrDefault(player.getUniqueId(), "").equals(inviteGroup)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending invite for that group.");
                    return true;
                }
                Group groupToJoin = this.groups.get(inviteGroup);
                if (groupToJoin == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                groupToJoin.getMembers().add(player.getUniqueId());
                groupToJoin.getLastActive().put(player.getUniqueId(), System.currentTimeMillis());
                this.playerGroups.put(player.getUniqueId(), groupToJoin);
                this.pendingInvites.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Joined " + inviteGroup);
                this.saveGroups();
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g kick <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to kick.");
                    return true;
                }
                Player kickTarget = Bukkit.getPlayer((String)args[1]);
                if (kickTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(kickTarget.getUniqueId()) && !playerGroup.getModerators().contains(kickTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not in your group.");
                    return true;
                }
                if (kickTarget.getUniqueId().equals(playerGroup.getLeader())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot kick the group leader.");
                    return true;
                }
                playerGroup.getMembers().remove(kickTarget.getUniqueId());
                playerGroup.getModerators().remove(kickTarget.getUniqueId());
                playerGroup.getLastActive().remove(kickTarget.getUniqueId());
                this.playerGroups.remove(kickTarget.getUniqueId());
                this.removePlayerFromLocks(playerGroup, kickTarget.getUniqueId());
                for (Group ally : playerGroup.getAllies()) {
                    this.removePlayerFromLocks(ally, kickTarget.getUniqueId());
                }
                kickTarget.sendMessage(String.valueOf(ChatColor.RED) + "You have been kicked from " + playerGroup.getName());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Kicked " + kickTarget.getName());
                this.saveGroups();
                break;
            }
            case "promote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g promote <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to promote.");
                    return true;
                }
                Player promoteTarget = Bukkit.getPlayer((String)args[1]);
                if (promoteTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(promoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not a member of your group.");
                    return true;
                }
                if (playerGroup.getModerators().contains(promoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is already a moderator.");
                    return true;
                }
                playerGroup.getMembers().remove(promoteTarget.getUniqueId());
                playerGroup.getModerators().add(promoteTarget.getUniqueId());
                this.updatePlayerLocks(playerGroup, promoteTarget.getUniqueId(), Role.MODERATOR);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + promoteTarget.getName() + " has been promoted to moderator.");
                promoteTarget.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been promoted to moderator in " + playerGroup.getName() + ".");
                this.saveGroups();
                break;
            }
            case "demote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g demote <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to demote.");
                    return true;
                }
                Player demoteTarget = Bukkit.getPlayer((String)args[1]);
                if (demoteTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getModerators().contains(demoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not a moderator in your group.");
                    return true;
                }
                playerGroup.getModerators().remove(demoteTarget.getUniqueId());
                playerGroup.getMembers().add(demoteTarget.getUniqueId());
                this.updatePlayerLocks(playerGroup, demoteTarget.getUniqueId(), Role.MEMBER);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + demoteTarget.getName() + " has been demoted to member.");
                demoteTarget.sendMessage(String.valueOf(ChatColor.RED) + "You have been demoted to member in " + playerGroup.getName() + ".");
                this.saveGroups();
                break;
            }
            case "transfer": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g transfer <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to transfer leadership.");
                    return true;
                }
                Player newLeader = Bukkit.getPlayer((String)args[1]);
                if (newLeader == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(newLeader.getUniqueId()) && !playerGroup.getModerators().contains(newLeader.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not in your group.");
                    return true;
                }
                playerGroup.setLeader(newLeader.getUniqueId());
                playerGroup.getMembers().remove(newLeader.getUniqueId());
                playerGroup.getModerators().remove(newLeader.getUniqueId());
                playerGroup.getMembers().add(player.getUniqueId());
                this.updatePlayerLocks(playerGroup, player.getUniqueId(), Role.MEMBER);
                this.updatePlayerLocks(playerGroup, newLeader.getUniqueId(), Role.LEADER);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Leadership transferred to " + newLeader.getName() + ".");
                newLeader.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now the leader of " + playerGroup.getName() + ".");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has transferred leadership of " + playerGroup.getName() + " to " + newLeader.getName() + "."));
                this.saveGroups();
                break;
            }
            case "leave": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Leaders cannot leave. Use /g delete or /g transfer instead.");
                    return true;
                }
                playerGroup.getMembers().remove(player.getUniqueId());
                playerGroup.getModerators().remove(player.getUniqueId());
                playerGroup.getLastActive().remove(player.getUniqueId());
                this.playerGroups.remove(player.getUniqueId());
                this.removePlayerFromLocks(playerGroup, player.getUniqueId());
                for (Group ally : playerGroup.getAllies()) {
                    this.removePlayerFromLocks(ally, player.getUniqueId());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have left the group.");
                this.saveGroups();
                break;
            }
            case "delete": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Only the leader can delete the group.");
                    return true;
                }
                for (Chunk c : playerGroup.getClaims()) {
                    this.claimedChunks.remove(c);
                    this.updateScoreboardsForChunk(c);
                }
                for (Group ally : new HashSet<Group>(playerGroup.getAllies())) {
                    ally.getAllies().remove(playerGroup);
                    this.removeAllyMembersFromLocks(ally, playerGroup);
                }
                this.pendingInvites.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(playerGroup.getName()));
                this.pendingAllianceRequests.remove(playerGroup.getName());
                this.pendingAllianceRequests.values().forEach(set -> set.remove(playerGroup.getName()));
                for (UUID member : playerGroup.getMembers()) {
                    this.playerGroups.remove(member);
                }
                for (UUID moderator : playerGroup.getModerators()) {
                    this.playerGroups.remove(moderator);
                }
                this.playerGroups.remove(playerGroup.getLeader());
                String groupName2 = playerGroup.getName();
                this.groups.remove(groupName2);
                this.groupsConfig.set(groupName2, null);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group deleted.");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has destroyed their group: " + groupName2));
                this.saveGroups();
                break;
            }
            case "allyrequest": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g allyrequest <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to request alliance.");
                    return true;
                }
                String targetName = args[1];
                if (!this.groups.containsKey(targetName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                Group targetGroup = this.groups.get(targetName);
                if (targetGroup == playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot ally your own group.");
                    return true;
                }
                if (playerGroup.getAllies().contains(targetGroup)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Already allied with " + targetName + ".");
                    return true;
                }
                this.pendingAllianceRequests.computeIfAbsent(targetName, k -> new HashSet()).add(playerGroup.getName());
                Player targetLeader = Bukkit.getPlayer((UUID)targetGroup.getLeader());
                if (targetLeader != null) {
                    targetLeader.sendMessage(String.valueOf(ChatColor.GREEN) + playerGroup.getName() + " has requested an alliance. Use /g acceptally " + playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance request sent to " + targetName + ".");
                this.saveGroups();
                break;
            }
            case "acceptally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g acceptally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to accept alliance.");
                    return true;
                }
                String requesterName = args[1];
                Set<String> pendings = this.pendingAllianceRequests.get(playerGroup.getName());
                if (pendings == null || !pendings.contains(requesterName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending alliance request from " + requesterName + ".");
                    return true;
                }
                Group requesterGroup = this.groups.get(requesterName);
                if (requesterGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                playerGroup.getAllies().add(requesterGroup);
                requesterGroup.getAllies().add(playerGroup);
                pendings.remove(requesterName);
                if (pendings.isEmpty()) {
                    this.pendingAllianceRequests.remove(playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance accepted with " + requesterName + ".");
                Player requesterLeader = Bukkit.getPlayer((UUID)requesterGroup.getLeader());
                if (requesterLeader != null) {
                    requesterLeader.sendMessage(String.valueOf(ChatColor.GREEN) + playerGroup.getName() + " has accepted your alliance request.");
                }
                this.saveGroups();
                break;
            }
            case "denyally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g denyally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to deny alliance.");
                    return true;
                }
                String denierName = args[1];
                Set<String> denyPendings = this.pendingAllianceRequests.get(playerGroup.getName());
                if (denyPendings == null || !denyPendings.contains(denierName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending alliance request from " + denierName + ".");
                    return true;
                }
                denyPendings.remove(denierName);
                if (denyPendings.isEmpty()) {
                    this.pendingAllianceRequests.remove(playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance request from " + denierName + " denied.");
                this.saveGroups();
                break;
            }
            case "unally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g unally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to unally.");
                    return true;
                }
                String unallyName = args[1];
                if (!this.groups.containsKey(unallyName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                Group targetUnally = this.groups.get(unallyName);
                if (!playerGroup.getAllies().contains(targetUnally)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Not allied with " + unallyName + ".");
                    return true;
                }
                playerGroup.getAllies().remove(targetUnally);
                targetUnally.getAllies().remove(playerGroup);
                this.removeAllyMembersFromLocks(playerGroup, targetUnally);
                this.removeAllyMembersFromLocks(targetUnally, playerGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed alliance with " + unallyName + ".");
                Player otherLeader = Bukkit.getPlayer((UUID)targetUnally.getLeader());
                if (otherLeader != null) {
                    otherLeader.sendMessage(String.valueOf(ChatColor.RED) + playerGroup.getName() + " has ended the alliance.");
                }
                this.saveGroups();
                break;
            }
            case "claim": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be in a group to claim.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to claim.");
                    return true;
                }
                if (this.hasActivePvpTimer(player)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot claim chunks while in combat.");
                    return true;
                }
                Chunk chunk = player.getLocation().getChunk();
                if (this.claimedChunks.containsKey(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Chunk already claimed.");
                    return true;
                }
                if (this.isSpawnSafeZone(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot claim in spawn safe zone.");
                    return true;
                }
                if (this.isNeutralZone(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot claim in neutral zone.");
                    return true;
                }
                if (playerGroup.getClaims().size() >= playerGroup.getMaxClaims()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your group has reached the claim limit.");
                    return true;
                }
                playerGroup.getClaims().add(chunk);
                this.claimedChunks.put(chunk, playerGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk claimed.");
                this.updateScoreboardsForChunk(chunk);
                this.saveGroups();
                break;
            }
            case "unclaim": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be in a group to unclaim.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to unclaim.");
                    return true;
                }
                Chunk unclaimChunk = player.getLocation().getChunk();
                if (!this.claimedChunks.containsKey(unclaimChunk) || this.claimedChunks.get(unclaimChunk) != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This is not your group's chunk.");
                    return true;
                }
                playerGroup.getClaims().remove(unclaimChunk);
                this.claimedChunks.remove(unclaimChunk);
                playerGroup.getLocks().entrySet().removeIf(entry -> ((Location)entry.getKey()).getChunk().equals((Object)unclaimChunk));
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk unclaimed.");
                this.updateScoreboardsForChunk(unclaimChunk);
                this.saveGroups();
                break;
            }
            case "map": {
                boolean isToggled = this.mapToggled.getOrDefault(player.getUniqueId(), true);
                this.mapToggled.put(player.getUniqueId(), !isToggled);
                if (!isToggled) {
                    this.updateScoreboard(player, player.getLocation().getChunk());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Map enabled.");
                    break;
                }
                player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                player.sendMessage(String.valueOf(ChatColor.RED) + "Map disabled.");
                break;
            }
            case "setcolor": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g setcolor <color>");
                    return true;
                }
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Only the leader can set the group color.");
                    return true;
                }
                String colorName = args[1].toUpperCase();
                try {
                    ChatColor color = ChatColor.valueOf((String)colorName);
                    if (!ALLOWED_COLORS.contains(color)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Use one of: " + ALLOWED_COLORS_STRING);
                        return true;
                    }
                    playerGroup.setGroupColor(color);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group color set to " + colorName + ".");
                    this.saveGroups();
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Use one of: " + ALLOWED_COLORS_STRING);
                }
                break;
            }
            case "setsafezone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to set safe zones.");
                    return true;
                }
                Chunk safeChunk = player.getLocation().getChunk();
                this.spawnSafeZones.add(safeChunk);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk set as spawn safe zone.");
                this.updateScoreboardsForChunk(safeChunk);
                this.saveGroups();
                break;
            }
            case "removesafezone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to remove safe zones.");
                    return true;
                }
                Chunk removeSafeChunk = player.getLocation().getChunk();
                if (this.spawnSafeZones.remove(removeSafeChunk)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk removed from spawn safe zone.");
                    this.updateScoreboardsForChunk(removeSafeChunk);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This chunk is not a spawn safe zone.");
                }
                this.saveGroups();
                break;
            }
            case "setneutralzone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to set neutral zones.");
                    return true;
                }
                Chunk neutralChunk = player.getLocation().getChunk();
                this.neutralZones.add(neutralChunk);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk set as neutral zone.");
                this.updateScoreboardsForChunk(neutralChunk);
                this.saveGroups();
                break;
            }
            case "removeneutralzone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to remove neutral zones.");
                    return true;
                }
                Chunk removeNeutralChunk = player.getLocation().getChunk();
                if (this.neutralZones.remove(removeNeutralChunk)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk removed from neutral zone.");
                    this.updateScoreboardsForChunk(removeNeutralChunk);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This chunk is not a neutral zone.");
                }
                this.saveGroups();
                break;
            }
            case "info": {
                Group infoGroup = null;
                if (args.length >= 2) {
                    String groupNameArg = args[1];
                    infoGroup = this.groups.get(groupNameArg);
                    if (infoGroup == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                        return true;
                    }
                } else {
                    if (playerGroup == null) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                        return true;
                    }
                    infoGroup = playerGroup;
                }
                this.displayGroupInfo(player, infoGroup);
                break;
            }
            case "reload": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload the config.");
                    return true;
                }
                this.reloadConfig();
                this.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded.");
                break;
            }
            case "setgroupcolor": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to set group colors.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g setgroupcolor <group> <color>");
                    return true;
                }
                String groupNameForColor = args[1];
                String adminColorName = args[2].toUpperCase();
                Group targetGroupForColor = this.groups.get(groupNameForColor);
                if (targetGroupForColor == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                try {
                    ChatColor color = ChatColor.valueOf((String)adminColorName);
                    if (!ALLOWED_COLORS.contains(color)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Use one of: " + ALLOWED_COLORS_STRING);
                        return true;
                    }
                    targetGroupForColor.setGroupColor(color);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group " + groupNameForColor + "'s color set to " + adminColorName + ".");
                    this.saveGroups();
                }
                catch (IllegalArgumentException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid color. Use one of: " + ALLOWED_COLORS_STRING);
                }
                break;
            }
            case "lock": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                Block lockTarget = player.getTargetBlockExact(5);
                if (lockTarget == null || !this.isProtectedBlock(lockTarget.getType())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a lockable block (container, door, etc.).");
                    return true;
                }
                Chunk lockChunk = lockTarget.getChunk();
                Group lockOwningGroup = this.claimedChunks.get(lockChunk);
                if (lockOwningGroup != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only lock on your group's claims.");
                    return true;
                }
                Set<Location> toLock = this.getCompanionLocations(lockTarget);
                for (Location location : toLock) {
                    if (!playerGroup.getLocks().containsKey(location)) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This block is already locked.");
                    return true;
                }
                int locksInChunk = 0;
                for (Location l : playerGroup.getLocks().keySet()) {
                    if (!l.getChunk().equals((Object)lockChunk)) continue;
                    ++locksInChunk;
                }
                if (locksInChunk + toLock.size() - 1 > this.maxLocksPerChunk) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your group has reached the maximum locks in this chunk (" + this.maxLocksPerChunk + ").");
                    return true;
                }
                Role role = this.getPlayerRole(player.getUniqueId(), playerGroup);
                Lock newLock = new Lock(player.getUniqueId(), role);
                for (Location l : toLock) {
                    playerGroup.getLocks().put(l, newLock);
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Block locked.");
                this.saveGroups();
                break;
            }
            case "unlock": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                Block unlockTarget = player.getTargetBlockExact(5);
                if (unlockTarget == null || !this.isProtectedBlock(unlockTarget.getType())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a lockable block (container, door, etc.).");
                    return true;
                }
                Chunk unlockChunk = unlockTarget.getChunk();
                Group unlockOwningGroup = this.claimedChunks.get(unlockChunk);
                if (unlockOwningGroup != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only unlock on your group's claims.");
                    return true;
                }
                Set<Location> toUnlock = this.getCompanionLocations(unlockTarget);
                Lock unlockLock = null;
                for (Location l : toUnlock) {
                    Lock tempLock = playerGroup.getLocks().get(l);
                    if (tempLock == null) continue;
                    if (unlockLock == null) {
                        unlockLock = tempLock;
                        continue;
                    }
                    if (this.isSameLock(unlockLock, tempLock)) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Inconsistent locks on companion blocks.");
                    return true;
                }
                if (unlockLock == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This block is not locked.");
                    return true;
                }
                if (this.canBreakOrUnlockLock(player.getUniqueId(), unlockLock, playerGroup, playerGroup)) {
                    for (Location l : toUnlock) {
                        playerGroup.getLocks().remove(l);
                    }
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Block unlocked.");
                    this.saveGroups();
                    break;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to unlock this (seniority required).");
                break;
            }
            case "lockinfo": {
                Block infoTarget = player.getTargetBlockExact(5);
                if (infoTarget == null || !this.isProtectedBlock(infoTarget.getType())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a lockable block (container, door, etc.).");
                    return true;
                }
                Chunk infoChunk = infoTarget.getChunk();
                Group infoOwningGroup = this.claimedChunks.get(infoChunk);
                if (infoOwningGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This chunk is not claimed by any group.");
                    return true;
                }
                Location infoLoc = infoTarget.getLocation();
                Lock infoLock = infoOwningGroup.getLocks().get(infoLoc);
                if (infoLock == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This block is not locked.");
                    return true;
                }
                OfflinePlayer ownerPlayer = Bukkit.getOfflinePlayer((UUID)infoLock.owner);
                String ownerName = ownerPlayer.getName() != null ? ownerPlayer.getName() : "Unknown";
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Lock Owner: " + (switch (infoLock.role.ordinal()) {
                    case 2 -> this.formatRoleInfo("L", ChatColor.YELLOW);
                    case 1 -> this.formatRoleInfo("M", ChatColor.BLUE);
                    default -> this.formatRoleInfo("G", ChatColor.WHITE);
                }) + ownerName);
                StringBuilder allowedStr = new StringBuilder(String.valueOf(ChatColor.YELLOW) + "Allowed: " + String.valueOf(ChatColor.WHITE));
                if (infoLock.allowed.isEmpty()) {
                    allowedStr.append("None");
                } else {
                    boolean first = true;
                    for (UUID allowedUUID : infoLock.allowed) {
                        OfflinePlayer allowedPlayer;
                        if (!first) {
                            allowedStr.append(", ");
                        }
                        String allowedName = (allowedPlayer = Bukkit.getOfflinePlayer((UUID)allowedUUID)).getName() != null ? allowedPlayer.getName() : "Unknown";
                        allowedStr.append(allowedName);
                        first = false;
                    }
                }
                player.sendMessage(allowedStr.toString());
                break;
            }
            case "lockadd": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g lockadd <player>");
                    return true;
                }
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                Block addTarget = player.getTargetBlockExact(5);
                if (addTarget == null || !this.isProtectedBlock(addTarget.getType())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a lockable block (container, door, etc.).");
                    return true;
                }
                Chunk addChunk = addTarget.getChunk();
                Group addOwningGroup = this.claimedChunks.get(addChunk);
                if (addOwningGroup != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only manage locks on your group's claims.");
                    return true;
                }
                Set<Location> addLocations = this.getCompanionLocations(addTarget);
                OfflinePlayer[] addLock = null;
                for (Location loc : addLocations) {
                    OfflinePlayer[] tempLock = playerGroup.getLocks().get(loc);
                    if (tempLock == null) continue;
                    if (addLock == null) {
                        addLock = tempLock;
                        continue;
                    }
                    if (this.isSameLock((Lock)addLock, (Lock)tempLock)) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Inconsistent locks on companion blocks. Please unlock and relock the block.");
                    return true;
                }
                if (addLock == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This block is not locked.");
                    return true;
                }
                if (!addLock.owner.equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the owner to add players to this lock.");
                    return true;
                }
                UUID targetUUID = null;
                String targetName = args[1];
                Player onlinePlayer = Bukkit.getPlayer((String)targetName);
                if (onlinePlayer != null) {
                    targetUUID = onlinePlayer.getUniqueId();
                } else {
                    for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                        if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(targetName)) continue;
                        targetUUID = offlinePlayer.getUniqueId();
                        break;
                    }
                }
                if (targetUUID == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (targetUUID.equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot add yourself to your own lock.");
                    return true;
                }
                boolean isAllowed = false;
                Group targetPlayerGroup = this.playerGroups.get(targetUUID);
                if (targetPlayerGroup != null) {
                    if (targetPlayerGroup == playerGroup) {
                        isAllowed = true;
                    } else if (playerGroup.getAllies().contains(targetPlayerGroup)) {
                        isAllowed = true;
                    }
                }
                if (!isAllowed) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only add players from your group or allied groups.");
                    return true;
                }
                if (addLock.allowed.contains(targetUUID)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is already added to this lock.");
                    return true;
                }
                addLock.allowed.add(targetUUID);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + targetName + " added to the lock.");
                this.saveGroups();
                break;
            }
            case "lockremove": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g lockremove <player>");
                    return true;
                }
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                Block removeTarget = player.getTargetBlockExact(5);
                if (removeTarget == null || !this.isProtectedBlock(removeTarget.getType())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be looking at a lockable block (container, door, etc.).");
                    return true;
                }
                Chunk removeChunk = removeTarget.getChunk();
                Group removeOwningGroup = this.claimedChunks.get(removeChunk);
                if (removeOwningGroup != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You can only manage locks on your group's claims.");
                    return true;
                }
                Set<Location> removeLocations = this.getCompanionLocations(removeTarget);
                Lock removeLock = null;
                for (Location loc : removeLocations) {
                    Lock tempLock = playerGroup.getLocks().get(loc);
                    if (tempLock == null) continue;
                    if (removeLock == null) {
                        removeLock = tempLock;
                        continue;
                    }
                    if (this.isSameLock(removeLock, tempLock)) continue;
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Inconsistent locks on companion blocks. Please unlock and relock the block.");
                    return true;
                }
                if (removeLock == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This block is not locked.");
                    return true;
                }
                if (!removeLock.owner.equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the owner to remove players from this lock.");
                    return true;
                }
                UUID removeUUID = null;
                String removeName = args[1];
                Player onlineRemovePlayer = Bukkit.getPlayer((String)removeName);
                if (onlineRemovePlayer != null) {
                    removeUUID = onlineRemovePlayer.getUniqueId();
                } else {
                    for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                        if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(removeName)) continue;
                        removeUUID = offlinePlayer.getUniqueId();
                        break;
                    }
                }
                if (removeUUID == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!removeLock.allowed.contains(removeUUID)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not added to this lock.");
                    return true;
                }
                removeLock.allowed.remove(removeUUID);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + removeName + " removed from the lock.");
                this.saveGroups();
            }
        }
        return true;
    }

    private Set<Location> getCompanionLocations(Block block) {
        Chest chest;
        BlockState state;
        HashSet<Location> locations = new HashSet<Location>();
        locations.add(block.getLocation());
        Material type = block.getType();
        if (Tag.DOORS.isTagged((Keyed)type)) {
            BlockData bd = block.getBlockData();
            if (bd instanceof Door) {
                Door door = (Door)bd;
                int dy = door.getHalf() == Bisected.Half.TOP ? -1 : 1;
                Location otherLoc = block.getLocation().add(0.0, (double)dy, 0.0);
                Block otherBlock = otherLoc.getBlock();
                if (Tag.DOORS.isTagged((Keyed)otherBlock.getType())) {
                    locations.add(otherLoc);
                }
            }
        } else if ((type == Material.CHEST || type == Material.TRAPPED_CHEST) && (state = block.getState()) instanceof Chest && (chest = (Chest)state).getInventory().getHolder() instanceof DoubleChest) {
            DoubleChest doubleChest = (DoubleChest)chest.getInventory().getHolder();
            Location left = ((Chest)doubleChest.getLeftSide()).getLocation();
            Location right = ((Chest)doubleChest.getRightSide()).getLocation();
            locations.add(left);
            locations.add(right);
        }
        return locations;
    }

    private Role getPlayerRole(UUID uuid, Group group) {
        if (group.getLeader().equals(uuid)) {
            return Role.LEADER;
        }
        if (group.getModerators().contains(uuid)) {
            return Role.MODERATOR;
        }
        return Role.MEMBER;
    }

    private boolean canAccessLock(UUID playerUUID, Lock lock, Group owningGroup, Group playerGroup) {
        boolean sameGroup = playerGroup == owningGroup;
        boolean isAllowed = lock.allowed.contains(playerUUID);
        boolean isOwner = lock.owner.equals(playerUUID);
        Role playerRole = this.getPlayerRole(playerUUID, owningGroup);
        boolean hasSeniority = playerRole.ordinal() > lock.role.ordinal();
        return sameGroup && (isOwner || hasSeniority) || isAllowed;
    }

    private boolean canBreakOrUnlockLock(UUID playerUUID, Lock lock, Group owningGroup, Group playerGroup) {
        if (playerGroup != owningGroup) {
            return false;
        }
        boolean isOwner = lock.owner.equals(playerUUID);
        Role playerRole = this.getPlayerRole(playerUUID, owningGroup);
        boolean hasSeniority = playerRole.ordinal() > lock.role.ordinal();
        return isOwner || hasSeniority;
    }

    private void displayGroupInfo(Player player, Group group) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withZone(ZoneId.systemDefault());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Name: " + String.valueOf(group.getGroupColor()) + group.getName());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Claims: " + String.valueOf(ChatColor.WHITE) + group.getClaims().size() + " / " + group.getMaxClaims());
        StringBuilder membersList = new StringBuilder(String.valueOf(ChatColor.YELLOW) + "Group Members: ");
        OfflinePlayer leader = Bukkit.getOfflinePlayer((UUID)group.getLeader());
        membersList.append(this.formatRoleInfo("L", ChatColor.YELLOW)).append(leader.getName() != null ? leader.getName() : "Unknown");
        for (UUID moderatorId : group.getModerators()) {
            OfflinePlayer moderator = Bukkit.getOfflinePlayer((UUID)moderatorId);
            membersList.append(ChatColor.GRAY).append(", ").append(this.formatRoleInfo("M", ChatColor.BLUE)).append(moderator.getName() != null ? moderator.getName() : "Unknown");
        }
        for (UUID memberId : group.getMembers()) {
            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
            membersList.append(ChatColor.GRAY).append(", ").append(this.formatRoleInfo("G", ChatColor.WHITE)).append(member.getName() != null ? member.getName() : "Unknown");
        }
        player.sendMessage(membersList.toString());
        String allies = group.getAllies().stream().map(ally -> String.valueOf(ally.getGroupColor()) + ally.getName() + String.valueOf(ChatColor.WHITE)).collect(Collectors.joining(String.valueOf(ChatColor.GRAY) + ", " + String.valueOf(ChatColor.WHITE)));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Allies: " + (String)(allies.isEmpty() ? String.valueOf(ChatColor.WHITE) + "None" : allies));
        String creationDate = formatter.format(Instant.ofEpochMilli(group.getCreationTime()));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Created: " + String.valueOf(ChatColor.WHITE) + creationDate);
        long weekMillis = 604800000L;
        long weeks = (System.currentTimeMillis() - group.getCreationTime()) / weekMillis;
        long nextGrowthMillis = group.getCreationTime() + (weeks + 1L) * weekMillis;
        String nextGrowth = formatter.format(Instant.ofEpochMilli(nextGrowthMillis));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Next Claim Growth: " + String.valueOf(ChatColor.WHITE) + nextGrowth);
    }

    private String formatRoleInfo(String role, ChatColor letterColor) {
        return String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(letterColor) + role + String.valueOf(ChatColor.WHITE) + "] ";
    }

    private void sendHelp(Player player) {
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g create <name>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g rename <newname>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g invite <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g uninvite <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g accept <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g kick <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g promote <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g demote <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g transfer <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g leave");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g delete");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g allyrequest <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g acceptally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g denyally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g unally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g claim");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g unclaim");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g map - Toggle the claim map");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g info [group] - Show group information");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g lock - Lock a container/door while looking at it");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g unlock - Unlock a locked block while looking at it");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g lockinfo - View lock info while looking at it");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g lockadd <player> - Add player to lock (same/allied group)");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g lockremove <player> - Remove player from lock");
        if (playerGroup != null && playerGroup.getLeader().equals(player.getUniqueId())) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setcolor <color> - Set your group's color in chat");
        }
        if (player.hasPermission("SimpleGroupsAndClaims.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setsafezone - Set chunk as spawn safe zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g removesafezone - Remove chunk from spawn safe zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setneutralzone - Set chunk as neutral zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g removeneutralzone - Remove chunk from neutral zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setgroupcolor <group> <color> - Set group's chat color (Admin)");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g reload - Reload configuration");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block57: {
            block58: {
                block56: {
                    Player player;
                    Group playerGroup;
                    completions = new ArrayList<String>();
                    ArrayList<String> commands = new ArrayList<String>(Arrays.asList("create", "rename", "invite", "uninvite", "accept", "kick", "promote", "demote", "transfer", "leave", "delete", "allyrequest", "acceptally", "denyally", "unally", "claim", "unclaim", "map", "info", "lock", "unlock", "lockinfo", "lockadd", "lockremove"));
                    if (sender.hasPermission("SimpleGroupsAndClaims.admin")) {
                        commands.addAll(Arrays.asList("setsafezone", "removesafezone", "setneutralzone", "removeneutralzone", "setgroupcolor", "reload"));
                    }
                    if (sender instanceof Player && (playerGroup = this.playerGroups.get((player = (Player)sender).getUniqueId())) != null && playerGroup.getLeader().equals(player.getUniqueId())) {
                        commands.add("setcolor");
                    }
                    if (args.length != 1) break block56;
                    StringUtil.copyPartialMatches((String)args[0], commands, completions);
                    break block57;
                }
                if (args.length != 2) break block58;
                Group group = null;
                if (sender instanceof Player) {
                    group = this.playerGroups.get(((Player)sender).getUniqueId());
                }
                switch (args[0].toLowerCase()) {
                    case "invite": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId()) && !group.getModerators().contains(((Player)sender).getUniqueId())) break;
                        List players = Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !this.playerGroups.containsKey(Bukkit.getPlayer((String)name).getUniqueId())).collect(Collectors.toList());
                        StringUtil.copyPartialMatches((String)args[1], players, completions);
                        break;
                    }
                    case "kick": 
                    case "promote": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId())) break;
                        List players = group.getMembers().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList());
                        if (args[0].equalsIgnoreCase("kick")) {
                            players.addAll(group.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                        }
                        StringUtil.copyPartialMatches((String)args[1], players, completions);
                        break;
                    }
                    case "uninvite": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId()) && !group.getModerators().contains(((Player)sender).getUniqueId())) break;
                        ArrayList<String> invitedPlayers = new ArrayList<String>();
                        for (Map.Entry<UUID, String> entry : this.pendingInvites.entrySet()) {
                            Player p;
                            if (!entry.getValue().equals(group.getName()) || (p = Bukkit.getPlayer((UUID)entry.getKey())) == null) continue;
                            invitedPlayers.add(p.getName());
                        }
                        StringUtil.copyPartialMatches((String)args[1], invitedPlayers, completions);
                        break;
                    }
                    case "demote": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId())) break;
                        List players = group.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList());
                        StringUtil.copyPartialMatches((String)args[1], players, completions);
                        break;
                    }
                    case "transfer": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId())) break;
                        ArrayList players = new ArrayList();
                        players.addAll(group.getMembers().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                        players.addAll(group.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                        StringUtil.copyPartialMatches((String)args[1], players, completions);
                        break;
                    }
                    case "accept": {
                        if (!(sender instanceof Player)) break;
                        String pendingGroup = this.pendingInvites.get(((Player)sender).getUniqueId());
                        if (pendingGroup != null) {
                            StringUtil.copyPartialMatches((String)args[1], Collections.singletonList(pendingGroup), completions);
                            break;
                        }
                        break block57;
                    }
                    case "allyrequest": 
                    case "acceptally": 
                    case "denyally": 
                    case "unally": {
                        ArrayList<String> groupsList = new ArrayList<String>(this.groups.keySet());
                        if (group != null) {
                            groupsList.remove(group.getName());
                            if (args[0].equalsIgnoreCase("acceptally")) {
                                Set pendings = this.pendingAllianceRequests.getOrDefault(group.getName(), new HashSet());
                                groupsList.retainAll(pendings);
                            } else if (args[0].equalsIgnoreCase("unally")) {
                                groupsList.retainAll(group.getAllies().stream().map(Group::getName).collect(Collectors.toSet()));
                            }
                        }
                        StringUtil.copyPartialMatches((String)args[1], groupsList, completions);
                        break;
                    }
                    case "setcolor": {
                        if (group == null || !group.getLeader().equals(((Player)sender).getUniqueId())) break;
                        List colors = ALLOWED_COLORS.stream().map(Enum::name).collect(Collectors.toList());
                        StringUtil.copyPartialMatches((String)args[1], colors, completions);
                        break;
                    }
                    case "setgroupcolor": {
                        if (!sender.hasPermission("SimpleGroupsAndClaims.admin")) break;
                        StringUtil.copyPartialMatches((String)args[1], new ArrayList<String>(this.groups.keySet()), completions);
                        break;
                    }
                    case "info": {
                        StringUtil.copyPartialMatches((String)args[1], new ArrayList<String>(this.groups.keySet()), completions);
                        break;
                    }
                    case "lockadd": {
                        if (!(sender instanceof Player)) break;
                        Player currentPlayer = (Player)sender;
                        if (group != null) {
                            Object leader;
                            Group finalGroup = group;
                            UUID currentPlayerId = currentPlayer.getUniqueId();
                            HashSet<String> eligiblePlayers = new HashSet<String>();
                            for (UUID memberId : finalGroup.getMembers()) {
                                OfflinePlayer member;
                                if (memberId.equals(currentPlayerId) || (member = Bukkit.getOfflinePlayer((UUID)memberId)).getName() == null) continue;
                                eligiblePlayers.add(member.getName());
                            }
                            for (UUID moderatorId : finalGroup.getModerators()) {
                                Object moderator;
                                if (moderatorId.equals(currentPlayerId) || (moderator = Bukkit.getOfflinePlayer((UUID)moderatorId)).getName() == null) continue;
                                eligiblePlayers.add(moderator.getName());
                            }
                            if (!finalGroup.getLeader().equals(currentPlayerId) && (leader = Bukkit.getOfflinePlayer((UUID)finalGroup.getLeader())).getName() != null) {
                                eligiblePlayers.add(leader.getName());
                            }
                            for (Group ally : finalGroup.getAllies()) {
                                for (UUID memberId : ally.getMembers()) {
                                    OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
                                    if (member.getName() == null) continue;
                                    eligiblePlayers.add(member.getName());
                                }
                                for (UUID moderatorId : ally.getModerators()) {
                                    OfflinePlayer moderator = Bukkit.getOfflinePlayer((UUID)moderatorId);
                                    if (moderator.getName() == null) continue;
                                    eligiblePlayers.add(moderator.getName());
                                }
                                OfflinePlayer allyLeader = Bukkit.getOfflinePlayer((UUID)ally.getLeader());
                                if (allyLeader.getName() == null) continue;
                                eligiblePlayers.add(allyLeader.getName());
                            }
                            StringUtil.copyPartialMatches((String)args[1], new ArrayList(eligiblePlayers), completions);
                            break;
                        }
                        break block57;
                    }
                    case "lockremove": {
                        if (group == null) break;
                        Group finalGroup = group;
                        HashSet<String> eligiblePlayers = new HashSet<String>();
                        for (UUID memberId : finalGroup.getMembers()) {
                            OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
                            if (member.getName() == null) continue;
                            eligiblePlayers.add(member.getName());
                        }
                        for (UUID moderatorId : finalGroup.getModerators()) {
                            OfflinePlayer moderator = Bukkit.getOfflinePlayer((UUID)moderatorId);
                            if (moderator.getName() == null) continue;
                            eligiblePlayers.add(moderator.getName());
                        }
                        OfflinePlayer leader = Bukkit.getOfflinePlayer((UUID)finalGroup.getLeader());
                        if (leader.getName() != null) {
                            eligiblePlayers.add(leader.getName());
                        }
                        for (Group ally : finalGroup.getAllies()) {
                            for (UUID memberId : ally.getMembers()) {
                                OfflinePlayer member = Bukkit.getOfflinePlayer((UUID)memberId);
                                if (member.getName() == null) continue;
                                eligiblePlayers.add(member.getName());
                            }
                            for (UUID moderatorId : ally.getModerators()) {
                                OfflinePlayer moderator = Bukkit.getOfflinePlayer((UUID)moderatorId);
                                if (moderator.getName() == null) continue;
                                eligiblePlayers.add(moderator.getName());
                            }
                            OfflinePlayer allyLeader = Bukkit.getOfflinePlayer((UUID)ally.getLeader());
                            if (allyLeader.getName() == null) continue;
                            eligiblePlayers.add(allyLeader.getName());
                        }
                        StringUtil.copyPartialMatches((String)args[1], new ArrayList(eligiblePlayers), completions);
                    }
                }
                break block57;
            }
            if (args.length == 3 && "setgroupcolor".equalsIgnoreCase(args[0]) && sender.hasPermission("SimpleGroupsAndClaims.admin")) {
                List colors = ALLOWED_COLORS.stream().map(Enum::name).collect(Collectors.toList());
                StringUtil.copyPartialMatches((String)args[2], colors, completions);
            }
        }
        Collections.sort(completions);
        return completions;
    }

    private boolean canBuildInChunk(Player player, Chunk chunk) {
        if (this.isSpawnSafeZone(chunk) || this.isNeutralZone(chunk)) {
            return false;
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (owningGroup == null) {
            return true;
        }
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        if (playerGroup == null) {
            return false;
        }
        return playerGroup == owningGroup;
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        Chunk chunk = entity.getLocation().getChunk();
        if ((entity instanceof ItemFrame || entity instanceof ArmorStand) && !this.canBuildInChunk(player, chunk)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot interact with that in this territory!");
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Material blockType;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        Chunk chunk = block.getChunk();
        if (event.getItem() != null) {
            Block placedBlock;
            Material itemType = event.getItem().getType();
            if (itemType == Material.MINECART || itemType == Material.CHEST_MINECART || itemType == Material.FURNACE_MINECART || itemType == Material.HOPPER_MINECART || itemType == Material.TNT_MINECART) {
                placedBlock = block.getRelative(event.getBlockFace());
                if (!this.canBuildInChunk(player, placedBlock.getChunk())) {
                    event.setCancelled(true);
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place minecarts in this territory!");
                    return;
                }
            } else if (!(itemType != Material.ITEM_FRAME && itemType != Material.GLOW_ITEM_FRAME || this.canBuildInChunk(player, (placedBlock = block.getRelative(event.getBlockFace())).getChunk()))) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place that in this territory!");
                return;
            }
        }
        if (this.isProtectedBlock(blockType = block.getType())) {
            Group playerGroup = this.playerGroups.get(player.getUniqueId());
            Group owningGroup = this.claimedChunks.get(chunk);
            if (owningGroup == null) {
                return;
            }
            Location loc = block.getLocation();
            Lock lock = owningGroup.getLocks().get(loc);
            if (lock != null) {
                if (this.canAccessLock(player.getUniqueId(), lock, owningGroup, playerGroup)) {
                    OfflinePlayer lockOwner = Bukkit.getOfflinePlayer((UUID)lock.owner);
                    String ownerName = lockOwner.getName() != null ? lockOwner.getName() : "Unknown";
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Locked by: " + (switch (lock.role.ordinal()) {
                        case 2 -> "[L]";
                        case 1 -> "[M]";
                        default -> "[G]";
                    }) + " " + ownerName);
                    return;
                }
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "This is locked.");
                return;
            }
            if (playerGroup == owningGroup) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot interact with this in this territory!");
            return;
        }
    }

    private boolean isProtectedBlock(Material material) {
        return material == Material.ARMOR_STAND || material.name().endsWith("CHEST") || material.name().endsWith("SHULKER_BOX") || material == Material.CHEST_MINECART || material == Material.FURNACE_MINECART || material == Material.FURNACE || material == Material.BLAST_FURNACE || material == Material.SMOKER || material == Material.BARREL || material == Material.DISPENSER || material == Material.DROPPER || material == Material.HOPPER || material == Material.BREWING_STAND || material.name().endsWith("_BED") || material == Material.LEVER || material.name().endsWith("_BUTTON") || material == Material.REPEATER || material == Material.COMPARATOR || material.name().endsWith("_DOOR") || material.name().endsWith("_TRAPDOOR") || material.name().endsWith("_FENCE_GATE") || material == Material.ENCHANTING_TABLE || material == Material.BEACON || material == Material.NOTE_BLOCK || material == Material.JUKEBOX || material == Material.BELL || material == Material.RESPAWN_ANCHOR || material == Material.LODESTONE || material == Material.LECTERN || material == Material.ITEM_FRAME || material == Material.GLOW_ITEM_FRAME || material == Material.CAULDRON || material == Material.WATER_CAULDRON || material == Material.LAVA_CAULDRON || material == Material.POWDER_SNOW_CAULDRON || material == Material.COMPOSTER || material == Material.CRAFTER || material == Material.ANVIL || material == Material.CHIPPED_ANVIL || material == Material.DAMAGED_ANVIL || material == Material.BEEHIVE || material == Material.BEE_NEST || material == Material.DAYLIGHT_DETECTOR || material == Material.CHISELED_BOOKSHELF || Tag.SIGNS.isTagged((Keyed)material) || material.name().endsWith("_HANGING_SIGN") || material.name().endsWith("_WALL_HANGING_SIGN");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onArmorStandManipulate(PlayerArmorStandManipulateEvent event) {
        ArmorStand armorStand;
        Chunk chunk;
        Player player = event.getPlayer();
        if (!this.canBuildInChunk(player, chunk = (armorStand = event.getRightClicked()).getLocation().getChunk())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot modify armor stands in this territory!");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        Chunk doorChunk;
        Group owningGroup;
        Block doorBlock;
        Block block;
        Chunk chunk;
        Player player = event.getPlayer();
        if (!this.canBuildInChunk(player, chunk = (block = event.getBlock()).getChunk())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot break blocks in this territory.");
            return;
        }
        if (this.isProtectedBlock(block.getType())) {
            Group playerGroup = this.playerGroups.get(player.getUniqueId());
            Group owningGroup2 = this.claimedChunks.get(chunk);
            if (owningGroup2 == null) {
                return;
            }
            Location loc = block.getLocation();
            Lock lock = owningGroup2.getLocks().get(loc);
            if (lock != null && !this.canBreakOrUnlockLock(player.getUniqueId(), lock, owningGroup2, playerGroup)) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "This is locked.");
                return;
            }
            Set<Location> locationsToCheck = this.getCompanionLocations(block);
            for (Location location : locationsToCheck) {
                Lock locationLock = owningGroup2.getLocks().get(location);
                if (locationLock == null) continue;
                for (Location companionLocation : this.getCompanionLocations(location.getBlock())) {
                    owningGroup2.getLocks().remove(companionLocation);
                }
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Lock removed from broken block.");
                break;
            }
            this.saveGroups();
            if (owningGroup2 != null && playerGroup != owningGroup2) {
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot break protected blocks in allied territory.");
                return;
            }
        }
        if (!event.isCancelled() && this.isBlockSupportingDoor(block) && Tag.DOORS.isTagged((Keyed)(doorBlock = event.getBlock().getRelative(BlockFace.UP)).getType()) && (owningGroup = this.claimedChunks.get(doorChunk = doorBlock.getChunk())) != null) {
            Set<Location> doorLocations = this.getCompanionLocations(doorBlock);
            boolean removedLock = false;
            for (Location doorLoc : doorLocations) {
                if (owningGroup.getLocks().remove(doorLoc) == null) continue;
                removedLock = true;
            }
            if (removedLock) {
                this.saveGroups();
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Door lock removed due to support block break.");
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBucketFill(PlayerBucketFillEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        if (block == null) {
            return;
        }
        Chunk chunk = block.getChunk();
        if (!this.canBuildInChunk(player, chunk)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot take that in this territory!");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        if (block == null) {
            return;
        }
        Chunk chunk = block.getChunk();
        if (!this.canBuildInChunk(player, chunk)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place that in this territory!");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Chunk chunk;
        Player player = event.getPlayer();
        if (!this.canBuildInChunk(player, chunk = event.getBlock().getChunk())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place blocks in this territory.");
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Chunk toChunk = event.getToBlock().getChunk();
        if (this.isSpawnSafeZone(toChunk) || this.isNeutralZone(toChunk)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Chunk pistonChunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(pistonChunk) || this.isNeutralZone(pistonChunk)) {
            event.setCancelled(true);
            return;
        }
        Group pistonGroup = this.claimedChunks.get(pistonChunk);
        Vector direction = event.getDirection().getDirection();
        for (Block block : event.getBlocks()) {
            Chunk currentChunk = block.getChunk();
            if (this.isSpawnSafeZone(currentChunk) || this.isNeutralZone(currentChunk)) {
                event.setCancelled(true);
                return;
            }
            Group currentGroup = this.claimedChunks.get(currentChunk);
            if (currentGroup != null && currentGroup != pistonGroup) {
                event.setCancelled(true);
                return;
            }
            int newX = block.getX() + (int)direction.getX();
            int newZ = block.getZ() + (int)direction.getZ();
            Chunk destChunk = block.getWorld().getChunkAt(newX >> 4, newZ >> 4);
            if (this.isSpawnSafeZone(destChunk) || this.isNeutralZone(destChunk)) {
                event.setCancelled(true);
                return;
            }
            Group destGroup = this.claimedChunks.get(destChunk);
            if (destGroup == null || destGroup == pistonGroup) continue;
            event.setCancelled(true);
            return;
        }
        Block frontBlock = event.getBlock().getRelative(event.getDirection());
        Chunk frontChunk = frontBlock.getChunk();
        if (this.isSpawnSafeZone(frontChunk) || this.isNeutralZone(frontChunk)) {
            event.setCancelled(true);
            return;
        }
        Group frontGroup = this.claimedChunks.get(frontChunk);
        if (frontGroup != null && frontGroup != pistonGroup) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Chunk pistonChunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(pistonChunk) || this.isNeutralZone(pistonChunk)) {
            event.setCancelled(true);
            return;
        }
        Group pistonGroup = this.claimedChunks.get(pistonChunk);
        for (Block block : event.getBlocks()) {
            Chunk currentChunk = block.getChunk();
            if (this.isSpawnSafeZone(currentChunk) || this.isNeutralZone(currentChunk)) {
                event.setCancelled(true);
                return;
            }
            Group currentGroup = this.claimedChunks.get(currentChunk);
            if (currentGroup == null || currentGroup == pistonGroup) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        ArrayList exploded = new ArrayList(event.blockList());
        HashSet<Block> toProtect = new HashSet<Block>();
        for (Block block : exploded) {
            Lock lock;
            Group owningGroup;
            if (this.isSpawnSafeZone(block.getChunk()) || this.isNeutralZone(block.getChunk())) {
                event.setCancelled(true);
                return;
            }
            if (!this.isProtectedBlock(block.getType()) || (owningGroup = this.claimedChunks.get(block.getChunk())) == null || (lock = owningGroup.getLocks().get(block.getLocation())) == null) continue;
            boolean allowBreak = false;
            if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                Block below;
                Door door;
                Block lowerDoor = block;
                BlockData bd = block.getBlockData();
                if (bd instanceof Door && (door = (Door)bd).getHalf() == Bisected.Half.TOP) {
                    lowerDoor = block.getRelative(0, -1, 0);
                }
                if (exploded.contains(below = lowerDoor.getRelative(0, -1, 0))) {
                    allowBreak = true;
                }
            }
            if (allowBreak) continue;
            toProtect.add(block);
        }
        event.blockList().removeAll(toProtect);
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(chunk) || this.isNeutralZone(chunk)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntityEvent(EntityDamageByEntityEvent event) {
        Projectile projectile;
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        if (damagee instanceof ItemFrame) {
            Projectile projectile2;
            Player damagerPlayer = null;
            if (damager instanceof Player) {
                damagerPlayer = (Player)damager;
            } else if (damager instanceof Projectile && (projectile2 = (Projectile)damager).getShooter() instanceof Player) {
                damagerPlayer = (Player)projectile2.getShooter();
            }
            if (damagerPlayer == null) {
                return;
            }
            Chunk chunk = damagee.getLocation().getChunk();
            if (!this.canBuildInChunk(damagerPlayer, chunk)) {
                event.setCancelled(true);
                damagerPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You cannot break that in this territory!");
            }
            return;
        }
        if (!(damagee instanceof Player)) {
            return;
        }
        Player pDamagee = (Player)damagee;
        Player pDamager = null;
        if (damager instanceof Player) {
            pDamager = (Player)damager;
        } else if (damager instanceof Projectile && (projectile = (Projectile)damager).getShooter() instanceof Player) {
            pDamager = (Player)projectile.getShooter();
        }
        if (pDamager == null) {
            return;
        }
        Chunk chunk = pDamagee.getLocation().getChunk();
        Group groupDamager = this.playerGroups.get(pDamager.getUniqueId());
        Group groupDamagee = this.playerGroups.get(pDamagee.getUniqueId());
        double rawDamage = event.getDamage();
        double finalDamage = event.getFinalDamage();
        double damageeHealth = pDamagee.getHealth();
        double absorptionAmount = pDamagee.getAbsorptionAmount();
        int foodLevel = pDamagee.getFoodLevel();
        boolean hasPvpTimer = this.hasActivePvpTimer(pDamagee);
        if (this.isSpawnSafeZone(chunk) && !this.hasActivePvpTimer(pDamagee)) {
            event.setCancelled(true);
            pDamager.sendMessage(String.valueOf(ChatColor.RED) + "You cannot PvP in the spawn zone.");
            if (!event.isCancelled() && rawDamage > 0.0) {
                this.startPvpTimer(pDamager);
                this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
            }
            return;
        }
        if (groupDamager != null && groupDamagee != null && (groupDamager == groupDamagee || groupDamager.getAllies().contains(groupDamagee))) {
            event.setCancelled(true);
            pDamager.sendMessage(String.valueOf(ChatColor.RED) + "You cannot PvP group members or allies.");
            if (!event.isCancelled() && rawDamage > 0.0) {
                this.startPvpTimer(pDamager);
                this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
            }
            return;
        }
        if (!event.isCancelled() && rawDamage > 0.0) {
            this.startPvpTimer(pDamager);
            this.startPvpTimer(pDamagee);
            this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
        }
    }

    @EventHandler
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BukkitRunnable task;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Group group = this.playerGroups.get(playerId);
        if (group != null) {
            group.getLastActive().put(playerId, System.currentTimeMillis());
            this.saveGroups();
        }
        if (this.hasActivePvpTimer(player)) {
            UUID damagerId = this.lastDamager.get(playerId);
            Player damager = damagerId != null ? Bukkit.getPlayer((UUID)damagerId) : null;
            player.setHealth(0.0);
            String deathMessage = damager != null ? String.valueOf(ChatColor.RED) + player.getName() + " was killed by " + damager.getName() + " for logging out during combat." : String.valueOf(ChatColor.RED) + player.getName() + " was killed for logging out during combat.";
            Bukkit.broadcastMessage((String)deathMessage);
        }
        this.pvpTimers.remove(playerId);
        BossBar bar = this.pvpBossBars.remove(playerId);
        if (bar != null) {
            bar.removePlayer(player);
        }
        if ((task = this.pvpTimerTasks.remove(playerId)) != null) {
            task.cancel();
        }
        this.lastDamager.remove(playerId);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        BukkitRunnable task;
        Player player = event.getEntity();
        UUID playerId = player.getUniqueId();
        this.pvpTimers.remove(playerId);
        BossBar bar = this.pvpBossBars.remove(playerId);
        if (bar != null) {
            bar.removePlayer(player);
        }
        if ((task = this.pvpTimerTasks.remove(playerId)) != null) {
            task.cancel();
        }
        this.lastDamager.remove(playerId);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Group group = this.playerGroups.get(playerId);
        if (group != null) {
            group.getLastActive().put(playerId, System.currentTimeMillis());
            this.saveGroups();
        }
        if (this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            this.updateScoreboard(player, player.getLocation().getChunk());
            this.lastYaw.put(player.getUniqueId(), Float.valueOf(player.getLocation().getYaw()));
        }
        Chunk chunk = player.getLocation().getChunk();
        String zone = this.getZoneName(chunk, player);
        ChatColor color = this.getChunkColor(chunk, player);
        player.sendActionBar(String.valueOf(color) + zone);
        this.lastZone.put(player.getUniqueId(), zone);
    }

    private void startPvpTimer(final Player player) {
        if (!player.isOnline()) {
            return;
        }
        final UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.pvpTimers.put(playerId, currentTime + this.pvpTimerDuration);
        BukkitRunnable oldTask = this.pvpTimerTasks.remove(playerId);
        if (oldTask != null) {
            oldTask.cancel();
        }
        BossBar bar = this.pvpBossBars.get(playerId);
        int durationSeconds = (int)(this.pvpTimerDuration / 1000L);
        if (bar == null) {
            bar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + durationSeconds + "s"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bar.addPlayer(player);
            this.pvpBossBars.put(playerId, bar);
        } else {
            bar.setTitle(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + durationSeconds + "s");
            bar.setProgress(1.0);
        }
        BukkitRunnable newTask = new BukkitRunnable(this){
            private final long taskStartTime;
            final /* synthetic */ SimpleGroupsAndClaims this$0;
            {
                this.this$0 = this$0;
                this.taskStartTime = this.this$0.pvpTimers.get(playerId);
            }

            public void run() {
                Long timerEnd = this.this$0.pvpTimers.get(playerId);
                if (timerEnd == null || timerEnd != this.taskStartTime) {
                    this.cancel();
                    return;
                }
                if (System.currentTimeMillis() >= timerEnd) {
                    this.this$0.pvpTimers.remove(playerId);
                    this.this$0.pvpTimerTasks.remove(playerId);
                    BossBar bar = this.this$0.pvpBossBars.remove(playerId);
                    if (bar != null) {
                        bar.removePlayer(player);
                    }
                    if (player.isOnline()) {
                        player.sendActionBar(String.valueOf(ChatColor.GREEN) + "Your combat timer has expired. You can now safely log out.");
                    }
                    this.cancel();
                } else {
                    long remainingMillis = timerEnd - System.currentTimeMillis();
                    double progress = (double)remainingMillis / (double)this.this$0.pvpTimerDuration;
                    int remainingSeconds = (int)Math.ceil((double)remainingMillis / 1000.0);
                    BossBar bar = this.this$0.pvpBossBars.get(playerId);
                    if (bar != null) {
                        bar.setTitle(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + remainingSeconds + "s");
                        bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    }
                }
            }
        };
        this.pvpTimerTasks.put(playerId, newTask);
        newTask.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private boolean hasActivePvpTimer(Player player) {
        Long timerEnd = this.pvpTimers.get(player.getUniqueId());
        return timerEnd != null && System.currentTimeMillis() < timerEnd;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        event.setCancelled(true);
        final Player speaker = event.getPlayer();
        final String message = event.getMessage();
        final HashSet recipients = new HashSet(event.getRecipients());
        new BukkitRunnable(this){
            final /* synthetic */ SimpleGroupsAndClaims this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!speaker.isOnline()) {
                    return;
                }
                Group speakerGroup = this.this$0.playerGroups.get(speaker.getUniqueId());
                String speakerDisplayName = speaker.getDisplayName();
                String consoleMessage = this.formatMessage(speakerGroup, speaker, ChatColor.WHITE, speakerDisplayName, message);
                Bukkit.getConsoleSender().sendMessage(consoleMessage);
                for (Player recipient : recipients) {
                    if (!recipient.isOnline()) continue;
                    ChatColor bracketColor = this.determineBracketColor(recipient, speakerGroup);
                    String formatted = this.formatMessage(speakerGroup, speaker, bracketColor, speakerDisplayName, message);
                    recipient.sendMessage(formatted);
                }
            }

            private ChatColor determineBracketColor(Player recipient, Group speakerGroup) {
                if (speakerGroup == null) {
                    return ChatColor.WHITE;
                }
                Group recipientGroup = this.this$0.playerGroups.get(recipient.getUniqueId());
                if (recipientGroup == null) {
                    return ChatColor.WHITE;
                }
                if (recipientGroup == speakerGroup) {
                    return ChatColor.GREEN;
                }
                if (recipientGroup.getAllies().contains(speakerGroup)) {
                    return ChatColor.LIGHT_PURPLE;
                }
                return ChatColor.WHITE;
            }

            private String formatMessage(Group speakerGroup, Player speaker2, ChatColor bracketColor, String displayName, String msg) {
                StringBuilder builder = new StringBuilder();
                if (speakerGroup != null) {
                    builder.append(bracketColor).append("[").append(speakerGroup.getGroupColor()).append(speakerGroup.getName()).append(bracketColor).append("] ").append(this.getStatusString(speakerGroup, speaker2)).append(ChatColor.RESET).append(" ");
                }
                builder.append(displayName).append(": ").append(msg);
                return builder.toString();
            }

            private String getStatusString(Group group, Player player) {
                String letter;
                ChatColor letterColor;
                if (group.getLeader().equals(player.getUniqueId())) {
                    letterColor = ChatColor.YELLOW;
                    letter = "L";
                } else if (group.getModerators().contains(player.getUniqueId())) {
                    letterColor = ChatColor.BLUE;
                    letter = "M";
                } else {
                    letterColor = ChatColor.WHITE;
                    letter = "G";
                }
                return String.valueOf(ChatColor.WHITE) + "[" + String.valueOf(letterColor) + letter + String.valueOf(ChatColor.WHITE) + "]";
            }
        }.runTask((Plugin)this);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        String lastZoneForPlayer;
        String currentZone;
        Player player = event.getPlayer();
        if (!this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        Chunk fromChunk = event.getFrom().getChunk();
        Chunk toChunk = event.getTo().getChunk();
        float yaw = player.getLocation().getYaw();
        float lastKnownYaw = this.lastYaw.getOrDefault(player.getUniqueId(), Float.valueOf(yaw)).floatValue();
        int rotation = Math.round(yaw / 90.0f) % 4;
        int lastRotation = Math.round(lastKnownYaw / 90.0f) % 4;
        if (rotation < 0) {
            rotation += 4;
        }
        if (lastRotation < 0) {
            lastRotation += 4;
        }
        if (!fromChunk.equals((Object)toChunk) || rotation != lastRotation) {
            this.updateScoreboard(player, toChunk);
            this.lastYaw.put(player.getUniqueId(), Float.valueOf(yaw));
        }
        if (!(currentZone = this.getZoneName(toChunk, player)).equals(lastZoneForPlayer = this.lastZone.getOrDefault(player.getUniqueId(), ""))) {
            ChatColor color = this.getChunkColor(toChunk, player);
            player.sendActionBar(String.valueOf(color) + currentZone);
            this.lastZone.put(player.getUniqueId(), currentZone);
        }
    }

    private void updateScoreboardsForChunk(Chunk chunk) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) continue;
            Chunk playerChunk = player.getLocation().getChunk();
            int dx = Math.abs(chunk.getX() - playerChunk.getX());
            int dz = Math.abs(chunk.getZ() - playerChunk.getZ());
            if (dx > 4 || dz > 4) continue;
            this.updateScoreboard(player, playerChunk);
        }
    }

    private void updateScoreboard(Player player, Chunk chunk) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = manager.getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("claimMap", "dummy", String.valueOf(ChatColor.GOLD) + "Claim Map");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        float yaw = player.getLocation().getYaw();
        int rotation = Math.round(yaw / 90.0f) % 4;
        if (rotation < 0) {
            rotation += 4;
        }
        int frontChunkX = chunk.getX();
        int frontChunkZ = chunk.getZ();
        switch (rotation) {
            case 0: {
                ++frontChunkZ;
                break;
            }
            case 1: {
                --frontChunkX;
                break;
            }
            case 2: {
                --frontChunkZ;
                break;
            }
            case 3: {
                ++frontChunkX;
            }
        }
        Chunk frontChunk = chunk.getWorld().getChunkAt(frontChunkX, frontChunkZ);
        int rowNum = 0;
        for (int dy = -4; dy <= 4; ++dy) {
            StringBuilder lineContent = new StringBuilder();
            int startX = rotation == 0 || rotation == 2 ? 4 : -4;
            int endX = rotation == 0 || rotation == 2 ? -4 : 4;
            int stepX = rotation == 0 || rotation == 2 ? -1 : 1;
            int dx = startX;
            while (rotation == 0 || rotation == 2 ? dx >= endX : dx <= endX) {
                int rotX;
                Chunk targetChunk = chunk.getWorld().getChunkAt(chunk.getX() + rotX, chunk.getZ() + (switch (rotation) {
                    case 0 -> {
                        rotX = dx;
                        yield -dy;
                    }
                    case 1 -> {
                        rotX = dy;
                        yield -dx;
                    }
                    case 2 -> {
                        rotX = -dx;
                        yield dy;
                    }
                    case 3 -> {
                        rotX = -dy;
                        yield dx;
                    }
                    default -> {
                        rotX = dx;
                        yield dy;
                    }
                }));
                ChatColor color = this.getChunkColor(targetChunk, player);
                String symbol = targetChunk.equals((Object)chunk) ? "\u2588" : (targetChunk.equals((Object)frontChunk) ? "\u2593" : "\u2592");
                lineContent.append(color).append(symbol);
                dx += stepX;
            }
            ChatColor unique = ChatColor.values()[rowNum % ChatColor.values().length];
            String entry = String.valueOf(unique) + String.valueOf(ChatColor.RESET) + lineContent.toString();
            Score score = objective.getScore(entry);
            score.setScore(8 - rowNum);
            ++rowNum;
        }
        player.setScoreboard(scoreboard);
    }

    private ChatColor getChunkColor(Chunk chunk, Player player) {
        if (this.isSpawnSafeZone(chunk)) {
            return ChatColor.BLUE;
        }
        if (this.isNeutralZone(chunk)) {
            return ChatColor.GOLD;
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (owningGroup == null) {
            return ChatColor.DARK_GRAY;
        }
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        if (playerGroup != null) {
            if (playerGroup == owningGroup) {
                return ChatColor.GREEN;
            }
            if (playerGroup.getAllies().contains(owningGroup)) {
                return ChatColor.LIGHT_PURPLE;
            }
        }
        return ChatColor.YELLOW;
    }

    private String getZoneName(Chunk chunk, Player player) {
        if (this.isSpawnSafeZone(chunk)) {
            return this.hasActivePvpTimer(player) ? "Entering Safe Zone (In Combat)" : "Entering Safe Zone";
        }
        if (this.isNeutralZone(chunk)) {
            return "Entering Neutral Zone";
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (owningGroup == null) {
            return "Entering Wilderness";
        }
        return "Entering " + owningGroup.getName() + "'s land";
    }

    private boolean isSpawnSafeZone(Chunk chunk) {
        World world = chunk.getWorld();
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return false;
        }
        return this.spawnSafeZones.contains(chunk);
    }

    private boolean isNeutralZone(Chunk chunk) {
        World world = chunk.getWorld();
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return false;
        }
        return this.neutralZones.contains(chunk);
    }

    private static class Group {
        private String name;
        private UUID leader;
        private Set<UUID> members;
        private Set<UUID> moderators;
        private Set<Chunk> claims;
        private long creationTime;
        private Map<UUID, Long> lastActive;
        private Set<Group> allies = new HashSet<Group>();
        private ChatColor groupColor = ChatColor.WHITE;
        private Map<Location, Lock> locks = new HashMap<Location, Lock>();

        public Group(String name, UUID leader, List<UUID> members, List<UUID> moderators, Set<Chunk> claims, long creationTime, Map<UUID, Long> lastActive, ChatColor groupColor) {
            this.name = name;
            this.leader = leader;
            this.members = new HashSet<UUID>(members);
            this.moderators = new HashSet<UUID>(moderators);
            this.claims = claims;
            this.creationTime = creationTime;
            this.lastActive = lastActive;
            this.groupColor = groupColor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UUID getLeader() {
            return this.leader;
        }

        public void setLeader(UUID leader) {
            this.leader = leader;
        }

        public Set<UUID> getMembers() {
            return this.members;
        }

        public Set<UUID> getModerators() {
            return this.moderators;
        }

        public Set<Chunk> getClaims() {
            return this.claims;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public Map<UUID, Long> getLastActive() {
            return this.lastActive;
        }

        public Set<Group> getAllies() {
            return this.allies;
        }

        public void setAllies(Set<Group> allies) {
            this.allies = allies;
        }

        public ChatColor getGroupColor() {
            return this.groupColor;
        }

        public void setGroupColor(ChatColor groupColor) {
            this.groupColor = groupColor;
        }

        public Map<Location, Lock> getLocks() {
            return this.locks;
        }

        public int getMaxClaims() {
            long now = System.currentTimeMillis();
            long elapsedMillis = now - this.creationTime;
            long weeks = elapsedMillis / 10080000L;
            SimpleGroupsAndClaims plugin = (SimpleGroupsAndClaims)Bukkit.getPluginManager().getPlugin("SimpleGroupsAndClaims");
            return plugin.startingClaims + (int)(weeks * (long)plugin.claimGrowthPerWeek);
        }
    }

    private static class Lock {
        UUID owner;
        Role role;
        Set<UUID> allowed = new HashSet<UUID>();

        Lock(UUID owner, Role role) {
            this.owner = owner;
            this.role = role;
        }
    }

    private static enum Role {
        MEMBER,
        MODERATOR,
        LEADER;

    }
}

