/*
 * Decompiled with CFR 0.152.
 */
package com.example.SimpleGroupsAndClaims;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.Vector;

public class SimpleGroupsAndClaims
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private Map<String, Group> groups = new HashMap<String, Group>();
    private Map<UUID, Group> playerGroups = new HashMap<UUID, Group>();
    private Map<UUID, String> pendingInvites = new HashMap<UUID, String>();
    private Map<String, Set<String>> pendingAllianceRequests = new HashMap<String, Set<String>>();
    private Map<Chunk, Group> claimedChunks = new HashMap<Chunk, Group>();
    private Map<UUID, Boolean> mapToggled = new HashMap<UUID, Boolean>();
    private Map<UUID, Float> lastYaw = new HashMap<UUID, Float>();
    private Map<UUID, String> lastZone = new HashMap<UUID, String>();
    private Map<UUID, Long> pvpTimers = new HashMap<UUID, Long>();
    private Map<UUID, BossBar> pvpBossBars = new HashMap<UUID, BossBar>();
    private Map<UUID, UUID> lastDamager = new HashMap<UUID, UUID>();
    private Map<UUID, BukkitRunnable> pvpTimerTasks = new HashMap<UUID, BukkitRunnable>();
    private Set<Chunk> spawnSafeZones = new HashSet<Chunk>();
    private Set<Chunk> neutralZones = new HashSet<Chunk>();
    private File groupsFile;
    private FileConfiguration groupsConfig;
    private FileConfiguration config;
    private int startingClaims;
    private int claimGrowthPerWeek;
    private long pvpTimerDuration;
    private int minGroupNameLength;
    private int maxGroupNameLength;
    private List<String> groupNameBlacklist;
    private long inactivityDays;
    private final int MAP_SIZE = 9;
    private final int MAP_RADIUS = 4;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("g").setExecutor((CommandExecutor)this);
        this.getCommand("g").setTabCompleter((TabCompleter)this);
        this.loadConfig();
        this.loadGroups();
        for (Group group : this.groups.values()) {
            for (Chunk chunk : group.getClaims()) {
                this.claimedChunks.put(chunk, group);
            }
        }
        new BukkitRunnable(){

            public void run() {
                SimpleGroupsAndClaims.this.checkInactivity();
            }
        }.runTaskTimer((Plugin)this, 0L, 1728000L);
    }

    public void onDisable() {
        for (BossBar bar : this.pvpBossBars.values()) {
            bar.removeAll();
        }
        this.pvpBossBars.clear();
        for (BukkitRunnable task : this.pvpTimerTasks.values()) {
            task.cancel();
        }
        this.pvpTimerTasks.clear();
        this.saveGroups();
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.startingClaims = this.config.getInt("group.starting-claims", 10);
        this.claimGrowthPerWeek = this.config.getInt("group.claim-growth-per-week", 2);
        this.pvpTimerDuration = this.config.getLong("pvp.timer-duration-seconds", 15L) * 1000L;
        this.minGroupNameLength = this.config.getInt("group.name.min-length", 3);
        this.maxGroupNameLength = this.config.getInt("group.name.max-length", 20);
        this.groupNameBlacklist = this.config.getStringList("group.name.blacklist");
        this.inactivityDays = this.config.getLong("group.inactivity-days", 30L);
        if (this.startingClaims < 0) {
            this.startingClaims = 0;
        }
        if (this.claimGrowthPerWeek < 0) {
            this.claimGrowthPerWeek = 0;
        }
        if (this.pvpTimerDuration < 0L) {
            this.pvpTimerDuration = 0L;
        }
        if (this.minGroupNameLength < 1) {
            this.minGroupNameLength = 1;
        }
        if (this.maxGroupNameLength < this.minGroupNameLength) {
            this.maxGroupNameLength = this.minGroupNameLength;
        }
        if (this.inactivityDays < 0L) {
            this.inactivityDays = 0L;
        }
    }

    private void loadGroups() {
        ConfigurationSection neutralZonesSection;
        ConfigurationSection safeZonesSection;
        ConfigurationSection alliancesSection;
        ConfigurationSection section;
        this.groupsFile = new File(this.getDataFolder(), "groups.yml");
        if (!this.groupsFile.exists()) {
            try {
                this.groupsFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Failed to create groups.yml: " + e.getMessage());
            }
        }
        this.groupsConfig = YamlConfiguration.loadConfiguration((File)this.groupsFile);
        for (Object groupName : this.groupsConfig.getKeys(false)) {
            Object uuidStr2;
            if (((String)groupName).equals("pending_invites") || ((String)groupName).equals("pending_alliance_requests") || ((String)groupName).equals("spawn_safe_zones") || ((String)groupName).equals("neutral_zones")) continue;
            section = this.groupsConfig.getConfigurationSection((String)groupName);
            UUID leader = UUID.fromString(section.getString("leader"));
            ArrayList<UUID> members = new ArrayList<UUID>();
            for (Object uuidStr2 : section.getStringList("members")) {
                members.add(UUID.fromString((String)uuidStr2));
            }
            ArrayList<UUID> moderators = new ArrayList<UUID>();
            uuidStr2 = section.getStringList("moderators").iterator();
            while (uuidStr2.hasNext()) {
                String uuidStr3 = (String)uuidStr2.next();
                moderators.add(UUID.fromString(uuidStr3));
            }
            HashSet<Chunk> claims = new HashSet<Chunk>();
            for (String claimStr : section.getStringList("claims")) {
                String[] parts = claimStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                claims.add(world.getChunkAt(x, z));
            }
            long creationTime = section.getLong("creationTime", System.currentTimeMillis());
            HashMap<UUID, Long> lastActive = new HashMap<UUID, Long>();
            ConfigurationSection activeSection = section.getConfigurationSection("last-active");
            if (activeSection != null) {
                for (String uuidStr4 : activeSection.getKeys(false)) {
                    lastActive.put(UUID.fromString(uuidStr4), activeSection.getLong(uuidStr4));
                }
            }
            Group group = new Group((String)groupName, leader, members, moderators, claims, creationTime, lastActive);
            this.groups.put((String)groupName, group);
            for (UUID member : members) {
                this.playerGroups.put(member, group);
            }
            for (UUID moderator : moderators) {
                this.playerGroups.put(moderator, group);
            }
            this.playerGroups.put(leader, group);
        }
        for (Object groupName : this.groupsConfig.getKeys(false)) {
            if (((String)groupName).equals("pending_invites") || ((String)groupName).equals("pending_alliance_requests") || ((String)groupName).equals("spawn_safe_zones") || ((String)groupName).equals("neutral_zones")) continue;
            section = this.groupsConfig.getConfigurationSection((String)groupName);
            List allyNames = section.getStringList("allies");
            Group group = this.groups.get(groupName);
            Set<Group> allies = allyNames.stream().map(this.groups::get).filter(Objects::nonNull).collect(Collectors.toSet());
            group.setAllies(allies);
        }
        ConfigurationSection invitesSection = this.groupsConfig.getConfigurationSection("pending_invites");
        if (invitesSection != null) {
            for (Object key : invitesSection.getKeys(false)) {
                UUID playerUUID = UUID.fromString((String)key);
                String groupName = invitesSection.getString((String)key);
                if (!this.groups.containsKey(groupName)) continue;
                this.pendingInvites.put(playerUUID, groupName);
            }
        }
        if ((alliancesSection = this.groupsConfig.getConfigurationSection("pending_alliance_requests")) != null) {
            for (Object targetGroupName : alliancesSection.getKeys(false)) {
                if (!this.groups.containsKey(targetGroupName)) continue;
                List requesters = alliancesSection.getStringList((String)targetGroupName);
                Set validRequesters = requesters.stream().filter(this.groups::containsKey).collect(Collectors.toSet());
                if (validRequesters.isEmpty()) continue;
                this.pendingAllianceRequests.put((String)targetGroupName, validRequesters);
            }
        }
        if ((safeZonesSection = this.groupsConfig.getConfigurationSection("spawn_safe_zones")) != null) {
            for (String zoneStr : safeZonesSection.getStringList("chunks")) {
                String[] parts = zoneStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                this.spawnSafeZones.add(world.getChunkAt(x, z));
            }
        }
        if ((neutralZonesSection = this.groupsConfig.getConfigurationSection("neutral_zones")) != null) {
            for (String zoneStr : neutralZonesSection.getStringList("chunks")) {
                String[] parts = zoneStr.split(":");
                UUID worldUUID = UUID.fromString(parts[0]);
                int x = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                World world = Bukkit.getWorld((UUID)worldUUID);
                if (world == null) continue;
                this.neutralZones.add(world.getChunkAt(x, z));
            }
        }
    }

    private void saveGroups() {
        for (Group group : this.groups.values()) {
            Object moderator2;
            ConfigurationSection configurationSection = this.groupsConfig.createSection(group.getName());
            configurationSection.set("leader", (Object)group.getLeader().toString());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UUID uUID : group.getMembers()) {
                arrayList.add(uUID.toString());
            }
            configurationSection.set("members", arrayList);
            ArrayList moderators = new ArrayList();
            for (Object moderator2 : group.getModerators()) {
                moderators.add(((UUID)moderator2).toString());
            }
            configurationSection.set("moderators", (Object)moderators);
            ArrayList<CallSite> arrayList2 = new ArrayList<CallSite>();
            moderator2 = group.getClaims().iterator();
            while (moderator2.hasNext()) {
                Chunk chunk = (Chunk)moderator2.next();
                arrayList2.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
            }
            configurationSection.set("claims", arrayList2);
            configurationSection.set("creationTime", (Object)group.getCreationTime());
            ConfigurationSection activeSection = configurationSection.createSection("last-active");
            for (Map.Entry<UUID, Long> entry : group.getLastActive().entrySet()) {
                activeSection.set(entry.getKey().toString(), (Object)entry.getValue());
            }
            List list = group.getAllies().stream().map(Group::getName).collect(Collectors.toList());
            configurationSection.set("allies", list);
        }
        ConfigurationSection invitesSection = this.groupsConfig.createSection("pending_invites");
        for (Map.Entry<UUID, String> entry : this.pendingInvites.entrySet()) {
            invitesSection.set(entry.getKey().toString(), (Object)entry.getValue());
        }
        ConfigurationSection configurationSection = this.groupsConfig.createSection("pending_alliance_requests");
        for (Map.Entry<String, Set<String>> entry : this.pendingAllianceRequests.entrySet()) {
            configurationSection.set(entry.getKey(), new ArrayList(entry.getValue()));
        }
        ConfigurationSection configurationSection2 = this.groupsConfig.createSection("spawn_safe_zones");
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (Chunk chunk : this.spawnSafeZones) {
            arrayList.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
        }
        configurationSection2.set("chunks", arrayList);
        ConfigurationSection neutralZonesSection = this.groupsConfig.createSection("neutral_zones");
        ArrayList<CallSite> arrayList3 = new ArrayList<CallSite>();
        for (Chunk chunk : this.neutralZones) {
            arrayList3.add((CallSite)((Object)(chunk.getWorld().getUID().toString() + ":" + chunk.getX() + ":" + chunk.getZ())));
        }
        neutralZonesSection.set("chunks", arrayList3);
        try {
            this.groupsConfig.save(this.groupsFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save groups.yml: " + e.getMessage());
        }
    }

    private boolean isValidGroupName(String name, Player player) {
        if (name.length() < this.minGroupNameLength) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name must be at least " + this.minGroupNameLength + " characters long.");
            return false;
        }
        if (name.length() > this.maxGroupNameLength) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name cannot exceed " + this.maxGroupNameLength + " characters.");
            return false;
        }
        if (this.groupNameBlacklist.stream().anyMatch(name::equalsIgnoreCase)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Group name is not allowed.");
            return false;
        }
        return true;
    }

    private void checkInactivity() {
        long currentTime = System.currentTimeMillis();
        long inactivityMillis = this.inactivityDays * 24L * 60L * 60L * 1000L;
        ArrayList<String> groupsToDelete = new ArrayList<String>();
        for (Group group : this.groups.values()) {
            ArrayList<UUID> membersToKick = new ArrayList<UUID>();
            for (UUID uUID : group.getMembers()) {
                Long lastActive = group.getLastActive().get(uUID);
                if (lastActive != null && currentTime - lastActive <= inactivityMillis) continue;
                membersToKick.add(uUID);
            }
            ArrayList<UUID> moderatorsToKick = new ArrayList<UUID>();
            for (UUID moderator : group.getModerators()) {
                Long lastActive = group.getLastActive().get(moderator);
                if (lastActive != null && currentTime - lastActive <= inactivityMillis) continue;
                moderatorsToKick.add(moderator);
            }
            Long l = group.getLastActive().get(group.getLeader());
            boolean leaderInactive = l == null || currentTime - l > inactivityMillis;
            for (UUID uUID : membersToKick) {
                group.getMembers().remove(uUID);
                this.playerGroups.remove(uUID);
                Player memberPlayer = Bukkit.getPlayer((UUID)uUID);
                if (memberPlayer != null) {
                    memberPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You have been kicked from " + group.getName() + " due to inactivity.");
                }
                this.getLogger().info("Kicked member " + String.valueOf(uUID) + " from " + group.getName() + " due to inactivity.");
            }
            for (UUID uUID : moderatorsToKick) {
                group.getModerators().remove(uUID);
                this.playerGroups.put(uUID, group);
                group.getMembers().add(uUID);
                Player modPlayer = Bukkit.getPlayer((UUID)uUID);
                if (modPlayer != null) {
                    modPlayer.sendMessage(String.valueOf(ChatColor.RED) + "You have been demoted from moderator in " + group.getName() + " due to inactivity.");
                }
                this.getLogger().info("Demoted moderator " + String.valueOf(uUID) + " from " + group.getName() + " due to inactivity.");
            }
            if (!leaderInactive || !group.getMembers().isEmpty() || !group.getModerators().isEmpty()) continue;
            groupsToDelete.add(group.getName());
            for (Chunk chunk : group.getClaims()) {
                this.claimedChunks.remove(chunk);
                this.updateScoreboardsForChunk(chunk);
            }
            for (Group group2 : new HashSet<Group>(group.getAllies())) {
                group2.getAllies().remove(group);
            }
            this.pendingInvites.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(group.getName()));
            this.pendingAllianceRequests.remove(group.getName());
            this.pendingAllianceRequests.values().forEach(set -> set.remove(group.getName()));
            this.playerGroups.remove(group.getLeader());
            this.groupsConfig.set(group.getName(), null);
            this.getLogger().info("Deleted group " + group.getName() + " due to inactivity of all members, moderators, and leader.");
        }
        for (String groupName : groupsToDelete) {
            this.groups.remove(groupName);
            Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + "Group " + groupName + " has been deleted due to inactivity."));
        }
        this.saveGroups();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelp(player);
            return true;
        }
        String sub = args[0].toLowerCase();
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        switch (sub) {
            case "create": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g create <name>");
                    return true;
                }
                String name = args[1];
                if (this.groups.containsKey(name)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group already exists.");
                    return true;
                }
                if (playerGroup != null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a group.");
                    return true;
                }
                if (!this.isValidGroupName(name, player)) {
                    return true;
                }
                Group newGroup = new Group(name, player.getUniqueId(), new ArrayList<UUID>(), new ArrayList<UUID>(), new HashSet<Chunk>(), System.currentTimeMillis(), new HashMap<UUID, Long>());
                newGroup.getLastActive().put(player.getUniqueId(), System.currentTimeMillis());
                this.groups.put(name, newGroup);
                this.playerGroups.put(player.getUniqueId(), newGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group " + name + " created.");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has created the group: " + name));
                this.saveGroups();
                break;
            }
            case "rename": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g rename <newname>");
                    return true;
                }
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Only the leader can rename the group.");
                    return true;
                }
                String newName = args[1];
                if (this.groups.containsKey(newName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "A group with that name already exists.");
                    return true;
                }
                if (!this.isValidGroupName(newName, player)) {
                    return true;
                }
                String oldName = playerGroup.getName();
                this.groups.remove(oldName);
                playerGroup.setName(newName);
                this.groups.put(newName, playerGroup);
                this.pendingInvites.replaceAll((uuid, groupName) -> groupName.equals(oldName) ? newName : groupName);
                this.pendingAllianceRequests.replaceAll((target, requesters) -> {
                    HashSet<String> updated = new HashSet<String>((Collection<String>)requesters);
                    if (updated.contains(oldName)) {
                        updated.remove(oldName);
                        updated.add(newName);
                    }
                    return updated;
                });
                Set<String> pendingForGroup = this.pendingAllianceRequests.remove(oldName);
                if (pendingForGroup != null) {
                    this.pendingAllianceRequests.put(newName, pendingForGroup);
                }
                for (Group ally : playerGroup.getAllies()) {
                    ally.getAllies().remove(playerGroup);
                    ally.getAllies().add(playerGroup);
                }
                this.groupsConfig.set(oldName, null);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group renamed to " + newName + ".");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has renamed their group from " + oldName + " to " + newName));
                this.saveGroups();
                break;
            }
            case "invite": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g invite <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to invite.");
                    return true;
                }
                Player target2 = Bukkit.getPlayer((String)args[1]);
                if (target2 == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (this.playerGroups.containsKey(target2.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is already in a group.");
                    return true;
                }
                this.pendingInvites.put(target2.getUniqueId(), playerGroup.getName());
                target2.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been invited to " + playerGroup.getName() + ". Use /g accept " + playerGroup.getName());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Invited " + target2.getName());
                this.saveGroups();
                break;
            }
            case "accept": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g accept <group>");
                    return true;
                }
                String inviteGroup = args[1];
                if (!this.pendingInvites.getOrDefault(player.getUniqueId(), "").equals(inviteGroup)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending invite for that group.");
                    return true;
                }
                Group groupToJoin = this.groups.get(inviteGroup);
                if (groupToJoin == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                groupToJoin.getMembers().add(player.getUniqueId());
                groupToJoin.getLastActive().put(player.getUniqueId(), System.currentTimeMillis());
                this.playerGroups.put(player.getUniqueId(), groupToJoin);
                this.pendingInvites.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Joined " + inviteGroup);
                this.saveGroups();
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g kick <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to kick.");
                    return true;
                }
                Player kickTarget = Bukkit.getPlayer((String)args[1]);
                if (kickTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(kickTarget.getUniqueId()) && !playerGroup.getModerators().contains(kickTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not in your group.");
                    return true;
                }
                if (kickTarget.getUniqueId().equals(playerGroup.getLeader())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot kick the group leader.");
                    return true;
                }
                playerGroup.getMembers().remove(kickTarget.getUniqueId());
                playerGroup.getModerators().remove(kickTarget.getUniqueId());
                playerGroup.getLastActive().remove(kickTarget.getUniqueId());
                this.playerGroups.remove(kickTarget.getUniqueId());
                kickTarget.sendMessage(String.valueOf(ChatColor.RED) + "You have been kicked from " + playerGroup.getName());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Kicked " + kickTarget.getName());
                this.saveGroups();
                break;
            }
            case "promote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g promote <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to promote.");
                    return true;
                }
                Player promoteTarget = Bukkit.getPlayer((String)args[1]);
                if (promoteTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(promoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not a member of your group.");
                    return true;
                }
                if (playerGroup.getModerators().contains(promoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is already a moderator.");
                    return true;
                }
                playerGroup.getMembers().remove(promoteTarget.getUniqueId());
                playerGroup.getModerators().add(promoteTarget.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + promoteTarget.getName() + " has been promoted to moderator.");
                promoteTarget.sendMessage(String.valueOf(ChatColor.GREEN) + "You have been promoted to moderator in " + playerGroup.getName() + ".");
                this.saveGroups();
                break;
            }
            case "demote": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g demote <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to demote.");
                    return true;
                }
                Player demoteTarget = Bukkit.getPlayer((String)args[1]);
                if (demoteTarget == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getModerators().contains(demoteTarget.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not a moderator in your group.");
                    return true;
                }
                playerGroup.getModerators().remove(demoteTarget.getUniqueId());
                playerGroup.getMembers().add(demoteTarget.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + demoteTarget.getName() + " has been demoted to member.");
                demoteTarget.sendMessage(String.valueOf(ChatColor.RED) + "You have been demoted to member in " + playerGroup.getName() + ".");
                this.saveGroups();
                break;
            }
            case "transfer": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g transfer <player>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to transfer leadership.");
                    return true;
                }
                Player newLeader = Bukkit.getPlayer((String)args[1]);
                if (newLeader == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
                    return true;
                }
                if (!playerGroup.getMembers().contains(newLeader.getUniqueId()) && !playerGroup.getModerators().contains(newLeader.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Player is not in your group.");
                    return true;
                }
                playerGroup.setLeader(newLeader.getUniqueId());
                playerGroup.getMembers().remove(newLeader.getUniqueId());
                playerGroup.getModerators().remove(newLeader.getUniqueId());
                playerGroup.getMembers().add(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Leadership transferred to " + newLeader.getName() + ".");
                newLeader.sendMessage(String.valueOf(ChatColor.GREEN) + "You are now the leader of " + playerGroup.getName() + ".");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has transferred leadership of " + playerGroup.getName() + " to " + newLeader.getName() + "."));
                this.saveGroups();
                break;
            }
            case "leave": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Leaders cannot leave. Use /g delete or /g transfer instead.");
                    return true;
                }
                playerGroup.getMembers().remove(player.getUniqueId());
                playerGroup.getModerators().remove(player.getUniqueId());
                playerGroup.getLastActive().remove(player.getUniqueId());
                this.playerGroups.remove(player.getUniqueId());
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "You have left the group.");
                this.saveGroups();
                break;
            }
            case "delete": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Only the leader can delete the group.");
                    return true;
                }
                for (Chunk c : playerGroup.getClaims()) {
                    this.claimedChunks.remove(c);
                    this.updateScoreboardsForChunk(c);
                }
                for (Group ally : new HashSet<Group>(playerGroup.getAllies())) {
                    ally.getAllies().remove(playerGroup);
                }
                this.pendingInvites.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(playerGroup.getName()));
                this.pendingAllianceRequests.remove(playerGroup.getName());
                this.pendingAllianceRequests.values().forEach(set -> set.remove(playerGroup.getName()));
                for (UUID member : playerGroup.getMembers()) {
                    this.playerGroups.remove(member);
                }
                for (UUID moderator : playerGroup.getModerators()) {
                    this.playerGroups.remove(moderator);
                }
                this.playerGroups.remove(playerGroup.getLeader());
                String groupName2 = playerGroup.getName();
                this.groups.remove(groupName2);
                this.groupsConfig.set(groupName2, null);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Group deleted.");
                Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.YELLOW) + player.getName() + " has destroyed their group: " + groupName2));
                this.saveGroups();
                break;
            }
            case "allyrequest": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g allyrequest <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to request alliance.");
                    return true;
                }
                String targetName = args[1];
                if (!this.groups.containsKey(targetName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                Group targetGroup = this.groups.get(targetName);
                if (targetGroup == playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot ally your own group.");
                    return true;
                }
                if (playerGroup.getAllies().contains(targetGroup)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Already allied with " + targetName + ".");
                    return true;
                }
                this.pendingAllianceRequests.computeIfAbsent(targetName, k -> new HashSet()).add(playerGroup.getName());
                Player targetLeader = Bukkit.getPlayer((UUID)targetGroup.getLeader());
                if (targetLeader != null) {
                    targetLeader.sendMessage(String.valueOf(ChatColor.GREEN) + playerGroup.getName() + " has requested an alliance. Use /g acceptally " + playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance request sent to " + targetName + ".");
                this.saveGroups();
                break;
            }
            case "acceptally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g acceptally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to accept alliance.");
                    return true;
                }
                String requesterName = args[1];
                Set<String> pendings = this.pendingAllianceRequests.get(playerGroup.getName());
                if (pendings == null || !pendings.contains(requesterName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending alliance request from " + requesterName + ".");
                    return true;
                }
                Group requesterGroup = this.groups.get(requesterName);
                if (requesterGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                playerGroup.getAllies().add(requesterGroup);
                requesterGroup.getAllies().add(playerGroup);
                pendings.remove(requesterName);
                if (pendings.isEmpty()) {
                    this.pendingAllianceRequests.remove(playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance accepted with " + requesterName + ".");
                Player requesterLeader = Bukkit.getPlayer((UUID)requesterGroup.getLeader());
                if (requesterLeader != null) {
                    requesterLeader.sendMessage(String.valueOf(ChatColor.GREEN) + playerGroup.getName() + " has accepted your alliance request.");
                }
                this.saveGroups();
                break;
            }
            case "denyally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g denyally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to deny alliance.");
                    return true;
                }
                String denierName = args[1];
                Set<String> denyPendings = this.pendingAllianceRequests.get(playerGroup.getName());
                if (denyPendings == null || !denyPendings.contains(denierName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "No pending alliance request from " + denierName + ".");
                    return true;
                }
                denyPendings.remove(denierName);
                if (denyPendings.isEmpty()) {
                    this.pendingAllianceRequests.remove(playerGroup.getName());
                }
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Alliance request from " + denierName + " denied.");
                this.saveGroups();
                break;
            }
            case "unally": {
                if (args.length < 2) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /g unally <group>");
                    return true;
                }
                if (playerGroup == null || !playerGroup.getLeader().equals(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader to unally.");
                    return true;
                }
                String unallyName = args[1];
                if (!this.groups.containsKey(unallyName)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Group not found.");
                    return true;
                }
                Group targetUnally = this.groups.get(unallyName);
                if (!playerGroup.getAllies().contains(targetUnally)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Not allied with " + unallyName + ".");
                    return true;
                }
                playerGroup.getAllies().remove(targetUnally);
                targetUnally.getAllies().remove(playerGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Removed alliance with " + unallyName + ".");
                Player otherLeader = Bukkit.getPlayer((UUID)targetUnally.getLeader());
                if (otherLeader != null) {
                    otherLeader.sendMessage(String.valueOf(ChatColor.RED) + playerGroup.getName() + " has ended the alliance.");
                }
                this.saveGroups();
                break;
            }
            case "claim": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be in a group to claim.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to claim.");
                    return true;
                }
                if (this.hasActivePvpTimer(player)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot claim chunks while in combat.");
                    return true;
                }
                Chunk chunk = player.getLocation().getChunk();
                if (this.claimedChunks.containsKey(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Chunk already claimed.");
                    return true;
                }
                if (this.isSpawnSafeZone(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot claim in spawn safe zone.");
                    return true;
                }
                if (this.isNeutralZone(chunk)) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Cannot claim in neutral zone.");
                    return true;
                }
                if (playerGroup.getClaims().size() >= playerGroup.getMaxClaims()) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Your group has reached the claim limit.");
                    return true;
                }
                playerGroup.getClaims().add(chunk);
                this.claimedChunks.put(chunk, playerGroup);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk claimed.");
                this.updateScoreboardsForChunk(chunk);
                this.saveGroups();
                break;
            }
            case "unclaim": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be in a group to unclaim.");
                    return true;
                }
                if (!playerGroup.getLeader().equals(player.getUniqueId()) && !playerGroup.getModerators().contains(player.getUniqueId())) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You must be the leader or a moderator to unclaim.");
                    return true;
                }
                Chunk unclaimChunk = player.getLocation().getChunk();
                if (!this.claimedChunks.containsKey(unclaimChunk) || this.claimedChunks.get(unclaimChunk) != playerGroup) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This is not your group's chunk.");
                    return true;
                }
                playerGroup.getClaims().remove(unclaimChunk);
                this.claimedChunks.remove(unclaimChunk);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk unclaimed.");
                this.updateScoreboardsForChunk(unclaimChunk);
                this.saveGroups();
                break;
            }
            case "map": {
                boolean isToggled = this.mapToggled.getOrDefault(player.getUniqueId(), true);
                this.mapToggled.put(player.getUniqueId(), !isToggled);
                if (!isToggled) {
                    this.updateScoreboard(player, player.getLocation().getChunk());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Map enabled.");
                    break;
                }
                player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
                player.sendMessage(String.valueOf(ChatColor.RED) + "Map disabled.");
                break;
            }
            case "setsafezone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to set safe zones.");
                    return true;
                }
                Chunk safeChunk = player.getLocation().getChunk();
                this.spawnSafeZones.add(safeChunk);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk set as spawn safe zone.");
                this.updateScoreboardsForChunk(safeChunk);
                this.saveGroups();
                break;
            }
            case "removesafezone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to remove safe zones.");
                    return true;
                }
                Chunk removeSafeChunk = player.getLocation().getChunk();
                if (this.spawnSafeZones.remove(removeSafeChunk)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk removed from spawn safe zone.");
                    this.updateScoreboardsForChunk(removeSafeChunk);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This chunk is not a spawn safe zone.");
                }
                this.saveGroups();
                break;
            }
            case "setneutralzone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to set neutral zones.");
                    return true;
                }
                Chunk neutralChunk = player.getLocation().getChunk();
                this.neutralZones.add(neutralChunk);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk set as neutral zone.");
                this.updateScoreboardsForChunk(neutralChunk);
                this.saveGroups();
                break;
            }
            case "removeneutralzone": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to remove neutral zones.");
                    return true;
                }
                Chunk removeNeutralChunk = player.getLocation().getChunk();
                if (this.neutralZones.remove(removeNeutralChunk)) {
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Chunk removed from neutral zone.");
                    this.updateScoreboardsForChunk(removeNeutralChunk);
                } else {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "This chunk is not a neutral zone.");
                }
                this.saveGroups();
                break;
            }
            case "info": {
                if (playerGroup == null) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You are not in a group.");
                    return true;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM d, yyyy");
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Name: " + String.valueOf(ChatColor.WHITE) + String.valueOf(ChatColor.BOLD) + playerGroup.getName());
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Claims: " + String.valueOf(ChatColor.WHITE) + playerGroup.getClaims().size() + " / " + playerGroup.getMaxClaims());
                StringBuilder membersList = new StringBuilder(String.valueOf(ChatColor.YELLOW) + "Group Members: " + String.valueOf(ChatColor.WHITE));
                Player leader = Bukkit.getPlayer((UUID)playerGroup.getLeader());
                membersList.append(ChatColor.YELLOW).append("[L] ").append(ChatColor.WHITE).append(leader != null ? leader.getName() : "Offline");
                for (UUID moderatorId : playerGroup.getModerators()) {
                    Player moderator = Bukkit.getPlayer((UUID)moderatorId);
                    membersList.append(ChatColor.GRAY).append(", ").append(ChatColor.BLUE).append("[M] ").append(ChatColor.WHITE).append(moderator != null ? moderator.getName() : "Offline");
                }
                for (UUID memberId : playerGroup.getMembers()) {
                    Player member = Bukkit.getPlayer((UUID)memberId);
                    membersList.append(ChatColor.GRAY).append(", ").append(ChatColor.WHITE).append("[G] ").append(member != null ? member.getName() : "Offline");
                }
                player.sendMessage(membersList.toString());
                String allies = playerGroup.getAllies().stream().map(Group::getName).collect(Collectors.joining(", "));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Allies: " + String.valueOf(ChatColor.WHITE) + (allies.isEmpty() ? "None" : allies));
                String creationDate = dateFormat.format(new Date(playerGroup.getCreationTime()));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Creation: " + String.valueOf(ChatColor.WHITE) + creationDate);
                long creationTime = playerGroup.getCreationTime();
                long weekMillis = 604800000L;
                long elapsedMillis = System.currentTimeMillis() - creationTime;
                long weeks = elapsedMillis / weekMillis;
                long nextGrowthMillis = creationTime + (weeks + 1L) * weekMillis;
                String nextGrowth = dateFormat.format(new Date(nextGrowthMillis));
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Group Next Growth: " + String.valueOf(ChatColor.WHITE) + nextGrowth);
                break;
            }
            case "reload": {
                if (!player.hasPermission("SimpleGroupsAndClaims.admin")) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to reload the config.");
                    return true;
                }
                this.reloadConfig();
                this.loadConfig();
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded.");
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
        return true;
    }

    private void sendHelp(Player player) {
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g create <name>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g rename <newname>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g invite <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g accept <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g kick <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g promote <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g demote <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g transfer <player>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g leave");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g delete");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g allyrequest <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g acceptally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g denyally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g unally <group>");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g claim");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g unclaim");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g map - Toggle the claim map");
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g info - Show group information");
        if (player.hasPermission("SimpleGroupsAndClaims.admin")) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setsafezone - Set chunk as spawn safe zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g removesafezone - Remove chunk from spawn safe zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g setneutralzone - Set chunk as neutral zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g removeneutralzone - Remove chunk from neutral zone");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/g reload - Reload configuration");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        List<String> commands = Arrays.asList("create", "rename", "invite", "accept", "kick", "promote", "demote", "transfer", "leave", "delete", "allyrequest", "acceptally", "denyally", "unally", "claim", "unclaim", "map", "info");
        if (sender.hasPermission("SimpleGroupsAndClaims.admin")) {
            commands = new ArrayList<String>(commands);
            commands.addAll(Arrays.asList("setsafezone", "removesafezone", "setneutralzone", "removeneutralzone", "reload"));
        }
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], commands, completions);
        } else if (args.length == 2) {
            Group playerGroup = this.playerGroups.get(((Player)sender).getUniqueId());
            switch (args[0].toLowerCase()) {
                case "invite": {
                    if (playerGroup == null || !playerGroup.getLeader().equals(((Player)sender).getUniqueId()) && !playerGroup.getModerators().contains(((Player)sender).getUniqueId())) break;
                    List players = Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> !this.playerGroups.containsKey(Bukkit.getPlayer((String)name).getUniqueId())).collect(Collectors.toList());
                    StringUtil.copyPartialMatches((String)args[1], players, completions);
                    break;
                }
                case "kick": 
                case "promote": {
                    if (playerGroup == null || !playerGroup.getLeader().equals(((Player)sender).getUniqueId())) break;
                    List players = playerGroup.getMembers().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList());
                    if (args[0].equalsIgnoreCase("kick")) {
                        players.addAll(playerGroup.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                    }
                    StringUtil.copyPartialMatches((String)args[1], players, completions);
                    break;
                }
                case "demote": {
                    if (playerGroup == null || !playerGroup.getLeader().equals(((Player)sender).getUniqueId())) break;
                    List players = playerGroup.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList());
                    StringUtil.copyPartialMatches((String)args[1], players, completions);
                    break;
                }
                case "transfer": {
                    if (playerGroup == null || !playerGroup.getLeader().equals(((Player)sender).getUniqueId())) break;
                    ArrayList players = new ArrayList();
                    players.addAll(playerGroup.getMembers().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                    players.addAll(playerGroup.getModerators().stream().map(uuid -> Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : null).filter(Objects::nonNull).collect(Collectors.toList()));
                    StringUtil.copyPartialMatches((String)args[1], players, completions);
                    break;
                }
                case "accept": {
                    String pendingGroup = this.pendingInvites.get(((Player)sender).getUniqueId());
                    if (pendingGroup == null) break;
                    StringUtil.copyPartialMatches((String)args[1], Collections.singletonList(pendingGroup), completions);
                    break;
                }
                case "allyrequest": 
                case "acceptally": 
                case "denyally": 
                case "unally": {
                    ArrayList<String> groupsList = new ArrayList<String>(this.groups.keySet());
                    if (playerGroup != null) {
                        groupsList.remove(playerGroup.getName());
                        if (args[0].equalsIgnoreCase("acceptally")) {
                            Set pendings = this.pendingAllianceRequests.getOrDefault(playerGroup.getName(), new HashSet());
                            groupsList.retainAll(pendings);
                        } else if (args[0].equalsIgnoreCase("unally")) {
                            groupsList.retainAll(playerGroup.getAllies().stream().map(Group::getName).collect(Collectors.toSet()));
                        }
                    }
                    StringUtil.copyPartialMatches((String)args[1], groupsList, completions);
                }
            }
        }
        Collections.sort(completions);
        return completions;
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(chunk) || this.isNeutralZone(chunk)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot break blocks in this zone.");
            return;
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (!(owningGroup == null || owningGroup.getMembers().contains(player.getUniqueId()) || owningGroup.getModerators().contains(player.getUniqueId()) || owningGroup.getLeader().equals(player.getUniqueId()))) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot break blocks in this claimed chunk.");
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Chunk chunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(chunk) || this.isNeutralZone(chunk)) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place blocks in this zone.");
            return;
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (!(owningGroup == null || owningGroup.getMembers().contains(player.getUniqueId()) || owningGroup.getModerators().contains(player.getUniqueId()) || owningGroup.getLeader().equals(player.getUniqueId()))) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot place blocks in this claimed chunk.");
        }
    }

    @EventHandler
    public void onBlockFromTo(BlockFromToEvent event) {
        Chunk toChunk = event.getToBlock().getChunk();
        if (this.isSpawnSafeZone(toChunk) || this.isNeutralZone(toChunk)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        Chunk pistonChunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(pistonChunk) || this.isNeutralZone(pistonChunk)) {
            event.setCancelled(true);
            return;
        }
        Group pistonGroup = this.claimedChunks.get(pistonChunk);
        Vector direction = event.getDirection().getDirection();
        for (Block block : event.getBlocks()) {
            Chunk currentChunk = block.getChunk();
            if (this.isSpawnSafeZone(currentChunk) || this.isNeutralZone(currentChunk)) {
                event.setCancelled(true);
                return;
            }
            Group currentGroup = this.claimedChunks.get(currentChunk);
            if (currentGroup != null && currentGroup != pistonGroup) {
                event.setCancelled(true);
                return;
            }
            int newX = block.getX() + (int)direction.getX();
            int newZ = block.getZ() + (int)direction.getZ();
            Chunk destChunk = block.getWorld().getChunkAt(newX >> 4, newZ >> 4);
            if (this.isSpawnSafeZone(destChunk) || this.isNeutralZone(destChunk)) {
                event.setCancelled(true);
                return;
            }
            Group destGroup = this.claimedChunks.get(destChunk);
            if (destGroup == null || destGroup == pistonGroup) continue;
            event.setCancelled(true);
            return;
        }
        Block frontBlock = event.getBlock().getRelative(event.getDirection());
        Chunk frontChunk = frontBlock.getChunk();
        if (this.isSpawnSafeZone(frontChunk) || this.isNeutralZone(frontChunk)) {
            event.setCancelled(true);
            return;
        }
        Group frontGroup = this.claimedChunks.get(frontChunk);
        if (frontGroup != null && frontGroup != pistonGroup) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        Chunk pistonChunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(pistonChunk) || this.isNeutralZone(pistonChunk)) {
            event.setCancelled(true);
            return;
        }
        Group pistonGroup = this.claimedChunks.get(pistonChunk);
        for (Block block : event.getBlocks()) {
            Chunk currentChunk = block.getChunk();
            if (this.isSpawnSafeZone(currentChunk) || this.isNeutralZone(currentChunk)) {
                event.setCancelled(true);
                return;
            }
            Group currentGroup = this.claimedChunks.get(currentChunk);
            if (currentGroup == null || currentGroup == pistonGroup) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        for (Block block : event.blockList()) {
            if (!this.isSpawnSafeZone(block.getChunk()) && !this.isNeutralZone(block.getChunk())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Chunk chunk = event.getBlock().getChunk();
        if (this.isSpawnSafeZone(chunk) || this.isNeutralZone(chunk)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity damager = event.getDamager();
        Entity damagee = event.getEntity();
        if (!(damager instanceof Player) || !(damagee instanceof Player)) {
            return;
        }
        Player pDamager = (Player)damager;
        Player pDamagee = (Player)damagee;
        Chunk chunk = pDamagee.getLocation().getChunk();
        Group groupDamager = this.playerGroups.get(pDamager.getUniqueId());
        Group groupDamagee = this.playerGroups.get(pDamagee.getUniqueId());
        double rawDamage = event.getDamage();
        double finalDamage = event.getFinalDamage();
        double damageeHealth = pDamagee.getHealth();
        double absorptionAmount = pDamagee.getAbsorptionAmount();
        int foodLevel = pDamagee.getFoodLevel();
        boolean hasPvpTimer = this.hasActivePvpTimer(pDamagee);
        this.getLogger().info("Damage by " + pDamager.getName() + " to " + pDamagee.getName() + ": raw=" + rawDamage + ", final=" + finalDamage + ", health=" + damageeHealth + ", absorption=" + absorptionAmount + ", foodLevel=" + foodLevel + ", pvpTimer=" + hasPvpTimer + ", cancelled=" + event.isCancelled());
        if (this.isSpawnSafeZone(chunk) && !this.hasActivePvpTimer(pDamagee)) {
            event.setCancelled(true);
            pDamager.sendMessage(String.valueOf(ChatColor.RED) + "You cannot PvP in a spawn safe zone.");
            if (!event.isCancelled() && rawDamage > 0.0) {
                this.startPvpTimer(pDamager);
                this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
                this.getLogger().info("Combat timer reset for damager " + pDamager.getName());
            } else {
                this.getLogger().info("Combat timer reset skipped for damager " + pDamager.getName() + ": cancelled=" + event.isCancelled() + ", rawDamage=" + rawDamage);
            }
            return;
        }
        if (groupDamager != null && groupDamagee != null && (groupDamager == groupDamagee || groupDamager.getAllies().contains(groupDamagee))) {
            event.setCancelled(true);
            pDamager.sendMessage(String.valueOf(ChatColor.RED) + "You cannot PvP group members or allies.");
            if (!event.isCancelled() && rawDamage > 0.0) {
                this.startPvpTimer(pDamager);
                this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
                this.getLogger().info("Combat timer reset for damager " + pDamager.getName());
            } else {
                this.getLogger().info("Combat timer reset skipped for damager " + pDamager.getName() + ": cancelled=" + event.isCancelled() + ", rawDamage=" + rawDamage);
            }
            return;
        }
        if (!event.isCancelled() && rawDamage > 0.0) {
            this.startPvpTimer(pDamager);
            this.startPvpTimer(pDamagee);
            this.lastDamager.put(pDamagee.getUniqueId(), pDamager.getUniqueId());
            this.getLogger().info("PvP timers reset for " + pDamager.getName() + " and " + pDamagee.getName());
        } else {
            this.getLogger().info("PvP timer reset skipped for " + pDamager.getName() + " and " + pDamagee.getName() + ": cancelled=" + event.isCancelled() + ", rawDamage=" + rawDamage);
        }
    }

    @EventHandler
    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        this.getLogger().info("Health regain for " + player.getName() + ": amount=" + event.getAmount() + ", reason=" + event.getRegainReason().name() + ", health=" + player.getHealth() + ", absorption=" + player.getAbsorptionAmount() + ", foodLevel=" + player.getFoodLevel());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        BukkitRunnable task;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Group group = this.playerGroups.get(playerId);
        if (group != null) {
            group.getLastActive().put(playerId, System.currentTimeMillis());
            this.saveGroups();
        }
        if (this.hasActivePvpTimer(player)) {
            UUID damagerId = this.lastDamager.get(playerId);
            Player damager = damagerId != null ? Bukkit.getPlayer((UUID)damagerId) : null;
            player.setHealth(0.0);
            String deathMessage = damager != null ? String.valueOf(ChatColor.RED) + player.getName() + " was killed by " + damager.getName() + " for logging out during combat." : String.valueOf(ChatColor.RED) + player.getName() + " was killed for logging out during combat.";
            Bukkit.broadcastMessage((String)deathMessage);
        }
        this.pvpTimers.remove(playerId);
        BossBar bar = this.pvpBossBars.remove(playerId);
        if (bar != null) {
            bar.removePlayer(player);
        }
        if ((task = this.pvpTimerTasks.remove(playerId)) != null) {
            task.cancel();
        }
        this.lastDamager.remove(playerId);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        BukkitRunnable task;
        Player player = event.getEntity();
        UUID playerId = player.getUniqueId();
        this.pvpTimers.remove(playerId);
        BossBar bar = this.pvpBossBars.remove(playerId);
        if (bar != null) {
            bar.removePlayer(player);
        }
        if ((task = this.pvpTimerTasks.remove(playerId)) != null) {
            task.cancel();
        }
        this.lastDamager.remove(playerId);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Group group = this.playerGroups.get(playerId);
        if (group != null) {
            group.getLastActive().put(playerId, System.currentTimeMillis());
            this.saveGroups();
        }
        if (this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            this.updateScoreboard(player, player.getLocation().getChunk());
            this.lastYaw.put(player.getUniqueId(), Float.valueOf(player.getLocation().getYaw()));
        }
        Chunk chunk = player.getLocation().getChunk();
        String zone = this.getZoneName(chunk, player);
        ChatColor color = this.getChunkColor(chunk, player);
        player.sendActionBar(String.valueOf(color) + zone);
        this.lastZone.put(player.getUniqueId(), zone);
    }

    private void startPvpTimer(final Player player) {
        if (!player.isOnline()) {
            return;
        }
        final UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.pvpTimers.put(playerId, currentTime + this.pvpTimerDuration);
        BukkitRunnable oldTask = this.pvpTimerTasks.remove(playerId);
        if (oldTask != null) {
            oldTask.cancel();
        }
        BossBar bar = this.pvpBossBars.get(playerId);
        int durationSeconds = (int)(this.pvpTimerDuration / 1000L);
        if (bar == null) {
            bar = Bukkit.createBossBar((String)(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + durationSeconds + "s"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
            bar.addPlayer(player);
            this.pvpBossBars.put(playerId, bar);
        } else {
            bar.setTitle(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + durationSeconds + "s");
            bar.setProgress(1.0);
        }
        BukkitRunnable newTask = new BukkitRunnable(this){
            private final long taskStartTime;
            final /* synthetic */ SimpleGroupsAndClaims this$0;
            {
                this.this$0 = this$0;
                this.taskStartTime = this.this$0.pvpTimers.get(playerId);
            }

            public void run() {
                Long timerEnd = this.this$0.pvpTimers.get(playerId);
                if (timerEnd == null || timerEnd != this.taskStartTime) {
                    this.cancel();
                    return;
                }
                if (System.currentTimeMillis() >= timerEnd) {
                    this.this$0.pvpTimers.remove(playerId);
                    this.this$0.pvpTimerTasks.remove(playerId);
                    BossBar bar = this.this$0.pvpBossBars.remove(playerId);
                    if (bar != null) {
                        bar.removePlayer(player);
                    }
                    if (player.isOnline()) {
                        player.sendActionBar(String.valueOf(ChatColor.GREEN) + "Your combat timer has expired. You can now safely log out.");
                    }
                    this.cancel();
                } else {
                    long remainingMillis = timerEnd - System.currentTimeMillis();
                    double progress = (double)remainingMillis / (double)this.this$0.pvpTimerDuration;
                    int remainingSeconds = (int)Math.ceil((double)remainingMillis / 1000.0);
                    BossBar bar = this.this$0.pvpBossBars.get(playerId);
                    if (bar != null) {
                        bar.setTitle(String.valueOf(ChatColor.RED) + "In Combat (Do not log out): " + remainingSeconds + "s");
                        bar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    }
                }
            }
        };
        this.pvpTimerTasks.put(playerId, newTask);
        newTask.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private boolean hasActivePvpTimer(Player player) {
        Long timerEnd = this.pvpTimers.get(player.getUniqueId());
        return timerEnd != null && System.currentTimeMillis() < timerEnd;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        Object prefix = "";
        if (playerGroup != null) {
            String status = playerGroup.getLeader().equals(player.getUniqueId()) ? String.valueOf(ChatColor.YELLOW) + "[L]" : (playerGroup.getModerators().contains(player.getUniqueId()) ? String.valueOf(ChatColor.BLUE) + "[M]" : String.valueOf(ChatColor.WHITE) + "[G]");
            ChatColor groupColor = ChatColor.GREEN;
            prefix = String.valueOf(groupColor) + "[" + playerGroup.getName() + "] " + status + String.valueOf(ChatColor.RESET) + " ";
        }
        event.setFormat((String)prefix + "%s: %s");
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        String lastZoneForPlayer;
        String currentZone;
        Player player = event.getPlayer();
        if (!this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) {
            return;
        }
        Chunk fromChunk = event.getFrom().getChunk();
        Chunk toChunk = event.getTo().getChunk();
        float yaw = player.getLocation().getYaw();
        float lastKnownYaw = this.lastYaw.getOrDefault(player.getUniqueId(), Float.valueOf(yaw)).floatValue();
        int rotation = Math.round(yaw / 90.0f) % 4;
        int lastRotation = Math.round(lastKnownYaw / 90.0f) % 4;
        if (rotation < 0) {
            rotation += 4;
        }
        if (lastRotation < 0) {
            lastRotation += 4;
        }
        if (!fromChunk.equals((Object)toChunk) || rotation != lastRotation) {
            this.updateScoreboard(player, toChunk);
            this.lastYaw.put(player.getUniqueId(), Float.valueOf(yaw));
        }
        if (!(currentZone = this.getZoneName(toChunk, player)).equals(lastZoneForPlayer = this.lastZone.getOrDefault(player.getUniqueId(), ""))) {
            ChatColor color = this.getChunkColor(toChunk, player);
            player.sendActionBar(String.valueOf(color) + currentZone);
            this.lastZone.put(player.getUniqueId(), currentZone);
        }
    }

    private void updateScoreboardsForChunk(Chunk chunk) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.mapToggled.getOrDefault(player.getUniqueId(), true).booleanValue()) continue;
            Chunk playerChunk = player.getLocation().getChunk();
            int dx = Math.abs(chunk.getX() - playerChunk.getX());
            int dz = Math.abs(chunk.getZ() - playerChunk.getZ());
            if (dx > 4 || dz > 4) continue;
            this.updateScoreboard(player, playerChunk);
        }
    }

    private void updateScoreboard(Player player, Chunk chunk) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        Scoreboard scoreboard = manager.getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective("claimMap", "dummy", String.valueOf(ChatColor.GOLD) + "Claim Map");
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        float yaw = player.getLocation().getYaw();
        int rotation = Math.round(yaw / 90.0f) % 4;
        if (rotation < 0) {
            rotation += 4;
        }
        int rowNum = 0;
        for (int dy = -4; dy <= 4; ++dy) {
            StringBuilder lineContent = new StringBuilder();
            int startX = rotation == 0 || rotation == 2 ? 4 : -4;
            int endX = rotation == 0 || rotation == 2 ? -4 : 4;
            int stepX = rotation == 0 || rotation == 2 ? -1 : 1;
            int dx = startX;
            while (rotation == 0 || rotation == 2 ? dx >= endX : dx <= endX) {
                int rotX;
                Chunk targetChunk = chunk.getWorld().getChunkAt(chunk.getX() + rotX, chunk.getZ() + (switch (rotation) {
                    case 0 -> {
                        rotX = dx;
                        yield -dy;
                    }
                    case 1 -> {
                        rotX = dy;
                        yield -dx;
                    }
                    case 2 -> {
                        rotX = -dx;
                        yield dy;
                    }
                    case 3 -> {
                        rotX = -dy;
                        yield dx;
                    }
                    default -> {
                        rotX = dx;
                        yield dy;
                    }
                }));
                ChatColor color = this.getChunkColor(targetChunk, player);
                String symbol = targetChunk.equals((Object)chunk) ? "\u2588" : ((targetChunk.getX() + targetChunk.getZ()) % 2 == 0 ? "\u2592" : "\u2593");
                lineContent.append(color).append(symbol);
                dx += stepX;
            }
            ChatColor unique = ChatColor.values()[rowNum % ChatColor.values().length];
            String entry = String.valueOf(unique) + String.valueOf(ChatColor.RESET) + lineContent.toString();
            Score score = objective.getScore(entry);
            score.setScore(8 - rowNum);
            ++rowNum;
        }
        player.setScoreboard(scoreboard);
    }

    private ChatColor getChunkColor(Chunk chunk, Player player) {
        if (this.isSpawnSafeZone(chunk)) {
            return ChatColor.BLUE;
        }
        if (this.isNeutralZone(chunk)) {
            return ChatColor.GOLD;
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (owningGroup == null) {
            return ChatColor.DARK_GRAY;
        }
        Group playerGroup = this.playerGroups.get(player.getUniqueId());
        if (playerGroup != null) {
            if (playerGroup == owningGroup) {
                return ChatColor.GREEN;
            }
            if (playerGroup.getAllies().contains(owningGroup)) {
                return ChatColor.LIGHT_PURPLE;
            }
        }
        return ChatColor.YELLOW;
    }

    private String getZoneName(Chunk chunk, Player player) {
        if (this.isSpawnSafeZone(chunk)) {
            return this.hasActivePvpTimer(player) ? "Entering Safe Zone (In Combat)" : "Entering Safe Zone";
        }
        if (this.isNeutralZone(chunk)) {
            return "Entering Neutral Zone";
        }
        Group owningGroup = this.claimedChunks.get(chunk);
        if (owningGroup == null) {
            return "Entering Wilderness";
        }
        return "Entering " + owningGroup.getName() + "'s land";
    }

    private boolean isSpawnSafeZone(Chunk chunk) {
        World world = chunk.getWorld();
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return false;
        }
        return this.spawnSafeZones.contains(chunk);
    }

    private boolean isNeutralZone(Chunk chunk) {
        World world = chunk.getWorld();
        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
            return false;
        }
        return this.neutralZones.contains(chunk);
    }

    private static class Group {
        private String name;
        private UUID leader;
        private Set<UUID> members;
        private Set<UUID> moderators;
        private Set<Chunk> claims;
        private long creationTime;
        private Map<UUID, Long> lastActive;
        private Set<Group> allies = new HashSet<Group>();

        public Group(String name, UUID leader, List<UUID> members, List<UUID> moderators, Set<Chunk> claims, long creationTime, Map<UUID, Long> lastActive) {
            this.name = name;
            this.leader = leader;
            this.members = new HashSet<UUID>(members);
            this.moderators = new HashSet<UUID>(moderators);
            this.claims = claims;
            this.creationTime = creationTime;
            this.lastActive = lastActive;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UUID getLeader() {
            return this.leader;
        }

        public void setLeader(UUID leader) {
            this.leader = leader;
        }

        public Set<UUID> getMembers() {
            return this.members;
        }

        public Set<UUID> getModerators() {
            return this.moderators;
        }

        public Set<Chunk> getClaims() {
            return this.claims;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public Map<UUID, Long> getLastActive() {
            return this.lastActive;
        }

        public Set<Group> getAllies() {
            return this.allies;
        }

        public void setAllies(Set<Group> allies) {
            this.allies = allies;
        }

        public int getMaxClaims() {
            long now = System.currentTimeMillis();
            long elapsedMillis = now - this.creationTime;
            long weeks = elapsedMillis / 10080000L;
            SimpleGroupsAndClaims plugin = (SimpleGroupsAndClaims)Bukkit.getPluginManager().getPlugin("SimpleGroupsAndClaims");
            return plugin.startingClaims + (int)(weeks * (long)plugin.claimGrowthPerWeek);
        }
    }
}

