/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    private final String pluginId = "SjDWdFjp";

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private String getUrl() {
        return "https://modrinth.com/plugin/SjDWdFjp/changelog";
    }

    @EventHandler(ignoreCancelled=true)
    public void onJoin(final PlayerJoinEvent event) {
        final String pluginName = this.plugin.getPluginMeta().getName();
        if (event.getPlayer().hasPermission(pluginName.toLowerCase() + ".updatenotifs")) {
            new BukkitRunnable(){

                public void run() {
                    String current = UpdateChecker.this.plugin.getPluginMeta().getVersion();
                    String latest = UpdateChecker.this.getLatestVersion();
                    if (latest == null) {
                        return;
                    }
                    if (!current.equals(latest)) {
                        event.getPlayer().sendMessage(((TextComponent)((TextComponent)Component.text((String)("An update is available for " + pluginName + "! "), (TextColor)NamedTextColor.YELLOW).append((Component)Component.text((String)("(" + current + " \u2192 " + latest + ")"), (TextColor)NamedTextColor.GOLD))).appendNewline()).append(Component.text((String)UpdateChecker.this.getUrl(), (TextColor)NamedTextColor.DARK_AQUA).clickEvent(ClickEvent.openUrl((String)UpdateChecker.this.getUrl()))));
                    }
                }
            }.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    @Nullable
    public String getLatestVersion() {
        try {
            InputStream url = new URI("https://api.modrinth.com/v2/project/SjDWdFjp/version").toURL().openStream();
            JSONObject response = new JSONArray(new String(url.readAllBytes(), StandardCharsets.UTF_8)).getJSONObject(0);
            url.close();
            return response.getString("version_number");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void logUpdate(String current, String latest) {
        String pluginName = this.plugin.getPluginMeta().getName();
        this.plugin.getLogger().warning("An update is available for " + pluginName + "! (" + current + " \u2192 " + latest + ")");
        this.plugin.getLogger().warning(this.getUrl());
    }
}

