/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.shaded.bstats.charts.SimplePie;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MetricsUtils {
    private final JavaPlugin plugin = EntityClearer.getInstance();

    public void send() {
        int interval = this.plugin.getConfig().getInt("global-interval");
        String parsedInterval = this.getInterval(interval);
        EntityClearer.getInstance().getMetrics().addCustomChart(new SimplePie("interval", () -> parsedInterval));
        String sound = this.plugin.getConfig().getString("sound");
        EntityClearer.getInstance().getMetrics().addCustomChart(new SimplePie("sound", () -> sound));
        String tpsEnabled = this.plugin.getConfig().getBoolean("low-tps.enabled") ? "Enabled" : "Disabled";
        EntityClearer.getInstance().getMetrics().addCustomChart(new SimplePie("low_tps_check", () -> tpsEnabled));
        String nearbyEnabled = this.plugin.getConfig().getBoolean("nearby-entities.enabled") ? "Enabled" : "Disabled";
        EntityClearer.getInstance().getMetrics().addCustomChart(new SimplePie("nearby_entities_check", () -> nearbyEnabled));
        String mmEnabled = EntityClearer.getInstance().getMythicPlugin() != null ? "Yes" : "No";
        EntityClearer.getInstance().getMetrics().addCustomChart(new SimplePie("mythicmobs", () -> mmEnabled));
    }

    @NotNull
    private String getInterval(int interval) {
        String parsedInterval = interval <= 0 ? "Disabled" : (interval <= 10 ? "1-10 Minutes" : (interval <= 30 ? "11-30 Minutes" : (interval < 60 ? "31-59 Minutes" : (interval < 120 ? "1-2 Hours" : (interval < 240 ? "2-4 Hours" : (interval < 480 ? "4-8 Hours" : (interval < 720 ? "8-12 Hours" : (interval < 1440 ? "12-24 Hours" : "24+ Hours"))))))));
        return parsedInterval;
    }
}

