/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.silverstonemc.entityclearer.EntityClearer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.json.JSONObject;

public class LogDebug {
    public static boolean debugActive;
    public static FileWriter debugFile;
    public static Long fileId;

    public void debug(Level level, String worldName, String message) {
        if (!debugActive) {
            return;
        }
        if (((String)(worldName = ((String)worldName).toUpperCase() + ": ")).equals(": ")) {
            worldName = "";
        }
        EntityClearer.getInstance().getLogger().log(level, (String)worldName + message);
        try {
            debugFile.write((String)worldName + message + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void error(String worldName, String message) {
        worldName = worldName.toUpperCase();
        for (Player players : Bukkit.getOnlinePlayers()) {
            if (!players.hasPermission("entityclearer.notify")) continue;
            players.sendMessage((Component)Component.text((String)("[EntityClearer] " + worldName + ": " + message), (TextColor)NamedTextColor.RED));
        }
        this.debug(Level.SEVERE, worldName, message);
    }

    public void upload(final File file) {
        EntityClearer.getInstance().getLogger().log(Level.INFO, "Uploading debug dump...");
        new BukkitRunnable(){

            public void run() {
                try {
                    URL url = new URI("https://api.pastes.dev/post").toURL();
                    URLConnection con = url.openConnection();
                    HttpURLConnection http = (HttpURLConnection)con;
                    http.setRequestMethod("POST");
                    http.setDoInput(true);
                    http.setDoOutput(true);
                    String fileContent = Files.readString(file.toPath());
                    ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                    try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteOutputStream);){
                        gzipOutputStream.write(fileContent.getBytes(StandardCharsets.UTF_8));
                    }
                    byte[] out = byteOutputStream.toByteArray();
                    int length = out.length;
                    http.setFixedLengthStreamingMode(length);
                    http.setRequestProperty("Content-Type", "text/yaml");
                    http.setRequestProperty("Content-Encoding", "gzip");
                    http.setRequestProperty("User-Agent", "EntityClearer Debug Dump");
                    http.connect();
                    try (OutputStream os = http.getOutputStream();){
                        os.write(out);
                    }
                    InputStream input = http.getInputStream();
                    JSONObject returnedText = new JSONObject(new String(input.readAllBytes(), StandardCharsets.UTF_8));
                    input.close();
                    if (http.getResponseCode() == 201) {
                        String key = returnedText.getString("key");
                        String link = "https://pastes.dev/" + key;
                        this.dumpLink(link);
                    } else if (returnedText.getString("status").equals("error")) {
                        LogDebug.this.error("SERVER", returnedText.getString("error") + "\n" + returnedText.getString("message"));
                    }
                }
                catch (Exception e) {
                    LogDebug.this.error("SERVER", "An error occurred while uploading the debug dump! (" + e.getMessage() + ")");
                    e.printStackTrace();
                }
            }

            private void dumpLink(String link) {
                for (Player players : Bukkit.getOnlinePlayers()) {
                    if (!players.hasPermission("entityclearer.notify")) continue;
                    players.sendMessage(Component.text((String)"[EntityClearer] SERVER: The debug dump can be found at ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)link, (TextColor)NamedTextColor.AQUA).clickEvent(ClickEvent.openUrl((String)link))));
                }
                EntityClearer.getInstance().getLogger().log(Level.INFO, "The debug dump can be found at " + link);
            }
        }.runTaskAsynchronously((Plugin)EntityClearer.getInstance());
    }
}

