/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import java.util.HashMap;
import java.util.Map;
import net.silverstonemc.entityclearer.Countdown;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.utils.ConfigUtils;
import net.silverstonemc.entityclearer.utils.LogDebug;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class KillTimer {
    public static final Map<String, BukkitTask> savedTimeTillKillTasks = new HashMap<String, BukkitTask>();
    public static final Map<String, BukkitTask> savedStartCountdowns = new HashMap<String, BukkitTask>();
    public static final HashMap<String, Long> nextKillTask = new HashMap();
    private final JavaPlugin plugin = EntityClearer.getInstance();

    public void start() {
        for (final World world : new ConfigUtils().getWorlds("worlds")) {
            final String worldName = world.getName();
            String worldConfigName = ConfigUtils.isAll ? "ALL" : worldName;
            int interval = this.plugin.getConfig().getInt("worlds." + worldConfigName + ".interval");
            if (interval <= -1) {
                interval = this.plugin.getConfig().getInt("global-interval");
            }
            if (interval == 0) {
                nextKillTask.put(worldName, -1L);
                continue;
            }
            long countdownLength = new Countdown().getCountdownSorted().getFirst().intValue();
            long delay = (long)(interval *= 60) - countdownLength;
            if (delay < 0L) {
                new LogDebug().error(worldName, "The interval is set to a value less than the highest countdown time!");
                nextKillTask.put(worldName, -1L);
                continue;
            }
            if (EntityClearer.getInstance().getPlaceholderAPI() != null) {
                final int finalInterval = interval;
                savedTimeTillKillTasks.put(worldName, new BukkitRunnable(this){

                    public void run() {
                        nextKillTask.put(worldName, System.currentTimeMillis() + (long)(finalInterval + 1) * 1000L);
                    }
                }.runTaskTimer((Plugin)this.plugin, 0L, (long)interval * 20L));
            }
            savedStartCountdowns.put(worldName, new BukkitRunnable(this){

                public void run() {
                    new Countdown().countdown(world);
                }
            }.runTaskTimer((Plugin)this.plugin, delay * 20L + 10L, (long)interval * 20L + 20L));
        }
    }
}

