/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import java.util.logging.Level;
import net.silverstonemc.entityclearer.utils.LogDebug;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.Nullable;

public class EntityData {
    private EntityType entityType;
    private String mythicMobType;
    private boolean includeNamed;
    private boolean includeOccupied;

    public EntityData(String entityType, String worldName) {
        LogDebug debug = new LogDebug();
        entityType = entityType.toUpperCase();
        if (entityType.contains("-NAMED")) {
            this.includeNamed = true;
            entityType = entityType.replace("-NAMED", "");
        }
        if (entityType.contains("-OCCUPIED")) {
            this.includeOccupied = true;
            entityType = entityType.replace("-OCCUPIED", "");
        }
        if (entityType.startsWith("MYTHICMOB:")) {
            this.mythicMobType = entityType.replace("MYTHICMOB:", "");
            entityType = null;
        }
        if (entityType != null) {
            try {
                this.entityType = EntityType.valueOf((String)entityType);
            }
            catch (IllegalArgumentException e) {
                debug.error(worldName, "Couldn't find the entity type \"" + entityType + "\"! Please double check your config.");
                if (LogDebug.debugActive) {
                    debug.debug(Level.SEVERE, worldName, e.toString());
                    for (StackTraceElement ste : e.getStackTrace()) {
                        debug.debug(Level.SEVERE, worldName, ste.toString());
                    }
                }
                e.printStackTrace();
            }
        }
        debug.debug(Level.INFO, worldName, "Entity " + String.valueOf(this.entityType != null ? this.entityType : this.mythicMobType) + " is specified with the following properties:");
        debug.debug(Level.INFO, worldName, " Include named: " + this.includeNamed);
        debug.debug(Level.INFO, worldName, " Include occupied: " + this.includeOccupied);
        debug.debug(Level.INFO, worldName, " MythicMob: " + (this.mythicMobType != null));
    }

    @Nullable
    public EntityType getType() {
        return this.entityType;
    }

    @Nullable
    public String getMythicMobType() {
        return this.mythicMobType;
    }

    public boolean includeNamed() {
        return this.includeNamed;
    }

    public boolean includeOccupied() {
        return this.includeOccupied;
    }
}

