/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.silverstonemc.entityclearer.utils.LogDebug;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public class ChecksumChecker
implements Listener {
    private final JavaPlugin plugin;
    private static boolean checksumDiffers;
    private final String msg1 = "The checksum of this plugin's jar file does not match the official one!";
    private final String msg2 = "Unless you're modifying the plugin, chances are a jar you downloaded is malware!";
    private final String msg3 = "Please re-download the plugin from the official sources: https://modrinth.com/project/SjDWdFjp";
    private final String msg4 = "If you need additional help, please reach out using the Discord server on the linked Modrinth page ^";
    private final String msg5 = "If this message appears even after re-downloading, some other plugin or your server jar may be compromised, injecting its code into this one!";

    public ChecksumChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        final String pluginName = this.plugin.getPluginMeta().getName();
        if (checksumDiffers && event.getPlayer().hasPermission(pluginName.toLowerCase() + ".notify")) {
            new BukkitRunnable(this){

                public void run() {
                    LogDebug debug = new LogDebug();
                    debug.error("SERVER", "The checksum of this plugin's jar file does not match the official one!");
                    debug.error("SERVER", "Unless you're modifying the plugin, chances are a jar you downloaded is malware!");
                    debug.error("SERVER", "Please re-download the plugin from the official sources: https://modrinth.com/project/SjDWdFjp" + pluginName);
                    debug.error("SERVER", "If you need additional help, please reach out using the Discord server on the linked Modrinth page ^");
                    debug.error("SERVER", "If this message appears even after re-downloading, some other plugin or your server jar may be compromised, injecting its code into this one!");
                }
            }.runTaskLater((Plugin)this.plugin, 20L);
        }
    }

    public void scan(final File pluginJar) {
        new BukkitRunnable(){

            public void run() {
                String version = ChecksumChecker.this.plugin.getPluginMeta().getVersion();
                String realChecksum = this.getOnlineChecksum(version);
                if (realChecksum == null) {
                    ChecksumChecker.this.plugin.getLogger().severe("Failed to get checksum for version " + version + " - custom version?");
                    return;
                }
                try {
                    String fileName = Paths.get(pluginJar.getPath(), new String[0]).getFileName().toString();
                    byte[] data = Files.readAllBytes(ChecksumChecker.this.plugin.getDataFolder().toPath().getParent().resolve(fileName));
                    byte[] hash = MessageDigest.getInstance("MD5").digest(data);
                    StringBuilder ownChecksum = new StringBuilder();
                    for (byte b : hash) {
                        ownChecksum.append(String.format("%02x", b));
                    }
                    if (!ownChecksum.toString().equalsIgnoreCase(realChecksum)) {
                        checksumDiffers = true;
                        ChecksumChecker.this.plugin.getLogger().severe("The checksum of this plugin's jar file does not match the official one!");
                        ChecksumChecker.this.plugin.getLogger().severe("Unless you're modifying the plugin, chances are a jar you downloaded is malware!");
                        ChecksumChecker.this.plugin.getLogger().severe("Please re-download the plugin from the official sources: https://modrinth.com/project/SjDWdFjp");
                        ChecksumChecker.this.plugin.getLogger().severe("If you need additional help, please reach out using the Discord server on the linked Modrinth page ^");
                        ChecksumChecker.this.plugin.getLogger().severe("If this message appears even after re-downloading, some other plugin or your server jar may be compromised, injecting its code into this one!");
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }

            @Nullable
            private String getOnlineChecksum(String version) {
                String pluginName = ChecksumChecker.this.plugin.getPluginMeta().getName();
                try {
                    InputStream url = new URI("https://raw.githubusercontent.com/SilverstoneMC/" + pluginName + "/main/checksums.json").toURL().openStream();
                    JSONObject response = new JSONObject(new String(url.readAllBytes(), StandardCharsets.UTF_8));
                    url.close();
                    if (!response.has(version)) {
                        return null;
                    }
                    return response.getString(version);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

