/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.silverstonemc.entityclearer.ClearTask;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.utils.ConfigUtils;
import net.silverstonemc.entityclearer.utils.LogDebug;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class TpsMonitoring {
    public static boolean tpsTimerRan;
    public static BukkitTask savedTpsTask;
    public static final List<Integer> tickList;
    private final JavaPlugin plugin = EntityClearer.getInstance();

    public void tpsTimer(int delay) {
        this.plugin.getLogger().info("TPS monitoring activated.");
        BukkitRunnable taskTimer = new BukkitRunnable(){

            public void run() {
                if (tpsTimerRan) {
                    return;
                }
                final long now = System.currentTimeMillis();
                BukkitRunnable countTicks = new BukkitRunnable(){
                    int ticks;

                    public void run() {
                        ++this.ticks;
                        if (now + 1000L <= System.currentTimeMillis()) {
                            this.cancel();
                            this.averageTPS(this.ticks);
                        }
                    }

                    private void averageTPS(int tps) {
                        tickList.add(tps);
                        if (tickList.size() <= 10) {
                            return;
                        }
                        tickList.removeFirst();
                        int sum = 0;
                        for (int x : tickList) {
                            sum += x;
                        }
                        double average = (double)sum / (double)tickList.size();
                        TpsMonitoring.this.tpsLow(average);
                    }
                };
                countTicks.runTaskTimer((Plugin)TpsMonitoring.this.plugin, 0L, 1L);
            }
        };
        savedTpsTask = taskTimer.runTaskTimerAsynchronously((Plugin)this.plugin, (long)delay, 20L);
    }

    private void tpsLow(double tps) {
        if (!(tps < (double)this.plugin.getConfig().getInt("low-tps.threshold"))) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("low-tps.chat")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("entityclearer.lowtps")) continue;
                player.sendMessage(MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("low-tps.chat-message"), (TagResolver)Placeholder.unparsed((String)"tps", (String)String.valueOf(tps))));
            }
        }
        String path = "worlds";
        boolean tpsList = this.plugin.getConfig().getBoolean("low-tps.separate-entity-list");
        if (tpsList) {
            new LogDebug().debug(Level.INFO, "", "Separate entity list enabled!");
            path = "low-tps.worlds";
        }
        new ClearTask().removeEntitiesPreTask(new ConfigUtils().getWorlds(path), tpsList, true);
        tpsTimerRan = true;
        tickList.clear();
        BukkitRunnable resetTimerRan = new BukkitRunnable(this){

            public void run() {
                tpsTimerRan = false;
            }
        };
        resetTimerRan.runTaskLaterAsynchronously((Plugin)this.plugin, 1800L);
    }

    static {
        tickList = new ArrayList<Integer>();
    }
}

