/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.utils.KillTimer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiHook
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "entityclearer";
    }

    @NotNull
    public String getAuthor() {
        return "JasonHorkles";
    }

    @NotNull
    public String getVersion() {
        return EntityClearer.getInstance().getPluginMeta().getVersion();
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public List<String> getPlaceholders() {
        return List.of("remaining_minutes_<world>", "remaining_seconds_<world>", "remaining_seconds_left_<world>");
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.startsWith("remaining_minutes_")) {
            String worldName = params.replace("remaining_minutes_", "");
            String returnReason = this.returnReason(worldName);
            if (returnReason != null) {
                return returnReason;
            }
            return String.valueOf((KillTimer.nextKillTask.get(worldName) - System.currentTimeMillis()) / 60000L);
        }
        if (params.startsWith("remaining_seconds_left_")) {
            String worldName = params.replace("remaining_seconds_left_", "");
            String returnReason = this.returnReason(worldName);
            if (returnReason != null) {
                return returnReason;
            }
            int seconds = (int)((KillTimer.nextKillTask.get(worldName) - System.currentTimeMillis()) / 1000L);
            return String.valueOf(seconds %= 60);
        }
        if (params.startsWith("remaining_seconds_")) {
            String worldName = params.replace("remaining_seconds_", "");
            String returnReason = this.returnReason(worldName);
            if (returnReason != null) {
                return returnReason;
            }
            return String.valueOf((KillTimer.nextKillTask.get(worldName) - System.currentTimeMillis()) / 1000L);
        }
        return null;
    }

    @Nullable
    private String returnReason(String worldName) {
        if (Bukkit.getWorld((String)worldName) == null) {
            return "UNKNOWN WORLD";
        }
        if (!KillTimer.nextKillTask.containsKey(worldName)) {
            return "NO TASK FOR WORLD (UNDEFINED OR DIFFERING CAPS)";
        }
        if (KillTimer.nextKillTask.get(worldName) == -1L) {
            return "DISABLED (INTERVAL SET TO -1)";
        }
        return null;
    }
}

