/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import io.lumine.mythic.api.MythicPlugin;
import java.util.logging.Level;
import net.silverstonemc.entityclearer.Commands;
import net.silverstonemc.entityclearer.PapiHook;
import net.silverstonemc.entityclearer.ReloadEvent;
import net.silverstonemc.entityclearer.TabComplete;
import net.silverstonemc.entityclearer.TpsMonitoring;
import net.silverstonemc.entityclearer.shaded.bstats.bukkit.Metrics;
import net.silverstonemc.entityclearer.utils.ChecksumChecker;
import net.silverstonemc.entityclearer.utils.KillTimer;
import net.silverstonemc.entityclearer.utils.MetricsUtils;
import net.silverstonemc.entityclearer.utils.TestConfigUtils;
import net.silverstonemc.entityclearer.utils.UpdateChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EntityClearer
extends JavaPlugin
implements Listener {
    public static boolean testing;
    public static TestConfigUtils.TestType testType;
    private Metrics metrics;
    private MythicPlugin mythicPlugin;
    private Plugin placeholderAPI;
    private static EntityClearer instance;

    public void onEnable() {
        instance = this;
        if (testing) {
            new TestConfigUtils().initConfig(testType);
        }
        if (!testing) {
            new ChecksumChecker(this).scan(this.getFile());
        }
        this.mythicPlugin = (MythicPlugin)this.getServer().getPluginManager().getPlugin("MythicMobs");
        if (this.mythicPlugin != null) {
            this.getLogger().log(Level.INFO, "Enabled MythicMobs hook!");
        }
        this.placeholderAPI = this.getServer().getPluginManager().getPlugin("PlaceholderAPI");
        if (this.placeholderAPI != null) {
            new PapiHook().register();
            this.getLogger().log(Level.INFO, "Enabled PlaceholderAPI hook!");
        }
        if (!testing) {
            this.metrics = new Metrics((Plugin)this, 10915);
            new MetricsUtils().send();
        }
        this.saveDefaultConfig();
        this.getCommand("entityclearer").setExecutor((CommandExecutor)new Commands());
        this.getCommand("entityclearer").setTabCompleter((TabCompleter)new TabComplete());
        this.getServer().getPluginManager().registerEvents((Listener)new ChecksumChecker(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ReloadEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new UpdateChecker(this), (Plugin)this);
        new BukkitRunnable(){

            public void run() {
                new KillTimer().start();
                if (EntityClearer.this.getConfig().getBoolean("low-tps.enabled")) {
                    new TpsMonitoring().tpsTimer(200);
                }
            }
        }.runTaskLater((Plugin)this, 3L);
        if (!testing) {
            new BukkitRunnable(this){

                public void run() {
                    String latest = new UpdateChecker(instance).getLatestVersion();
                    String current = instance.getPluginMeta().getVersion();
                    if (latest == null) {
                        return;
                    }
                    if (!current.equals(latest)) {
                        new UpdateChecker(instance).logUpdate(current, latest);
                    }
                }
            }.runTaskAsynchronously((Plugin)this);
        }
    }

    public static EntityClearer getInstance() {
        return instance;
    }

    public MythicPlugin getMythicPlugin() {
        return this.mythicPlugin;
    }

    public Plugin getPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

