/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.silverstonemc.entityclearer.ClearTask;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.utils.ConfigUtils;
import net.silverstonemc.entityclearer.utils.LogDebug;
import net.silverstonemc.entityclearer.utils.OnlinePlayers;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Countdown {
    public static final Map<String, BukkitTask> savedCountingDowns = new HashMap<String, BukkitTask>();
    private final JavaPlugin plugin = EntityClearer.getInstance();

    public void countdown(final World world) {
        final String worldName = world.getName();
        final List<Integer> times = this.getCountdownSorted();
        int initialTime = times.getFirst();
        final int[] timeLeft = new int[]{initialTime};
        savedCountingDowns.put(worldName, new BukkitRunnable(){

            public void run() {
                if (timeLeft[0] <= 0) {
                    new ClearTask().removeEntitiesPreTask(new ArrayList<World>(Collections.singletonList(world)), false, false);
                    this.cancel();
                    savedCountingDowns.remove(worldName);
                    return;
                }
                if (!times.isEmpty() && timeLeft[0] <= (Integer)times.getFirst()) {
                    Countdown.this.message(timeLeft[0], world);
                    times.removeFirst();
                }
                timeLeft[0] = timeLeft[0] - 1;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L));
    }

    public List<Integer> getCountdownSorted() {
        List times = this.plugin.getConfig().getIntegerList("warning-messages");
        times.sort(Comparator.reverseOrder());
        return times;
    }

    public void message(int timeLeft, World world) {
        String worldConfigName = ConfigUtils.isAll ? "ALL" : world.getName();
        boolean notEnoughPlayers = (Boolean)new OnlinePlayers().isNotEnough(world, worldConfigName)[0];
        if (notEnoughPlayers) {
            return;
        }
        try {
            StringBuilder time = new StringBuilder(7);
            int divideBy = 1;
            if (timeLeft >= 60) {
                divideBy = 60;
                time.append(this.plugin.getConfig().getString("messages.timeleft-minute"));
            } else {
                time.append(this.plugin.getConfig().getString("messages.timeleft-second"));
            }
            if (timeLeft / divideBy != 1) {
                time.append(this.plugin.getConfig().getString("messages.append-s-text"));
            }
            String actualTimeLeft = String.valueOf(timeLeft / divideBy);
            TagResolver[] placeholders = new TagResolver[]{Placeholder.unparsed((String)"timeleft", (String)actualTimeLeft), Placeholder.unparsed((String)"time", (String)String.valueOf(time))};
            for (Player player : world.getPlayers()) {
                this.sendActionBar(player, placeholders);
                this.sendChat(player, placeholders);
                this.sendTitle(player, placeholders);
                this.playSound(world, player);
            }
            this.sendLog(world, placeholders);
        }
        catch (NullPointerException e) {
            LogDebug debug = new LogDebug();
            debug.error(world.getName(), "Something went wrong sending messages! Is your config outdated?");
            debug.error(world.getName(), "Please see https://github.com/SilverstoneMC/EntityClearer/blob/main/src/main/resources/config.yml for the most recent config.");
            e.printStackTrace();
        }
    }

    private void sendActionBar(Player player, TagResolver[] placeholders) {
        if (!player.hasPermission("entityclearer.removalnotifs.actionbar")) {
            return;
        }
        if (this.plugin.getConfig().getString("messages.actionbar-message").isBlank()) {
            return;
        }
        player.sendActionBar(MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("messages.actionbar-message"), placeholders));
    }

    private void sendChat(Player player, TagResolver[] placeholders) {
        if (!player.hasPermission("entityclearer.removalnotifs.chat")) {
            return;
        }
        if (this.plugin.getConfig().getString("messages.chat-message").isBlank()) {
            return;
        }
        player.sendMessage(MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("messages.chat-message"), placeholders));
    }

    private void sendTitle(Player player, TagResolver[] placeholders) {
        if (!player.hasPermission("entityclearer.removalnotifs.title")) {
            return;
        }
        if (this.plugin.getConfig().getString("messages.title-message").isBlank() && this.plugin.getConfig().getString("messages.subtitle-message").isBlank()) {
            return;
        }
        Component title = MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("messages.title-message"), placeholders);
        Component subtitle = MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString("messages.subtitle-message"), placeholders);
        Title fullTitle = Title.title((Component)title, (Component)subtitle);
        player.showTitle(fullTitle);
    }

    private void playSound(World world, Player player) {
        if (!player.hasPermission("entityclearer.removalnotifs.sound")) {
            return;
        }
        try {
            player.playSound(player.getLocation(), "minecraft:" + this.plugin.getConfig().getString("sound"), SoundCategory.MASTER, 1.0f, Float.parseFloat(this.plugin.getConfig().getString("countdown-pitch")));
        }
        catch (NumberFormatException e) {
            new LogDebug().error(world.getName(), "Countdown pitch '" + this.plugin.getConfig().getString("countdown-pitch") + "' is not a valid number!");
            e.printStackTrace();
        }
    }

    private void sendLog(World world, TagResolver[] placeholders) {
        if (this.plugin.getConfig().getString("messages.log-message").isBlank()) {
            return;
        }
        String worldName = world.getName().toUpperCase() + ": ";
        Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize(worldName + this.plugin.getConfig().getString("messages.log-message"), placeholders));
    }
}

