/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.silverstonemc.entityclearer.ClearTask;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.TpsMonitoring;
import net.silverstonemc.entityclearer.utils.CancelTasks;
import net.silverstonemc.entityclearer.utils.ConfigUtils;
import net.silverstonemc.entityclearer.utils.KillTimer;
import net.silverstonemc.entityclearer.utils.LogDebug;
import net.silverstonemc.entityclearer.utils.MetricsUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Commands
implements CommandExecutor {
    private final JavaPlugin plugin = EntityClearer.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "reload": {
                    this.reload(sender);
                    break;
                }
                case "debug": {
                    this.debug(sender);
                    break;
                }
                case "clearnow": {
                    this.clearnow(sender);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void reload(CommandSender sender) {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        if (TpsMonitoring.savedTpsTask != null && !TpsMonitoring.savedTpsTask.isCancelled()) {
            TpsMonitoring.savedTpsTask.cancel();
        }
        TpsMonitoring.tickList.clear();
        new CancelTasks().all();
        if (this.plugin.getConfig().getBoolean("low-tps.enabled")) {
            new TpsMonitoring().tpsTimer(0);
        }
        TpsMonitoring.tpsTimerRan = false;
        LogDebug.debugActive = false;
        new KillTimer().start();
        new MetricsUtils().send();
        sender.sendMessage((Component)Component.text((String)"EntityClearer reloaded!", (TextColor)NamedTextColor.GREEN));
    }

    private void debug(CommandSender sender) {
        Plugin papi;
        boolean papiEnabled;
        LogDebug debug = new LogDebug();
        if (LogDebug.debugActive) {
            sender.sendMessage((Component)Component.text((String)"Debug is already active!", (TextColor)NamedTextColor.RED));
            return;
        }
        sender.sendMessage((Component)Component.text((String)"Activating debug... See console for more details.", (TextColor)NamedTextColor.YELLOW));
        try {
            Path path = Path.of(this.plugin.getDataFolder().getPath(), "debug");
            Files.createDirectories(path, new FileAttribute[0]);
            LogDebug.fileId = System.currentTimeMillis();
            File file = new File(path.toFile(), "debug-" + LogDebug.fileId + ".yml");
            if (file.createNewFile()) {
                LogDebug.debugFile = new FileWriter(file, StandardCharsets.UTF_8, true);
            } else {
                sender.sendMessage((Component)Component.text((String)"Failed to create debug file! Check console for the debug output.", (TextColor)NamedTextColor.RED));
            }
        }
        catch (IOException e) {
            debug.error("SERVER", "Failed to create debug file! Check console for more information...");
            e.printStackTrace();
            return;
        }
        LogDebug.debugActive = true;
        this.plugin.getLogger().info("Dumping config into debug file...");
        try {
            Scanner scanner = new Scanner(new File(this.plugin.getDataFolder(), "config.yml"), StandardCharsets.UTF_8);
            while (scanner.hasNextLine()) {
                LogDebug.debugFile.write(scanner.nextLine() + "\n");
            }
            scanner.close();
            LogDebug.debugFile.write("\n\n\n###############################################\n#              END OF CONFIG DUMP             #\n###############################################\n\n\n\n");
            this.plugin.getLogger().info("Config file dumped!");
        }
        catch (IOException e) {
            debug.error("SERVER", "Failed to dump config file! Check console for more information...");
            e.printStackTrace();
        }
        debug.debug(Level.INFO, "", "");
        debug.debug(Level.INFO, "", "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        debug.debug(Level.INFO, "", "\u2551             INFORMATION              \u2551");
        debug.debug(Level.INFO, "", "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        debug.debug(Level.INFO, "", "Plugin version: " + this.plugin.getPluginMeta().getVersion());
        debug.debug(Level.INFO, "", "Server version: " + Bukkit.getName() + " " + Bukkit.getVersion());
        debug.debug(Level.INFO, "", "API version: " + Bukkit.getBukkitVersion());
        Plugin mmobs = (Plugin)EntityClearer.getInstance().getMythicPlugin();
        if (mmobs != null) {
            debug.debug(Level.INFO, "", "MythicMobs version: " + mmobs.getPluginMeta().getVersion());
        }
        boolean bl = papiEnabled = (papi = EntityClearer.getInstance().getPlaceholderAPI()) != null;
        if (papiEnabled) {
            debug.debug(Level.INFO, "", "PlaceholderAPI version: " + papi.getPluginMeta().getVersion());
        }
        debug.debug(Level.INFO, "", "Java version: " + System.getProperty("java.version"));
        debug.debug(Level.INFO, "", "Players online: " + Bukkit.getOnlinePlayers().size());
        debug.debug(Level.INFO, "", "Available world list: ");
        for (World world : Bukkit.getWorlds()) {
            debug.debug(Level.INFO, "", " " + world.getName());
            debug.debug(Level.INFO, "", "  Players: " + world.getPlayers().size());
            if (!papiEnabled) continue;
            String nextKillTask = KillTimer.nextKillTask.containsKey(world.getName()) ? (KillTimer.nextKillTask.get(world.getName()) - System.currentTimeMillis()) / 1000L + " seconds" : "null";
            debug.debug(Level.INFO, "", "  Next kill task: " + nextKillTask);
        }
        debug.debug(Level.INFO, "", "");
        new ClearTask().removeEntitiesPreTask(new ConfigUtils().getWorlds("worlds"), false, false);
    }

    private void clearnow(CommandSender sender) {
        sender.sendMessage((Component)Component.text((String)"Starting entity removal task...", (TextColor)NamedTextColor.YELLOW));
        new ClearTask().removeEntitiesPreTask(new ConfigUtils().getWorlds("worlds"), false, false);
    }
}

