/*
 * Decompiled with CFR 0.152.
 */
package net.silverstonemc.entityclearer;

import io.lumine.mythic.api.MythicPlugin;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import net.silverstonemc.entityclearer.EntityClearer;
import net.silverstonemc.entityclearer.utils.ConfigUtils;
import net.silverstonemc.entityclearer.utils.EntityData;
import net.silverstonemc.entityclearer.utils.LogDebug;
import net.silverstonemc.entityclearer.utils.OnlinePlayers;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class ClearTask {
    private final List<EntityData> entityDataList = new ArrayList<EntityData>();
    private final JavaPlugin plugin = EntityClearer.getInstance();
    private final MythicPlugin mythicPlugin = EntityClearer.getInstance().getMythicPlugin();
    private int removedEntities;
    private static boolean logCooldown;

    public void removeEntitiesPreTask(Iterable<World> worlds, boolean useTpsList, boolean tpsLow) {
        LogDebug debug = new LogDebug();
        debug.debug(Level.INFO, "", "");
        debug.debug(Level.INFO, "", "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        debug.debug(Level.INFO, "", "\u2551     REMOVE ENTITIES TASK STARTED     \u2551");
        debug.debug(Level.INFO, "", "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        if (this.mythicPlugin != null) {
            debug.debug(Level.INFO, "", "MythicMobs plugin found!");
        }
        this.removedEntities = 0;
        try {
            this.removeEntities(worlds, useTpsList, tpsLow);
        }
        catch (Error | Exception e) {
            debug.error("SERVER", "Something went wrong clearing entities! Is your config outdated?");
            if (LogDebug.debugActive) {
                debug.debug(Level.SEVERE, "", e.toString());
                for (StackTraceElement ste : e.getStackTrace()) {
                    debug.debug(Level.SEVERE, "", ste.toString());
                }
            }
            e.printStackTrace();
        }
    }

    private void removeEntities(Iterable<World> worlds, boolean useTpsList, boolean tpsLow) {
        LogDebug debug = new LogDebug();
        String path = "worlds";
        if (useTpsList) {
            path = "low-tps.worlds";
        }
        for (World world : worlds) {
            String worldName = world.getName();
            this.entityDataList.clear();
            debug.debug(Level.INFO, "", "");
            String worldConfigName = ConfigUtils.isAll ? "ALL" : worldName;
            Object[] notEnoughPlayers = new OnlinePlayers().isNotEnough(world, worldConfigName);
            if (((Boolean)notEnoughPlayers[0]).booleanValue()) {
                debug.debug(Level.WARNING, worldName, "Not enough players in the " + String.valueOf(notEnoughPlayers[1]) + "! Skipping...");
                continue;
            }
            List entityList = this.plugin.getConfig().getStringList(path + "." + worldConfigName + ".entities");
            if (entityList.isEmpty()) {
                debug.error(worldName, "No entities are set to be removed in the config!");
                continue;
            }
            for (String entityType : entityList) {
                this.entityDataList.add(new EntityData(entityType, worldName));
            }
            debug.debug(Level.INFO, "", "");
            debug.debug(Level.INFO, worldName, "Scanning world...");
            for (Entity entity : world.getEntities()) {
                ActiveMob mythicMob;
                EntityData entityData = this.matchEntityFromConfig(entity, worldName);
                if (entityData == null) continue;
                if (entityData.getMythicMobType() != null && (mythicMob = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId()).orElse(null)).getMobType().equalsIgnoreCase(entityData.getMythicMobType())) {
                    this.checkOccupied(entity, entityData, path, worldName);
                    continue;
                }
                if (entity.getType() == EntityType.ITEM) {
                    this.removeEntity(entity, worldName);
                    continue;
                }
                this.checkOccupied(entity, entityData, path, worldName);
            }
            TagResolver.Single removedPlaceholder = Placeholder.unparsed((String)"entities", (String)String.valueOf(this.removedEntities));
            for (Player player : world.getPlayers()) {
                this.sendActionBar(world, player, tpsLow, (TagResolver)removedPlaceholder);
                this.sendChat(world, player, tpsLow, (TagResolver)removedPlaceholder);
                this.sendTitle(world, player, tpsLow, (TagResolver)removedPlaceholder);
                this.playSound(world, player);
            }
            this.sendLog(world, tpsLow, (TagResolver)removedPlaceholder);
        }
        for (String command : this.plugin.getConfig().getStringList("commands")) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
        this.removeEntitiesPostTask();
    }

    @Nullable
    private EntityData matchEntityFromConfig(Entity entity, String worldName) {
        EntityData mythicEntityData;
        ActiveMob mythicMob;
        LogDebug debug = new LogDebug();
        if (this.mythicPlugin != null && (mythicMob = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId()).orElse(null)) != null && (mythicEntityData = (EntityData)this.entityDataList.stream().filter(entityData1 -> {
            if (entityData1.getMythicMobType() == null) {
                return false;
            }
            return entityData1.getMythicMobType().equalsIgnoreCase(mythicMob.getMobType());
        }).findFirst().orElse(null)) != null) {
            debug.debug(Level.INFO, worldName, "Entity " + mythicMob.getMobType() + " is a MythicMob that matches the config's!");
            return mythicEntityData;
        }
        EntityData entityData = this.entityDataList.stream().filter(entityData1 -> entityData1.getType() == entity.getType()).findFirst().orElse(null);
        if (entityData != null) {
            ActiveMob mythicMob2;
            if (this.mythicPlugin != null && (mythicMob2 = (ActiveMob)MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId()).orElse(null)) != null) {
                debug.debug(Level.WARNING, worldName, "Entity " + mythicMob2.getMobType() + " is a MythicMob not in the config! Skipping...");
                return null;
            }
            debug.debug(Level.INFO, worldName, "Entity " + String.valueOf(entity.getType()) + " matches the config's!");
            return entityData;
        }
        debug.debug(Level.WARNING, worldName, "Entity " + String.valueOf(entity.getType()) + " is not listed in the config!");
        return null;
    }

    private void checkOccupied(Entity entity, EntityData entityData, String path, String worldName) {
        if (!entityData.includeOccupied()) {
            for (Entity passenger : entity.getPassengers()) {
                if (passenger.getType() != EntityType.PLAYER) continue;
                new LogDebug().debug(Level.INFO, worldName, "Skipping entity " + String.valueOf(entity.getType()) + " because it is occupied!");
                return;
            }
        }
        this.checkNamed(entity, entityData, path, worldName);
    }

    private void checkNamed(Entity entity, EntityData entityData, String path, String worldName) {
        String entityType;
        LogDebug debug = new LogDebug();
        String string = entityType = entityData.getMythicMobType() != null ? "MythicMob" : "entity";
        if (entityData.includeNamed()) {
            this.checkSpawnReason(entity, path, worldName);
            return;
        }
        debug.debug(Level.INFO, worldName, "Removing " + entityType + " without a name only...");
        if (entity.getCustomName() == null) {
            debug.debug(Level.INFO, worldName, "The " + entityType + " " + String.valueOf(entity.getType()) + " doesn't have a custom name!");
            this.checkSpawnReason(entity, path, worldName);
        } else {
            debug.debug(Level.INFO, worldName, String.valueOf(entity.getType()) + " was skipped becuase it has a name: " + entity.getCustomName());
            debug.debug(Level.INFO, "", "");
        }
    }

    private void checkSpawnReason(Entity entity, String path, String worldName) {
        LogDebug debug = new LogDebug();
        if (!this.plugin.getConfig().getBoolean(path + "." + worldName + ".spawn-reason.enabled")) {
            debug.debug(Level.INFO, worldName, "Removing entities regardless of their spawn reason...");
            this.checkNearby(entity, worldName);
            return;
        }
        debug.debug(Level.INFO, worldName, "Only removing entities with a specific spawn reason...");
        try {
            ArrayList<String> spawnReasons = new ArrayList<String>();
            for (String spawnReason : this.plugin.getConfig().getStringList(path + "." + worldName + ".spawn-reason.reasons")) {
                spawnReasons.add(spawnReason.toUpperCase());
            }
            if (spawnReasons.contains(entity.getEntitySpawnReason().name())) {
                debug.debug(Level.INFO, worldName, String.valueOf(entity.getType()) + "'s spawn reason " + String.valueOf(entity.getEntitySpawnReason()) + " matches the config's!");
                this.checkNearby(entity, worldName);
            } else {
                debug.debug(Level.INFO, worldName, String.valueOf(entity.getType()) + "'s spawn reason " + entity.getEntitySpawnReason().name() + " doesn't match the config's! (" + String.valueOf(spawnReasons) + ")");
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            if (logCooldown) {
                return;
            }
            debug.error(worldName, "Unable to check for entity spawn reason! Are you not running Paper?");
            this.plugin.getLogger().warning("Please use Paper or its forks for this feature to work.");
            if (LogDebug.debugActive) {
                debug.debug(Level.SEVERE, worldName, e.toString());
                for (StackTraceElement ste : e.getStackTrace()) {
                    debug.debug(Level.SEVERE, worldName, ste.toString());
                }
            } else {
                e.printStackTrace();
            }
            logCooldown = true;
            BukkitRunnable cooldown = new BukkitRunnable(this){

                public void run() {
                    logCooldown = false;
                }
            };
            cooldown.runTaskLater((Plugin)this.plugin, 200L);
        }
    }

    private void checkNearby(Entity entity, String worldName) {
        LogDebug debug = new LogDebug();
        if (!this.plugin.getConfig().getBoolean("nearby-entities.enabled")) {
            debug.debug(Level.INFO, worldName, "Check nearby entities option disabled.");
            this.removeEntity(entity, worldName);
            return;
        }
        double x = this.plugin.getConfig().getDouble("nearby-entities.x");
        double y = this.plugin.getConfig().getDouble("nearby-entities.y");
        double z = this.plugin.getConfig().getDouble("nearby-entities.z");
        ArrayList nearbyEntities = new ArrayList(entity.getNearbyEntities(x, y, z));
        debug.debug(Level.INFO, worldName, "Found " + nearbyEntities.size() + " nearby entities!");
        if (this.plugin.getConfig().getBoolean("nearby-entities.only-count-from-list")) {
            debug.debug(Level.INFO, worldName, "However, only entities on the list should be counted...");
            for (Entity nearbyEntity : new ArrayList(nearbyEntities)) {
                EntityData nearbyEntityData = this.matchEntityFromConfig(nearbyEntity, worldName);
                if (nearbyEntityData != null) continue;
                nearbyEntities.remove(nearbyEntity);
                debug.debug(Level.INFO, worldName, "Nearby entity " + String.valueOf(nearbyEntity.getType()) + " was removed from the nearby entity list.");
            }
            debug.debug(Level.INFO, worldName, "Found " + nearbyEntities.size() + " nearby entities that were on the list.");
        }
        if (nearbyEntities.size() > this.plugin.getConfig().getInt("nearby-entities.count")) {
            this.removeEntity(entity, worldName);
        } else {
            debug.debug(Level.INFO, worldName, "Not enough entities nearby! Skipping...");
            debug.debug(Level.INFO, "", "");
        }
    }

    private void removeEntity(Entity entity, String worldName) {
        entity.remove();
        ++this.removedEntities;
        LogDebug debug = new LogDebug();
        debug.debug(Level.INFO, worldName, String.valueOf(entity.getType()) + " removed! Total removed is " + this.removedEntities + ".");
        debug.debug(Level.INFO, "", "");
    }

    private void removeEntitiesPostTask() {
        LogDebug debug = new LogDebug();
        debug.debug(Level.INFO, "", "");
        debug.debug(Level.INFO, "", "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
        debug.debug(Level.INFO, "", "\u2551           TASKS COMPLETED.           \u2551");
        debug.debug(Level.INFO, "", "\u2551      IF SUPPORT IS NEEDED, SEND      \u2551");
        debug.debug(Level.INFO, "", "\u2551     US THE LINK GIVEN IN CHAT AT     \u2551");
        debug.debug(Level.INFO, "", "\u2551     https://discord.gg/5XFBx8uZVN    \u2551");
        debug.debug(Level.INFO, "", "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        if (LogDebug.debugActive) {
            block4: {
                try {
                    LogDebug.debugFile.close();
                    Path path = Path.of(this.plugin.getDataFolder().getPath(), "debug");
                    File file = new File(path.toFile(), "debug-" + LogDebug.fileId + ".yml");
                    if (this.plugin.getConfig().getBoolean("disable-paste-upload")) break block4;
                    debug.upload(file);
                }
                catch (IOException e) {
                    debug.debug(Level.INFO, "", e.toString());
                    for (StackTraceElement ste : e.getStackTrace()) {
                        debug.debug(Level.INFO, "", ste.toString());
                    }
                }
            }
            LogDebug.debugActive = false;
            LogDebug.fileId = null;
        }
    }

    private void sendActionBar(World world, Player player, boolean tpsLow, TagResolver placeholder) {
        String path;
        if (!player.hasPermission("entityclearer.removalnotifs.actionbar")) {
            return;
        }
        String string = path = tpsLow ? "messages.actionbar-completed-low-tps-message" : "messages.actionbar-completed-message";
        if (this.plugin.getConfig().getString(path).isBlank()) {
            return;
        }
        new LogDebug().debug(Level.INFO, world.getName(), "Sending action bar to player " + player.getName() + " about " + this.removedEntities + " entities");
        player.sendActionBar(MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString(path), placeholder));
    }

    private void sendChat(World world, Player player, boolean tpsLow, TagResolver placeholder) {
        String path;
        if (!player.hasPermission("entityclearer.removalnotifs.chat")) {
            return;
        }
        String string = path = tpsLow ? "messages.chat-completed-low-tps-message" : "messages.chat-completed-message";
        if (this.plugin.getConfig().getString(path).isBlank()) {
            return;
        }
        new LogDebug().debug(Level.INFO, world.getName(), "Sending message to player " + player.getName() + " about " + this.removedEntities + " entities");
        player.sendMessage(MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString(path), placeholder));
    }

    private void sendTitle(World world, Player player, boolean tpsLow, TagResolver placeholder) {
        String subtitlePath;
        if (!player.hasPermission("entityclearer.removalnotifs.title")) {
            return;
        }
        String titlePath = tpsLow ? "messages.title-completed-low-tps-message" : "messages.title-completed-message";
        String string = subtitlePath = tpsLow ? "messages.subtitle-completed-low-tps-message" : "messages.subtitle-completed-message";
        if (this.plugin.getConfig().getString(titlePath).isBlank() && this.plugin.getConfig().getString(subtitlePath).isBlank()) {
            return;
        }
        new LogDebug().debug(Level.INFO, world.getName(), "Sending title to player " + player.getName() + " about " + this.removedEntities + " entities");
        Component title = MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString(titlePath), placeholder);
        Component subtitle = MiniMessage.miniMessage().deserialize(this.plugin.getConfig().getString(subtitlePath), placeholder);
        Title fullTitle = Title.title((Component)title, (Component)subtitle);
        player.showTitle(fullTitle);
    }

    private void playSound(World world, Player player) {
        if (!player.hasPermission("entityclearer.removalnotifs.sound")) {
            return;
        }
        LogDebug debug = new LogDebug();
        String worldName = world.getName();
        debug.debug(Level.INFO, worldName, "Playing sound " + this.plugin.getConfig().getString("sound") + " at player " + player.getName());
        try {
            player.playSound(player.getLocation(), "minecraft:" + this.plugin.getConfig().getString("sound"), SoundCategory.MASTER, 1.0f, Float.parseFloat(this.plugin.getConfig().getString("cleared-pitch")));
        }
        catch (NumberFormatException e) {
            debug.error(world.getName(), "Cleared pitch \"" + this.plugin.getConfig().getString("cleared-pitch") + "\" is not a number!");
            if (LogDebug.debugActive) {
                debug.debug(Level.SEVERE, worldName, e.toString());
                for (StackTraceElement ste : e.getStackTrace()) {
                    debug.debug(Level.SEVERE, worldName, ste.toString());
                }
            }
            e.printStackTrace();
        }
    }

    private void sendLog(World world, boolean tpsLow, TagResolver placeholder) {
        String worldName = world.getName().toUpperCase() + ": ";
        if (tpsLow) {
            if (this.plugin.getConfig().getString("messages.log-completed-low-tps-message").isBlank()) {
                return;
            }
            Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize(worldName + this.plugin.getConfig().getString("messages.log-completed-low-tps-message"), placeholder));
        } else if (!this.plugin.getConfig().getString("messages.log-completed-message").isBlank()) {
            Bukkit.getConsoleSender().sendMessage(MiniMessage.miniMessage().deserialize(worldName + this.plugin.getConfig().getString("messages.log-completed-message"), placeholder));
        }
    }
}

