/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.repository.StockMarketRepository;
import com.skyblockexp.ezshops.stock.StockHistoryManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class StockMarketManager {
    private final Map<String, Double> prices = new HashMap<String, Double>();
    private final Random random = new Random();
    private static final double BASE_PRICE = 100.0;
    private static final double MAX_CHANGE = 0.1;
    private StockMarketRepository stockMarketRepository;
    private final StockHistoryManager historyManager = new StockHistoryManager();
    private BukkitTask saveTask;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void enablePersistence(Plugin plugin, long saveIntervalTicks) {
        if (this.stockMarketRepository != null) {
            Map<String, Double> loaded = this.stockMarketRepository.loadPrices();
            this.lock.writeLock().lock();
            try {
                this.prices.clear();
                this.prices.putAll(loaded);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.saveTask = Bukkit.getScheduler().runTaskTimerAsynchronously(plugin, this::savePrices, saveIntervalTicks, saveIntervalTicks);
    }

    public void disablePersistence() {
        if (this.saveTask != null) {
            this.saveTask.cancel();
        }
        this.savePrices();
    }

    private void savePrices() {
        this.lock.readLock().lock();
        try {
            if (this.stockMarketRepository != null) {
                this.stockMarketRepository.savePrices(new HashMap<String, Double>(this.prices));
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getAllProductIds() {
        HashSet<String> allIds = new HashSet<String>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material mat = materialArray[n2];
            if (mat.isItem() && !mat.isAir()) {
                allIds.add(mat.name());
            }
            ++n2;
        }
        return allIds;
    }

    public double getPrice(String productId) {
        this.lock.readLock().lock();
        try {
            double d = this.prices.getOrDefault(productId, 100.0);
            return d;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setStockMarketRepository(StockMarketRepository repository) {
        this.stockMarketRepository = repository;
    }

    public void updatePrice(String productId, int demand) {
        if (this.stockMarketRepository != null && this.stockMarketRepository.isFrozen(productId)) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            double current = this.getPrice(productId);
            double change = (double)demand * 0.02 + (this.random.nextDouble() * 2.0 - 1.0) * 0.1;
            double newPrice = Math.max(1.0, current * (1.0 + change));
            this.prices.put(productId, newPrice);
            this.historyManager.recordPrice(productId, newPrice);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setPrice(String productId, double price) {
        double p = Math.max(1.0, price);
        this.lock.writeLock().lock();
        try {
            this.prices.put(productId, p);
            this.historyManager.recordPrice(productId, p);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public StockHistoryManager getHistoryManager() {
        return this.historyManager;
    }
}

