/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.repository.StockMarketRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class StockMarketFrozenStore {
    private final StockMarketRepository repository;

    public StockMarketFrozenStore(StockMarketRepository repository) {
        this.repository = repository;
        this.load();
    }

    public synchronized void load() {
        this.repository.load();
    }

    public synchronized void save() {
        this.repository.save();
    }

    public synchronized void freeze(String id, String by) {
        this.repository.freeze(id, by);
    }

    public synchronized void unfreeze(String id) {
        this.repository.unfreeze(id);
    }

    public synchronized boolean isFrozen(String id) {
        return this.repository.isFrozen(id);
    }

    public synchronized Collection<FrozenMeta> getAllFrozenMeta() {
        Collection<StockMarketRepository.FrozenMeta> repoMeta = this.repository.getAllFrozenMeta();
        ArrayList<FrozenMeta> result = new ArrayList<FrozenMeta>();
        for (StockMarketRepository.FrozenMeta meta : repoMeta) {
            result.add(new FrozenMeta(meta.id, meta.by, meta.when));
        }
        return Collections.unmodifiableCollection(result);
    }

    public synchronized Set<String> getAllFrozen() {
        return this.repository.getAllFrozen();
    }

    public static class FrozenMeta {
        public final String id;
        public final String by;
        public final long when;

        public FrozenMeta(String id, String by, long when) {
            this.id = id;
            this.by = by;
            this.when = when;
        }
    }
}

