/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class StockManager {
    public static boolean addPlayerStock(Player player, String productId, int amount) {
        if (amount <= 0) {
            return false;
        }
        String id = productId == null ? null : productId.toUpperCase(Locale.ROOT);
        File dataFolder = player.getServer().getPluginManager().getPlugin("EzShops").getDataFolder();
        File playerFile = new File(dataFolder, "player-stocks/" + String.valueOf(player.getUniqueId()) + ".yml");
        if (!playerFile.getParentFile().exists()) {
            playerFile.getParentFile().mkdirs();
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)playerFile);
        int current = yaml.getInt(id, 0);
        yaml.set(id, (Object)(current + amount));
        try {
            yaml.save(playerFile);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean removePlayerStock(Player player, String productId, int amount) {
        YamlConfiguration yaml;
        int current;
        String id = productId == null ? null : productId.toUpperCase(Locale.ROOT);
        File dataFolder = player.getServer().getPluginManager().getPlugin("EzShops").getDataFolder();
        File playerFile = new File(dataFolder, "player-stocks/" + String.valueOf(player.getUniqueId()) + ".yml");
        if (!playerFile.getParentFile().exists()) {
            playerFile.getParentFile().mkdirs();
        }
        if ((current = (yaml = YamlConfiguration.loadConfiguration((File)playerFile)).getInt(id, 0)) < amount) {
            return false;
        }
        int newAmount = current - amount;
        if (newAmount > 0) {
            yaml.set(id, (Object)newAmount);
        } else {
            yaml.set(id, null);
        }
        try {
            yaml.save(playerFile);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static int getPlayerStockAmount(Player player, String productId) {
        String id = productId == null ? null : productId.toUpperCase(Locale.ROOT);
        File dataFolder = player.getServer().getPluginManager().getPlugin("EzShops").getDataFolder();
        File playerFile = new File(dataFolder, "player-stocks/" + String.valueOf(player.getUniqueId()) + ".yml");
        if (!playerFile.exists()) {
            return 0;
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)playerFile);
        return yaml.getInt(id, 0);
    }

    public static List<String> getPlayerOwnedStocks(Player player) {
        File dataFolder = player.getServer().getPluginManager().getPlugin("EzShops").getDataFolder();
        File playerFile = new File(dataFolder, "player-stocks/" + String.valueOf(player.getUniqueId()) + ".yml");
        if (!playerFile.exists()) {
            return Collections.emptyList();
        }
        YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)playerFile);
        ArrayList<String> ownedStocks = new ArrayList<String>();
        for (String key : yaml.getKeys(false)) {
            int amount = yaml.getInt(key, 0);
            if (amount <= 0) continue;
            ownedStocks.add(key);
        }
        return ownedStocks;
    }
}

