/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StockHistoryManager {
    private final Map<String, List<PriceEntry>> history = new ConcurrentHashMap<String, List<PriceEntry>>();
    private static final int MAX_HISTORY = 50;

    public void recordPrice(String productId, double price) {
        String id = productId.toUpperCase(Locale.ROOT);
        this.history.computeIfAbsent(id, k -> new LinkedList());
        List<PriceEntry> entries = this.history.get(id);
        entries.add(new PriceEntry(System.currentTimeMillis(), price));
        if (entries.size() > 50) {
            entries.remove(0);
        }
    }

    public List<PriceEntry> getHistory(String productId) {
        String id = productId.toUpperCase(Locale.ROOT);
        return this.history.getOrDefault(id, Collections.emptyList());
    }

    public static class PriceEntry {
        public final long timestamp;
        public final double price;

        public PriceEntry(long timestamp, double price) {
            this.timestamp = timestamp;
            this.price = price;
        }
    }
}

