/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.EzShopsPlugin;
import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.gui.stock.StockOverviewGui;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StockCommand
implements CommandExecutor {
    private StockOverviewGui stockOverviewGui;
    private final EzShopsPlugin plugin;
    private final StockMarketManager stockMarketManager;
    private final StockMarketConfig stockMarketConfig;
    private final StockMarketFrozenStore frozenStore;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final long cooldownMillis;

    public StockCommand(EzShopsPlugin plugin, StockMarketManager stockMarketManager, long cooldownMillis, StockMarketConfig stockMarketConfig, StockMarketFrozenStore frozenStore) {
        this.plugin = plugin;
        this.stockMarketManager = stockMarketManager;
        this.cooldownMillis = cooldownMillis;
        this.stockMarketConfig = stockMarketConfig;
        this.frozenStore = frozenStore;
        File guiConfigFile = new File(plugin.getDataFolder(), "stock-gui.yml");
        if (plugin.isDebugMode()) {
            plugin.getLogger().info("Loading stock-gui.yml from: " + guiConfigFile.getAbsolutePath());
        }
        if (!guiConfigFile.exists()) {
            plugin.getLogger().warning("stock-gui.yml does not exist at " + guiConfigFile.getAbsolutePath());
        }
        this.stockOverviewGui = new StockOverviewGui(stockMarketManager, stockMarketConfig, frozenStore, guiConfigFile, plugin.isDebugMode());
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock <buy|sell|overview> ...");
            return true;
        }
        String sub = args[0].toLowerCase(Locale.ROOT);
        if (sub.equals("overview")) {
            void player;
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can view the stock market GUI.");
                return true;
            }
            Player player2 = (Player)sender;
            if (!player.hasPermission("ezshops.stock.overview")) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view the stock market.");
                return true;
            }
            this.stockOverviewGui.open((Player)player, "all", 1);
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can buy or sell stocks.");
            return true;
        }
        Player player = (Player)sender;
        if (sub.equals("buy") || sub.equals("sell")) {
            int amount;
            if (!player.hasPermission("ezshops.stock." + sub)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to " + sub + " stocks.");
                return true;
            }
            if (!this.checkCooldown(player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must wait before trading stocks again.");
                return true;
            }
            if (args.length < 3) {
                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock " + sub + " <item> <amount>");
                return true;
            }
            String item = args[1].toUpperCase(Locale.ROOT);
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount.");
                return true;
            }
            if (amount <= 0) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be positive.");
                return true;
            }
            if (this.stockMarketConfig.isBlocked(item)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item is blocked from stock trading.");
                return true;
            }
            if (this.frozenStore.isFrozen(item)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "This item is currently frozen and cannot be traded.");
                return true;
            }
            Material mat = Material.matchMaterial((String)item);
            if (mat == null) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown item: " + item);
                return true;
            }
            if (sub.equals("buy")) {
                this.stockMarketManager.updatePrice(mat.name(), amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought " + amount + " of " + mat.name() + " at " + this.stockMarketManager.getPrice(mat.name()) + " each.");
            } else {
                this.stockMarketManager.updatePrice(mat.name(), -amount);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sold " + amount + " of " + mat.name() + " at " + this.stockMarketManager.getPrice(mat.name()) + " each.");
            }
            this.setCooldown(player);
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stock <buy|sell|overview> ...");
        return true;
    }

    private boolean checkCooldown(Player player) {
        if (this.cooldownMillis <= 0L) {
            return true;
        }
        this.pruneCooldowns();
        long now = System.currentTimeMillis();
        Long last = this.cooldowns.get(player.getUniqueId());
        return last == null || now - last >= this.cooldownMillis;
    }

    private void pruneCooldowns() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<UUID, Long>> iterator = this.cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            UUID playerId = entry.getKey();
            Player onlinePlayer = Bukkit.getPlayer((UUID)playerId);
            if (onlinePlayer != null && onlinePlayer.isOnline() && now - entry.getValue() < this.cooldownMillis) continue;
            iterator.remove();
        }
    }

    private void setCooldown(Player player) {
        if (this.cooldownMillis > 0L) {
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }
}

