/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.stock;

import com.skyblockexp.ezshops.config.StockMarketConfig;
import com.skyblockexp.ezshops.stock.StockMarketFrozenStore;
import com.skyblockexp.ezshops.stock.StockMarketManager;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class StockAdminCommand
implements CommandExecutor {
    private final StockMarketManager stockMarketManager;
    private final StockMarketFrozenStore frozenStore;
    private final StockMarketConfig stockMarketConfig;

    public StockAdminCommand(StockMarketManager stockMarketManager, StockMarketFrozenStore frozenStore, StockMarketConfig stockMarketConfig) {
        this.stockMarketManager = stockMarketManager;
        this.frozenStore = frozenStore;
        this.stockMarketConfig = stockMarketConfig;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (!sender.hasPermission("ezshops.stock.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin <set|reset|freeze|unfreeze|reload|listfrozen|listoverrides> ...");
            return true;
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "set": {
                double price;
                if (!sender.hasPermission("ezshops.stock.admin.set")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.set");
                    return true;
                }
                if (args.length < 3) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin set <item> <price>");
                    return true;
                }
                String item = args[1].toUpperCase(Locale.ROOT);
                try {
                    price = Double.parseDouble(args[2]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid price.");
                    return true;
                }
                if (this.frozenStore.isFrozen(item)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This item is frozen and cannot be changed.");
                    return true;
                }
                this.stockMarketManager.setPrice(item, price);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Set price of " + item + " to " + price);
                break;
            }
            case "reset": {
                if (!sender.hasPermission("ezshops.stock.admin.reset")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.reset");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin reset <item>");
                    return true;
                }
                String item = args[1].toUpperCase(Locale.ROOT);
                if (this.frozenStore.isFrozen(item)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This item is frozen and cannot be reset.");
                    return true;
                }
                this.stockMarketManager.setPrice(item, 100.0);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reset price of " + item + " to 100.0");
                break;
            }
            case "freeze": {
                if (!sender.hasPermission("ezshops.stock.admin.freeze")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.freeze");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin freeze <item>");
                    return true;
                }
                String item = args[1].toUpperCase(Locale.ROOT);
                String by = sender.getName();
                this.frozenStore.freeze(item, by);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Froze " + item + String.valueOf(ChatColor.GRAY) + " by " + by + String.valueOf(ChatColor.GRAY) + " at " + DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format(Instant.ofEpochMilli(System.currentTimeMillis()).atZone(ZoneId.systemDefault())));
                break;
            }
            case "unfreeze": {
                if (!sender.hasPermission("ezshops.stock.admin.unfreeze")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.unfreeze");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin unfreeze <item>");
                    return true;
                }
                String item = args[1].toUpperCase(Locale.ROOT);
                this.frozenStore.unfreeze(item);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Unfroze " + item);
                break;
            }
            case "reload": {
                if (!sender.hasPermission("ezshops.stock.admin.reload")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.reload");
                    return true;
                }
                this.frozenStore.load();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reloaded frozen state from disk.");
                break;
            }
            case "listfrozen": {
                if (!sender.hasPermission("ezshops.stock.admin.listfrozen")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.listfrozen");
                    return true;
                }
                int page = 1;
                int pageSize = 8;
                if (args.length >= 2) {
                    try {
                        page = Math.max(1, Integer.parseInt(args[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ArrayList<StockMarketFrozenStore.FrozenMeta> all = new ArrayList<StockMarketFrozenStore.FrozenMeta>(this.frozenStore.getAllFrozenMeta());
                int totalPages = Math.max(1, (all.size() + pageSize - 1) / pageSize);
                page = Math.min(page, totalPages);
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Frozen Stock Items (" + page + "/" + totalPages + ") ---");
                int start = (page - 1) * pageSize;
                int end = Math.min(start + pageSize, all.size());
                int i = start;
                while (i < end) {
                    StockMarketFrozenStore.FrozenMeta meta = all.get(i);
                    String when = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format(Instant.ofEpochMilli(meta.when).atZone(ZoneId.systemDefault()));
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + meta.id + String.valueOf(ChatColor.GRAY) + " by " + meta.by + String.valueOf(ChatColor.GRAY) + " at " + when);
                    ++i;
                }
                if (totalPages <= 1) break;
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /stockadmin listfrozen <page>");
                break;
            }
            case "listoverrides": {
                if (!sender.hasPermission("ezshops.stock.admin.listoverrides")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission: ezshops.stock.admin.listoverrides");
                    return true;
                }
                int page = 1;
                int pageSize = 8;
                if (args.length >= 2) {
                    try {
                        page = Math.max(1, Integer.parseInt(args[1]));
                    }
                    catch (NumberFormatException all) {
                        // empty catch block
                    }
                }
                ArrayList<StockMarketConfig.OverrideItem> all = new ArrayList<StockMarketConfig.OverrideItem>(this.stockMarketConfig.getAllOverrides());
                int totalPages = Math.max(1, (all.size() + pageSize - 1) / pageSize);
                page = Math.min(page, totalPages);
                sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- Override Stock Items (" + page + "/" + totalPages + ") ---");
                int start = (page - 1) * pageSize;
                int end = Math.min(start + pageSize, all.size());
                int i = start;
                while (i < end) {
                    StockMarketConfig.OverrideItem override = all.get(i);
                    sender.sendMessage(String.valueOf(ChatColor.AQUA) + override.id + String.valueOf(ChatColor.WHITE) + ": " + String.valueOf(ChatColor.GREEN) + override.basePrice + String.valueOf(ChatColor.GRAY) + " (" + override.display + ")");
                    ++i;
                }
                if (totalPages <= 1) break;
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Use /stockadmin listoverrides <page>");
                break;
            }
            default: {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/stockadmin <set|reset|freeze|unfreeze|reload|listfrozen|listoverrides> ...");
            }
        }
        return true;
    }
}

