/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop.sign;

import com.skyblockexp.ezshops.common.CompatibilityUtil;
import com.skyblockexp.ezshops.common.EconomyUtils;
import com.skyblockexp.ezshops.config.ShopSignConfiguration;
import com.skyblockexp.ezshops.shop.ShopPrice;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopSignListener;
import com.skyblockexp.ezshops.shop.ShopTransactionService;
import com.skyblockexp.ezshops.shop.sign.SignShopPlan;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SignShopGenerator {
    private static final int MAX_TARGET_DISTANCE = 5;
    private final JavaPlugin plugin;
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final ShopSignConfiguration signConfiguration;
    private final NamespacedKey actionKey;
    private final NamespacedKey materialKey;
    private final NamespacedKey amountKey;

    public SignShopGenerator(JavaPlugin plugin, ShopPricingManager pricingManager, ShopTransactionService transactionService, ShopSignConfiguration signConfiguration) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.pricingManager = Objects.requireNonNull(pricingManager, "pricingManager");
        this.transactionService = Objects.requireNonNull(transactionService, "transactionService");
        this.signConfiguration = Objects.requireNonNull(signConfiguration, "signConfiguration");
        this.actionKey = new NamespacedKey((Plugin)plugin, "shop_sign_action");
        this.materialKey = new NamespacedKey((Plugin)plugin, "shop_sign_material");
        this.amountKey = new NamespacedKey((Plugin)plugin, "shop_sign_amount");
    }

    public GenerationResult generate(Player player, SignShopPlan plan) {
        if (player == null) {
            return GenerationResult.failure("Only players can generate sign shops.");
        }
        if (plan == null || plan.isEmpty()) {
            return GenerationResult.failure("Add at least one item to the sign shop plan.");
        }
        Block target = player.getTargetBlockExact(5);
        if (target == null) {
            return GenerationResult.failure("Look at a block within range to use as the backing for the first sign shop.");
        }
        BlockFace facing = SignShopGenerator.normalizeHorizontal(player.getFacing().getOppositeFace());
        BlockFace lateral = SignShopGenerator.resolveLateral(facing, plan.direction());
        int horizontalSeparation = Math.max(1, plan.spacing() + 1);
        int verticalSeparation = Math.max(1, plan.rowSpacing() + 1);
        List<ItemStack> entries = plan.items();
        int rows = Math.max(1, plan.rows());
        int columns = Math.max(1, (int)Math.ceil((double)entries.size() / (double)rows));
        ArrayList<Block> backingBlocks = new ArrayList<Block>();
        ArrayList<Block> signBlocks = new ArrayList<Block>();
        ArrayList<Integer> rowIndices = new ArrayList<Integer>();
        int itemIndex = 0;
        int row = 0;
        while (row < rows && itemIndex < entries.size()) {
            Block rowOrigin = target.getRelative(BlockFace.UP, row * verticalSeparation);
            int column = 0;
            while (column < columns && itemIndex < entries.size()) {
                Block backingBlock = rowOrigin.getRelative(lateral, column * horizontalSeparation);
                backingBlocks.add(backingBlock);
                signBlocks.add(backingBlock.getRelative(facing));
                rowIndices.add(row);
                ++itemIndex;
                ++column;
            }
            ++row;
        }
        if (signBlocks.isEmpty()) {
            return GenerationResult.failure("No sign shops were generated. Ensure there is space in front of you and that the items are valid.");
        }
        if (!this.ensureSignSpace(plan.signMaterial(), signBlocks.toArray(new Block[0]))) {
            return GenerationResult.failure("There isn't enough empty space in front of the backing blocks for the planned signs.");
        }
        int created = 0;
        HashSet<Integer> rowsUsed = new HashSet<Integer>();
        int index = 0;
        while (index < signBlocks.size()) {
            ItemStack item = entries.get(index);
            Block backingBlock = (Block)backingBlocks.get(index);
            this.placeBackground(backingBlock, plan.backgroundBlock());
            Block signBlock = (Block)signBlocks.get(index);
            Sign sign = this.placeSign(signBlock, facing, plan.signMaterial());
            if (sign != null) {
                int amount = Math.max(1, Math.min(64, item.getAmount()));
                Material material = item.getType();
                double totalPrice = this.resolveTotalPrice(plan.action(), material, amount);
                this.applySignText(sign, plan.action(), material, amount, totalPrice);
                this.storeSignData(sign, plan.action(), material, amount);
                ++created;
                rowsUsed.add((Integer)rowIndices.get(index));
            }
            ++index;
        }
        if (created <= 0) {
            return GenerationResult.failure("No sign shops were generated. Ensure there is space in front of you and that the items are valid.");
        }
        String extension = plan.direction() == SignShopPlan.LayoutDirection.RIGHT ? "right" : "left";
        int usedRows = Math.max(1, rowsUsed.size());
        String message = String.format(Locale.ENGLISH, "Created %d sign shop%s across %d row%s extending to the %s.", created, created == 1 ? "" : "s", usedRows, usedRows == 1 ? "" : "s", extension);
        return GenerationResult.success(message);
    }

    public boolean formatExistingSign(Sign sign, ShopSignListener.SignAction action, Material material, int amount) {
        if (sign == null || action == null || material == null) {
            return false;
        }
        if (!this.isActionSupported(action, material)) {
            return false;
        }
        int sanitizedAmount = Math.max(1, Math.min(64, amount));
        double totalPrice = this.resolveTotalPrice(action, material, sanitizedAmount);
        this.applySignText(sign, action, material, sanitizedAmount, totalPrice);
        this.storeSignData(sign, action, material, sanitizedAmount);
        return true;
    }

    public boolean isActionSupported(ShopSignListener.SignAction action, Material material) {
        double unit;
        if (material == null) {
            return false;
        }
        Optional<ShopPrice> priceLookup = this.pricingManager.getPrice(material);
        if (priceLookup.isEmpty()) {
            return false;
        }
        ShopPrice price = priceLookup.get();
        double d = unit = action == ShopSignListener.SignAction.BUY ? price.buyPrice() : price.sellPrice();
        return unit >= 0.0;
    }

    void placeBackground(Block backingBlock, Material backgroundMaterial) {
        if (backgroundMaterial == null || backingBlock == null) {
            return;
        }
        if (backingBlock.getType() != backgroundMaterial) {
            backingBlock.setType(backgroundMaterial, false);
        }
    }

    private boolean ensureSignSpace(Material signMaterial, Block ... signBlocks) {
        if (signBlocks == null || signBlocks.length == 0) {
            return false;
        }
        Material targetMaterial = signMaterial == null ? Material.OAK_WALL_SIGN : signMaterial;
        Block[] blockArray = signBlocks;
        int n = signBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            Block signBlock = blockArray[n2];
            if (signBlock == null) {
                return false;
            }
            Material type = signBlock.getType();
            if (type != Material.AIR && type != Material.CAVE_AIR && type != Material.VOID_AIR && type != targetMaterial) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Sign placeSign(Block signBlock, BlockFace facing, Material signMaterial) {
        Material materialToUse = signMaterial == null ? Material.OAK_WALL_SIGN : signMaterial;
        signBlock.setType(materialToUse, false);
        BlockData data = signBlock.getBlockData();
        if (data instanceof WallSign) {
            WallSign wallSign = (WallSign)data;
            wallSign.setFacing(facing);
            signBlock.setBlockData((BlockData)wallSign, false);
        } else if (data instanceof Directional) {
            Directional directional = (Directional)data;
            directional.setFacing(facing);
            signBlock.setBlockData((BlockData)directional, false);
        }
        BlockState state = signBlock.getState();
        if (state instanceof Sign) {
            Sign sign = (Sign)state;
            return sign;
        }
        return null;
    }

    private double resolveTotalPrice(ShopSignListener.SignAction action, Material material, int amount) {
        double unit;
        Optional<ShopPrice> priceLookup = this.pricingManager.getPrice(material);
        if (priceLookup.isEmpty()) {
            return -1.0;
        }
        ShopPrice price = priceLookup.get();
        double d = unit = action == ShopSignListener.SignAction.BUY ? price.buyPrice() : price.sellPrice();
        if (unit < 0.0) {
            return -1.0;
        }
        return EconomyUtils.normalizeCurrency(unit * (double)Math.max(1, amount));
    }

    private void applySignText(Sign sign, ShopSignListener.SignAction action, Material material, int amount, double totalPrice) {
        sign.setLine(0, this.signConfiguration.headerText());
        sign.setLine(1, this.signConfiguration.formatActionLine(action, amount));
        sign.setLine(2, this.signConfiguration.formatItemLine(ShopTransactionService.friendlyMaterialName(material)));
        if (totalPrice < 0.0) {
            sign.setLine(3, this.signConfiguration.unavailableLine());
        } else {
            sign.setLine(3, this.signConfiguration.formatPriceLine(this.transactionService.formatCurrency(totalPrice)));
        }
        sign.update(true);
    }

    private void storeSignData(Sign sign, ShopSignListener.SignAction action, Material material, int amount) {
        PersistentDataContainer container = CompatibilityUtil.getPersistentDataContainer((TileState)sign);
        CompatibilityUtil.set(container, this.actionKey, PersistentDataType.STRING, action.name());
        CompatibilityUtil.set(container, this.materialKey, PersistentDataType.STRING, material.name());
        CompatibilityUtil.set(container, this.amountKey, PersistentDataType.INTEGER, Math.max(1, amount));
        sign.update(true);
    }

    static BlockFace resolveLateral(BlockFace facing, SignShopPlan.LayoutDirection direction) {
        BlockFace normalized = SignShopGenerator.normalizeHorizontal(facing);
        return direction == SignShopPlan.LayoutDirection.RIGHT ? SignShopGenerator.rotateCounterClockwise(normalized) : SignShopGenerator.rotateClockwise(normalized);
    }

    private static BlockFace normalizeHorizontal(BlockFace face) {
        if (face == null) {
            return BlockFace.SOUTH;
        }
        int x = face.getModX();
        int z = face.getModZ();
        if (Math.abs(x) >= Math.abs(z)) {
            return x >= 0 ? BlockFace.EAST : BlockFace.WEST;
        }
        return z >= 0 ? BlockFace.SOUTH : BlockFace.NORTH;
    }

    private static BlockFace rotateClockwise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.NORTH;
            default -> BlockFace.EAST;
        };
    }

    private static BlockFace rotateCounterClockwise(BlockFace face) {
        return switch (face) {
            case BlockFace.NORTH -> BlockFace.WEST;
            case BlockFace.WEST -> BlockFace.SOUTH;
            case BlockFace.SOUTH -> BlockFace.EAST;
            case BlockFace.EAST -> BlockFace.NORTH;
            default -> BlockFace.WEST;
        };
    }

    public record GenerationResult(boolean success, String message) {
        public static GenerationResult success(String message) {
            return new GenerationResult(true, message);
        }

        public static GenerationResult failure(String message) {
            return new GenerationResult(false, message);
        }
    }
}

