/*
 * Decompiled with CFR 0.152.
 */
package com.skyblockexp.ezshops.shop.command;

import com.skyblockexp.ezshops.config.ShopMessageConfiguration;
import com.skyblockexp.ezshops.gui.ShopMenu;
import com.skyblockexp.ezshops.shop.ShopMenuLayout;
import com.skyblockexp.ezshops.shop.ShopPricingManager;
import com.skyblockexp.ezshops.shop.ShopTransactionResult;
import com.skyblockexp.ezshops.shop.ShopTransactionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ShopCommand
implements CommandExecutor,
TabCompleter {
    private final ShopPricingManager pricingManager;
    private final ShopTransactionService transactionService;
    private final ShopMenu shopMenu;
    private final ShopMessageConfiguration.CommandMessages.ShopCommandMessages messages;
    private final ShopMessageConfiguration.TransactionMessages.ErrorMessages errorMessages;
    private final ShopMessageConfiguration.TransactionMessages.RestrictionMessages restrictionMessages;

    public ShopCommand(ShopPricingManager pricingManager, ShopTransactionService transactionService, ShopMenu shopMenu, ShopMessageConfiguration.CommandMessages.ShopCommandMessages messages, ShopMessageConfiguration.TransactionMessages.ErrorMessages errorMessages, ShopMessageConfiguration.TransactionMessages.RestrictionMessages restrictionMessages) {
        this.pricingManager = pricingManager;
        this.transactionService = transactionService;
        this.shopMenu = shopMenu;
        this.messages = messages;
        this.errorMessages = errorMessages;
        this.restrictionMessages = restrictionMessages;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ShopTransactionResult result;
        void player;
        if (args.length > 0 && "reload".equalsIgnoreCase(args[0])) {
            if (!sender.hasPermission("ezshops.reload")) {
                sender.sendMessage("\u00a7cYou do not have permission to reload EzShops.");
                return true;
            }
            try {
                this.pricingManager.reload();
                if (this.shopMenu != null) {
                    this.shopMenu.refreshViewers();
                }
                sender.sendMessage("\u00a7aEzShops configuration reloaded successfully.");
            }
            catch (Exception ex) {
                sender.sendMessage("\u00a7cFailed to reload EzShops: " + ex.getMessage());
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.playersOnly());
            return true;
        }
        Player ex = (Player)sender;
        if (args.length == 0 || args.length == 1 && args[0].trim().isEmpty()) {
            if (this.shopMenu != null) {
                this.shopMenu.openMainMenu((Player)player);
            } else {
                player.sendMessage(this.messages.menuDisabled());
            }
            return true;
        }
        if (args.length < 2) {
            this.sendUsage((Player)player, label);
            return true;
        }
        String action = args[0].toLowerCase(Locale.ENGLISH);
        String materialName = args[1];
        Material material = Material.matchMaterial((String)materialName, (boolean)false);
        if (material == null) {
            player.sendMessage(this.messages.unknownItem(materialName));
            return true;
        }
        int amount = 1;
        if (args.length >= 3) {
            try {
                amount = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex2) {
                player.sendMessage(this.messages.invalidAmount(args[2]));
                return true;
            }
        }
        if (amount <= 0) {
            player.sendMessage(this.messages.amountMustBePositive());
            return true;
        }
        switch (action) {
            case "buy": {
                result = this.handleBuy((Player)player, material, amount);
                break;
            }
            case "sell": {
                result = this.transactionService.sell((Player)player, material, amount);
                break;
            }
            default: {
                this.sendUsage((Player)player, label);
                return true;
            }
        }
        player.sendMessage(result.message());
        return true;
    }

    private void sendUsage(Player player, String label) {
        for (String line : this.messages.usage(label)) {
            player.sendMessage(line);
        }
    }

    private ShopTransactionResult handleBuy(Player player, Material material, int amount) {
        ShopMenuLayout.ItemType itemType = this.pricingManager.getItemType(material);
        return switch (itemType) {
            case ShopMenuLayout.ItemType.MATERIAL -> this.transactionService.buy(player, material, amount);
            case ShopMenuLayout.ItemType.MINION_CRATE_KEY -> this.executeCrateKeyPurchase(player, material, amount, ShopMenuLayout.ItemType.MINION_CRATE_KEY);
            case ShopMenuLayout.ItemType.VOTE_CRATE_KEY -> this.executeCrateKeyPurchase(player, material, amount, ShopMenuLayout.ItemType.VOTE_CRATE_KEY);
            case ShopMenuLayout.ItemType.ENCHANTED_BOOK -> ShopTransactionResult.failure(this.restrictionMessages.enchantedBookMenuOnly());
            case ShopMenuLayout.ItemType.MINION_HEAD -> ShopTransactionResult.failure(this.restrictionMessages.minionHeadCrateOnly());
            case ShopMenuLayout.ItemType.SPAWNER -> ShopTransactionResult.failure(this.restrictionMessages.spawnerMenuOnly());
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private ShopTransactionResult executeCrateKeyPurchase(Player player, Material material, int amount, ShopMenuLayout.ItemType itemType) {
        return this.pricingManager.getPrice(material).map(price -> {
            if (!price.canBuy()) {
                return ShopTransactionResult.failure(this.errorMessages.notBuyable());
            }
            double unitPrice = price.buyPrice();
            return itemType == ShopMenuLayout.ItemType.MINION_CRATE_KEY ? this.transactionService.buyMinionCrateKey(player, unitPrice, amount) : this.transactionService.buyVoteCrateKey(player, unitPrice, amount);
        }).orElseGet(() -> ShopTransactionResult.failure(this.errorMessages.notConfigured()));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return this.filterCompletions(args[0], List.of("buy", "sell", "reload"));
        }
        if (args.length == 2) {
            String action = args[0].toLowerCase(Locale.ENGLISH);
            if (action.equals("buy")) {
                return this.filterBuyMaterials(args[1], this.pricingManager.getBuyableMaterials());
            }
            if (action.equals("sell")) {
                return this.filterMaterials(args[1], this.pricingManager.getSellableMaterials());
            }
        }
        if (args.length == 3) {
            return this.filterCompletions(args[2], List.of("1", "16", "32", "64"));
        }
        return Collections.emptyList();
    }

    private List<String> filterCompletions(String current, List<String> completions) {
        if (current.isEmpty()) {
            return completions;
        }
        String lowerCurrent = current.toLowerCase(Locale.ENGLISH);
        ArrayList<String> matches = new ArrayList<String>();
        for (String completion : completions) {
            if (!completion.toLowerCase(Locale.ENGLISH).startsWith(lowerCurrent)) continue;
            matches.add(completion);
        }
        return matches;
    }

    private List<String> filterBuyMaterials(String current, Collection<Material> materials) {
        ArrayList<String> completions = new ArrayList<String>();
        String lowerCurrent = current.toLowerCase(Locale.ENGLISH);
        for (Material material : materials) {
            String name;
            if (!this.isDirectBuySupported(material) || !(name = material.name().toLowerCase(Locale.ENGLISH)).startsWith(lowerCurrent)) continue;
            completions.add(name);
        }
        return completions;
    }

    private boolean isDirectBuySupported(Material material) {
        ShopMenuLayout.ItemType type = this.pricingManager.getItemType(material);
        return switch (type) {
            case ShopMenuLayout.ItemType.MATERIAL, ShopMenuLayout.ItemType.MINION_CRATE_KEY, ShopMenuLayout.ItemType.VOTE_CRATE_KEY -> true;
            default -> false;
        };
    }

    private List<String> filterMaterials(String current, Collection<Material> materials) {
        ArrayList<String> completions = new ArrayList<String>();
        String lowerCurrent = current.toLowerCase(Locale.ENGLISH);
        for (Material material : materials) {
            String name = material.name().toLowerCase(Locale.ENGLISH);
            if (!name.startsWith(lowerCurrent)) continue;
            completions.add(name);
        }
        return completions;
    }
}

